/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.client.models;

import com.jamiedev.bygone.common.entity.CopperbugEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Animal;

public class CopperbugModel<C extends Animal>
extends EntityModel<CopperbugEntity> {
    private final ModelPart body1;
    private final ModelPart body2;
    private final ModelPart body3;
    private final ModelPart body4;
    private final ModelPart pincerRight;
    private final ModelPart pincerLeft;

    public CopperbugModel(ModelPart root) {
        this.body1 = root.getChild("body1");
        this.body2 = root.getChild("body2");
        this.body3 = root.getChild("body3");
        this.body4 = root.getChild("body4");
        this.pincerRight = root.getChild("pincerRight");
        this.pincerLeft = root.getChild("pincerLeft");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition body1 = modelPartData.addOrReplaceChild("body1", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -2.0f, 2.0f, 6.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)24.0f, (float)-7.0f));
        PartDefinition body2 = modelPartData.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(0, 8).addBox(-2.5f, -2.0f, 0.0f, 5.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body3 = modelPartData.addOrReplaceChild("body3", CubeListBuilder.create().texOffs(0, 15).addBox(-2.0f, -2.0f, 4.0f, 4.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body4 = modelPartData.addOrReplaceChild("body4", CubeListBuilder.create().texOffs(0, 21).addBox(-1.5f, -1.0f, 7.0f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition pincerRight = modelPartData.addOrReplaceChild("pincerRight", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition pincerRight_r1 = pincerRight.addOrReplaceChild("pincerRight_r1", CubeListBuilder.create().texOffs(15, 15).addBox(-1.0f, -1.0f, -5.0f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)-5.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition pincerLeft = modelPartData.addOrReplaceChild("pincerLeft", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition pincerLeft_r1 = pincerLeft.addOrReplaceChild("pincerLeft_r1", CubeListBuilder.create().texOffs(19, 8).addBox(0.0f, -0.5f, -5.0f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-0.5f, (float)-5.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)32, (int)32);
    }

    public void setupAnim(CopperbugEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        int i = 0;
        while ((float)i < this.body1.xRot) {
            this.body1.yRot = Mth.cos((float)(animationProgress * 0.9f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * 0.05f * (float)(1 + Math.abs(i - 2));
            this.body1.x = Mth.sin((float)(animationProgress * 0.9f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * 0.2f * (float)Math.abs(i - 2);
            ++i;
        }
        i = 0;
        while ((float)i < this.body2.xRot) {
            this.body2.yRot = Mth.cos((float)(animationProgress * 0.9f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * 0.05f * (float)(1 + Math.abs(i - 2));
            this.body2.x = Mth.sin((float)(animationProgress * 0.9f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * 0.2f * (float)Math.abs(i - 2);
            ++i;
        }
        i = 0;
        while ((float)i < this.body3.xRot) {
            this.body3.yRot = Mth.cos((float)(animationProgress * 0.9f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * 0.05f * (float)(1 + Math.abs(i - 2));
            this.body3.x = Mth.sin((float)(animationProgress * 0.9f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * 0.2f * (float)Math.abs(i - 2);
            ++i;
        }
        i = 0;
        while ((float)i < this.body4.xRot) {
            this.body4.yRot = Mth.cos((float)(animationProgress * 0.9f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * 0.05f * (float)(1 + Math.abs(i - 2));
            this.body4.x = Mth.sin((float)(animationProgress * 0.9f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * 0.2f * (float)Math.abs(i - 2);
            ++i;
        }
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertexConsumer, int light, int overlay, int color) {
        this.body1.render(matrices, vertexConsumer, light, overlay, color);
        this.body2.render(matrices, vertexConsumer, light, overlay, color);
        this.body3.render(matrices, vertexConsumer, light, overlay, color);
        this.body4.render(matrices, vertexConsumer, light, overlay, color);
        this.pincerRight.render(matrices, vertexConsumer, light, overlay, color);
        this.pincerLeft.render(matrices, vertexConsumer, light, overlay, color);
    }
}

