/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.client.models;

import com.jamiedev.bygone.common.entity.FungalParentEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EndermanModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class FungalParentModel<T extends LivingEntity>
extends HumanoidModel<FungalParentEntity> {
    private final ModelPart right_leg;
    EndermanModel ref;
    private final ModelPart right_arm;
    private final ModelPart left_leg;
    private final ModelPart left_arm;
    private final ModelPart hat;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart head_child;

    public FungalParentModel(ModelPart root) {
        super(root);
        this.right_leg = root.getChild("right_leg");
        this.right_arm = root.getChild("right_arm");
        this.left_leg = root.getChild("left_leg");
        this.left_arm = root.getChild("left_arm");
        this.hat = root.getChild("hat");
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.head_child = root.getChild("head_child");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition right_leg = modelPartData.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(47, 36).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)9.0f, (float)0.0f));
        PartDefinition right_arm = modelPartData.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(38, 36).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 23.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)-2.0f, (float)0.0f));
        PartDefinition left_leg = modelPartData.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 52).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)9.0f, (float)0.0f));
        PartDefinition left_arm = modelPartData.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(29, 36).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 23.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.0f, (float)-3.0f, (float)0.0f));
        PartDefinition hat = modelPartData.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(9, 52).addBox(-9.0f, 0.0f, -9.0f, 2.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(19, 52).addBox(7.0f, 0.0f, -9.0f, 2.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(14, 52).addBox(-9.0f, 0.0f, 9.0f, 2.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(49, 21).addBox(7.0f, 0.0f, 9.0f, 2.0f, 14.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 21).addBox(-6.0f, -4.0f, -6.0f, 12.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition body = modelPartData.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 36).addBox(-5.0f, -27.0f, -2.0f, 10.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = modelPartData.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-9.0f, -2.0f, -9.0f, 18.0f, 2.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition head_child = modelPartData.addOrReplaceChild("head_child", CubeListBuilder.create().texOffs(92, 1).addBox(-5.0f, -5.5f, -4.0f, 10.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)128, (int)128);
    }

    public void setupAnim(FungalParentEntity livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.hat.visible = !livingEntity.isBaby();
        this.head_child.visible = livingEntity.isBaby();
        this.head.visible = !livingEntity.isBaby();
        this.left_arm.visible = !livingEntity.isBaby();
        this.right_arm.visible = !livingEntity.isBaby();
        this.head_child.x = this.head.x;
        this.head_child.y = this.head.y;
        this.head_child.z = this.head.z;
        this.head_child.xRot = this.head.xRot;
        this.head_child.yRot = this.head.yRot;
        this.head_child.zRot = this.head.zRot;
        this.hat.x = this.head.x;
        this.hat.y = this.head.y;
        this.hat.z = this.head.z;
        this.hat.xRot = this.head.xRot;
        this.hat.yRot = this.head.yRot;
        this.hat.zRot = this.head.zRot;
        ModelPart var10000 = this.right_leg;
        var10000.xRot -= 0.0f;
        var10000 = this.left_leg;
        var10000.xRot -= 0.0f;
        var10000 = this.right_arm;
        var10000.xRot *= 0.5f;
        var10000 = this.left_arm;
        var10000.xRot *= 0.5f;
        var10000 = this.right_leg;
        var10000.xRot *= 0.5f;
        var10000 = this.left_leg;
        var10000.xRot *= 0.5f;
        if (this.right_arm.xRot > 0.4f) {
            this.right_arm.xRot = 0.4f;
        }
        if (this.left_arm.xRot > 0.4f) {
            this.left_arm.xRot = 0.4f;
        }
        if (this.right_arm.xRot < -0.4f) {
            this.right_arm.xRot = -0.4f;
        }
        if (this.left_arm.xRot < -0.4f) {
            this.left_arm.xRot = -0.4f;
        }
        if (this.right_leg.xRot > 0.4f) {
            this.right_leg.xRot = 0.4f;
        }
        if (this.left_leg.xRot > 0.4f) {
            this.left_leg.xRot = 0.4f;
        }
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertexConsumer, int light, int overlay, int color) {
        this.right_leg.render(matrices, vertexConsumer, light, overlay, color);
        this.right_arm.render(matrices, vertexConsumer, light, overlay, color);
        this.left_leg.render(matrices, vertexConsumer, light, overlay, color);
        this.left_arm.render(matrices, vertexConsumer, light, overlay, color);
        this.hat.render(matrices, vertexConsumer, light, overlay, color);
        this.body.render(matrices, vertexConsumer, light, overlay, color);
        this.head.render(matrices, vertexConsumer, light, overlay, color);
        this.head_child.render(matrices, vertexConsumer, light, overlay, color);
    }
}

