/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class MoobooModel<T extends Entity>
extends EntityModel<T> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;
    private final ModelPart leg4;

    public MoobooModel(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.leg1 = root.getChild("leg1");
        this.leg2 = root.getChild("leg2");
        this.leg3 = root.getChild("leg3");
        this.leg4 = root.getChild("leg4");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition ModelPartData = meshdefinition.getRoot();
        PartDefinition head = ModelPartData.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -19.0f, -6.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(22, 0).addBox(4.0f, -20.0f, -4.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(22, 0).addBox(-5.0f, -20.0f, -4.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition body = ModelPartData.addOrReplaceChild("body", CubeListBuilder.create().texOffs(18, 4).addBox(-6.0f, -10.0f, 6.0f, 12.0f, 18.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(52, 0).addBox(-2.0f, 2.0f, 5.0f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)2.0f, (float)1.5708f, (float)0.0f, (float)-3.1416f));
        PartDefinition leg1 = ModelPartData.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 1.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)12.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition leg2 = ModelPartData.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 1.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)12.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition leg3 = ModelPartData.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 1.0f, -1.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)12.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition leg4 = ModelPartData.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 1.0f, -1.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)12.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public void setupAnim(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.leg4.xRot = Mth.cos((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
        this.leg3.xRot = Mth.cos((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance;
        this.leg2.xRot = Mth.cos((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance;
        this.leg1.xRot = Mth.cos((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
    }
}

