/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.client.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class SablossomParticle
extends TextureSheetParticle {
    protected SablossomParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.friction = 0.96f;
        this.speedUpWhenYMotionIsBlocked = true;
        this.quadSize *= 0.75f;
        this.xd *= (double)0.8f;
        this.yd *= (double)0.8f;
        this.zd *= (double)0.8f;
    }

    public void tick() {
        super.tick();
        if (!this.level.getBlockState(BlockPos.containing((double)this.x, (double)this.y, (double)this.z)).isAir()) {
            this.remove();
        } else {
            this.setAlpha(SablossomParticle.magic(this.clamp(this.age), 0.3f, 0.5f));
            if (Math.random() > 0.95 || this.age == 1) {
                this.setParticleSpeed((double)-0.05f + (double)0.1f * Math.random(), (double)-0.05f + (double)0.1f * Math.random(), (double)-0.05f + (double)0.1f * Math.random());
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public int getLightColor(float partialTick) {
        float f = ((float)this.age + partialTick) / (float)this.lifetime;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        int i = super.getLightColor(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    private float clamp(float f) {
        return Mth.clamp((float)(f / (float)this.lifetime), (float)0.0f, (float)1.0f);
    }

    private static float magic(float f, float g, float h) {
        if (f >= 1.0f - g) {
            return (1.0f - f) / g;
        }
        return f <= h ? f / h : 1.0f;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SablossomParticle fireflyParticle = new SablossomParticle(level, x, y, z, 0.5 - level.random.nextDouble(), level.random.nextBoolean() ? ySpeed : -ySpeed, 0.5 - level.random.nextDouble());
            fireflyParticle.setLifetime(level.random.nextIntBetweenInclusive(200, 300));
            fireflyParticle.scale(1.5f);
            fireflyParticle.pickSprite(this.spriteProvider);
            fireflyParticle.setAlpha(0.0f);
            return fireflyParticle;
        }
    }
}

