/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block;

import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public interface AncientCaveVines {
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final BooleanProperty BERRIES = BlockStateProperties.BERRIES;

    public static InteractionResult pickBerries(@Nullable Entity picker, BlockState state, Level world, BlockPos pos) {
        if (((Boolean)state.getValue((Property)BERRIES)).booleanValue()) {
            float f = Mth.randomBetween((RandomSource)world.random, (float)0.8f, (float)1.2f);
            world.playSound(null, pos, SoundEvents.CAVE_VINES_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, f);
            BlockState blockState = (BlockState)state.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(false));
            world.setBlock(pos, blockState, 2);
            world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)picker, (BlockState)blockState));
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public static boolean hasBerries(BlockState state) {
        return state.hasProperty((Property)BERRIES) && (Boolean)state.getValue((Property)BERRIES) != false;
    }

    public static ToIntFunction<BlockState> getLuminanceSupplier(int luminance) {
        return state -> (Boolean)state.getValue((Property)BlockStateProperties.BERRIES) != false ? luminance : 0;
    }
}

