/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block;

import com.jamiedev.bygone.common.block.entity.BlemishSpreadManager;
import com.jamiedev.bygone.common.block.entity.BlemishSpreadable;
import com.jamiedev.bygone.core.init.JamiesModTag;
import com.jamiedev.bygone.core.registry.BGBlocks;
import com.mojang.serialization.MapCodec;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class BlemishVeinBlock
extends MultifaceBlock
implements BlemishSpreadable,
SimpleWaterloggedBlock {
    public static final MapCodec<BlemishVeinBlock> CODEC = BlemishVeinBlock.simpleCodec(BlemishVeinBlock::new);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final MultifaceSpreader allGrowTypeGrower = new MultifaceSpreader((MultifaceSpreader.SpreadConfig)new BlemishVeinGrowChecker(this, this, MultifaceSpreader.DEFAULT_SPREAD_ORDER));
    private final MultifaceSpreader samePositionOnlyGrower = new MultifaceSpreader((MultifaceSpreader.SpreadConfig)new BlemishVeinGrowChecker(this, this, MultifaceSpreader.SpreadType.SAME_POSITION));

    public MapCodec<BlemishVeinBlock> codec() {
        return CODEC;
    }

    public BlemishVeinBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public MultifaceSpreader getSpreader() {
        return this.allGrowTypeGrower;
    }

    public MultifaceSpreader getSamePositionOnlyGrower() {
        return this.samePositionOnlyGrower;
    }

    public static boolean place(LevelAccessor world, BlockPos pos, BlockState state, Collection<Direction> directions) {
        boolean bl = false;
        BlockState blockState = BGBlocks.BLEMISH_VEIN.get().defaultBlockState();
        for (Direction direction : directions) {
            BlockPos blockPos;
            if (!BlemishVeinBlock.canAttachTo((BlockGetter)world, (Direction)direction, (BlockPos)(blockPos = pos.relative(direction)), (BlockState)world.getBlockState(blockPos))) continue;
            blockState = (BlockState)blockState.setValue((Property)BlemishVeinBlock.getFaceProperty((Direction)direction), (Comparable)Boolean.valueOf(true));
            bl = true;
        }
        if (!bl) {
            return false;
        }
        if (!state.getFluidState().isEmpty()) {
            blockState = (BlockState)blockState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        world.setBlock(pos, blockState, 3);
        return true;
    }

    @Override
    public void spreadAtSamePosition(LevelAccessor world, BlockState state, BlockPos pos, @NotNull RandomSource random) {
        if (state.is((Block)this)) {
            for (Direction direction : DIRECTIONS) {
                BooleanProperty booleanProperty = BlemishVeinBlock.getFaceProperty((Direction)direction);
                if (!((Boolean)state.getValue((Property)booleanProperty)).booleanValue() || !world.getBlockState(pos.relative(direction)).is(BGBlocks.BLEMISH.get())) continue;
                state = (BlockState)state.setValue((Property)booleanProperty, (Comparable)Boolean.valueOf(false));
            }
            if (!BlemishVeinBlock.hasAnyFace((BlockState)state)) {
                FluidState fluidState = world.getFluidState(pos);
                state = (fluidState.isEmpty() ? Blocks.AIR : Blocks.WATER).defaultBlockState();
            }
            world.setBlock(pos, state, 3);
            BlemishSpreadable.super.spreadAtSamePosition(world, state, pos, random);
        }
    }

    @Override
    public int spread(BlemishSpreadManager.Cursor cursor, LevelAccessor world, BlockPos catalystPos, @NotNull RandomSource random, BlemishSpreadManager spreadManager, boolean shouldConvertToBlock) {
        if (shouldConvertToBlock && this.convertToBlock(spreadManager, world, cursor.getPos(), random)) {
            return cursor.getCharge() - 1;
        }
        return random.nextInt(spreadManager.getSpreadChance()) == 0 ? Mth.floor((float)((float)cursor.getCharge() * 0.5f)) : cursor.getCharge();
    }

    private boolean convertToBlock(BlemishSpreadManager spreadManager, LevelAccessor world, BlockPos pos, @NotNull RandomSource random) {
        BlockState blockState = world.getBlockState(pos);
        TagKey<Block> tagKey = spreadManager.getReplaceableTag();
        for (Direction direction : Direction.allShuffled((RandomSource)random)) {
            BlockPos blockPos;
            BlockState blockState2;
            if (!BlemishVeinBlock.hasFace((BlockState)blockState, (Direction)direction) || !(blockState2 = world.getBlockState(blockPos = pos.relative(direction))).is(tagKey)) continue;
            BlockState blockState3 = BGBlocks.BLEMISH.get().defaultBlockState();
            world.setBlock(blockPos, blockState3, 3);
            Block.pushEntitiesUp((BlockState)blockState2, (BlockState)blockState3, (LevelAccessor)world, (BlockPos)blockPos);
            world.playSound(null, blockPos, SoundEvents.SCULK_BLOCK_SPREAD, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.allGrowTypeGrower.spreadAll(blockState3, world, blockPos, spreadManager.isWorldGen());
            Direction direction2 = direction.getOpposite();
            for (Direction direction3 : DIRECTIONS) {
                BlockPos blockPos2;
                BlockState blockState4;
                if (direction3 == direction2 || !(blockState4 = world.getBlockState(blockPos2 = blockPos.relative(direction3))).is((Block)this)) continue;
                this.spreadAtSamePosition(world, blockState4, blockPos2, random);
            }
            return true;
        }
        return false;
    }

    public static boolean veinCoversBlemishReplaceable(LevelAccessor world, BlockState state, BlockPos pos) {
        if (!state.is(BGBlocks.BLEMISH_VEIN.get())) {
            return false;
        }
        for (Direction direction : DIRECTIONS) {
            if (!BlemishVeinBlock.hasFace((BlockState)state, (Direction)direction) || !world.getBlockState(pos.relative(direction)).is(JamiesModTag.BLEMISH_REPLACEABLE)) continue;
            return true;
        }
        return false;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return !context.getItemInHand().is(Item.byBlock((Block)BGBlocks.BLEMISH_VEIN.get())) || super.canBeReplaced(state, context);
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    private class BlemishVeinGrowChecker
    extends MultifaceSpreader.DefaultSpreaderConfig {
        private final MultifaceSpreader.SpreadType[] growTypes;

        public BlemishVeinGrowChecker(BlemishVeinBlock blemishVeinBlock, BlemishVeinBlock BlemishVeinBlock2, MultifaceSpreader.SpreadType ... growTypes) {
            super((MultifaceBlock)BlemishVeinBlock2);
            this.growTypes = growTypes;
        }

        public boolean stateCanBeReplaced(BlockGetter world, BlockPos pos, BlockPos growPos, Direction direction, BlockState state) {
            BlockState blockState = world.getBlockState(growPos.relative(direction));
            if (!(blockState.is(BGBlocks.BLEMISH.get()) || blockState.is(BGBlocks.BLEMISH_CATALYST.get()) || blockState.is(Blocks.MOVING_PISTON))) {
                BlockPos blockPos;
                if (pos.distManhattan((Vec3i)growPos) == 2 && world.getBlockState(blockPos = pos.relative(direction.getOpposite())).isFaceSturdy(world, blockPos, direction)) {
                    return false;
                }
                FluidState fluidState = state.getFluidState();
                if (!fluidState.isEmpty() && !fluidState.is((Fluid)Fluids.WATER)) {
                    return false;
                }
                if (state.is(BlockTags.FIRE)) {
                    return false;
                }
                return state.canBeReplaced() || super.stateCanBeReplaced(world, pos, growPos, direction, state);
            }
            return false;
        }

        public MultifaceSpreader.SpreadType[] getSpreadTypes() {
            return this.growTypes;
        }

        public boolean isOtherBlockValidAsSource(BlockState state) {
            return !state.is(BGBlocks.BLEMISH_VEIN.get());
        }
    }
}

