/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block;

import com.google.common.base.Predicates;
import com.jamiedev.bygone.core.registry.BGBlocks;
import com.mojang.serialization.MapCodec;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BygonePortalFrameBlock
extends Block {
    public static final MapCodec<BygonePortalFrameBlock> CODEC = BygonePortalFrameBlock.simpleCodec(BygonePortalFrameBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty EYE = BlockStateProperties.EYE;
    protected static final VoxelShape FRAME_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    protected static final VoxelShape EYE_SHAPE = Block.box((double)4.0, (double)13.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape FRAME_WITH_EYE_SHAPE = Shapes.or((VoxelShape)FRAME_SHAPE, (VoxelShape)EYE_SHAPE);
    private static BlockPattern COMPLETED_FRAME;

    public MapCodec<BygonePortalFrameBlock> codec() {
        return CODEC;
    }

    public BygonePortalFrameBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)EYE, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)EYE) != false ? FRAME_WITH_EYE_SHAPE : FRAME_SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)EYE, (Comparable)Boolean.valueOf(false));
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return (Boolean)state.getValue((Property)EYE) != false ? 15 : 0;
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, EYE});
    }

    public static BlockPattern getCompletedFramePattern() {
        if (COMPLETED_FRAME == null) {
            COMPLETED_FRAME = BlockPatternBuilder.start().aisle(new String[]{"?vvv?", ">???<", ">???<", ">???<", "?^^^?"}).where('?', BlockInWorld.hasState((Predicate)BlockStatePredicate.ANY)).where('^', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)BGBlocks.BYGONE_PORTAL_FRAME.get()).where((Property)EYE, (Predicate)Predicates.equalTo((Object)true)).where((Property)FACING, (Predicate)Predicates.equalTo((Object)Direction.SOUTH)))).where('>', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)BGBlocks.BYGONE_PORTAL_FRAME.get()).where((Property)EYE, (Predicate)Predicates.equalTo((Object)true)).where((Property)FACING, (Predicate)Predicates.equalTo((Object)Direction.WEST)))).where('v', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)BGBlocks.BYGONE_PORTAL_FRAME.get()).where((Property)EYE, (Predicate)Predicates.equalTo((Object)true)).where((Property)FACING, (Predicate)Predicates.equalTo((Object)Direction.NORTH)))).where('<', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)BGBlocks.BYGONE_PORTAL_FRAME.get()).where((Property)EYE, (Predicate)Predicates.equalTo((Object)true)).where((Property)FACING, (Predicate)Predicates.equalTo((Object)Direction.EAST)))).build();
        }
        return COMPLETED_FRAME;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

