/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block;

import com.google.common.annotations.VisibleForTesting;
import com.jamiedev.bygone.common.block.LandingBlock2;
import com.jamiedev.bygone.common.entity.RisingBlockEntity;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointedAmberBlock
extends Block
implements LandingBlock2,
SimpleWaterloggedBlock {
    PointedDripstoneBlock ref;
    public static final MapCodec<PointedAmberBlock> CODEC = PointedAmberBlock.simpleCodec(PointedAmberBlock::new);
    public static final DirectionProperty VERTICAL_DIRECTION = BlockStateProperties.VERTICAL_DIRECTION;
    public static final EnumProperty<DripstoneThickness> THICKNESS = BlockStateProperties.DRIPSTONE_THICKNESS;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final int field_31205 = 11;
    private static final int field_31207 = 2;
    private static final float field_31208 = 0.02f;
    private static final float field_31209 = 0.12f;
    private static final int field_31210 = 11;
    private static final float WATER_DRIP_CHANCE = 0.17578125f;
    private static final float LAVA_DRIP_CHANCE = 0.05859375f;
    private static final double field_31213 = 0.6;
    private static final float field_31214 = 1.0f;
    private static final int field_31215 = 40;
    private static final int field_31200 = 6;
    private static final float field_31201 = 2.0f;
    private static final int field_31202 = 2;
    private static final float field_33566 = 5.0f;
    private static final float field_33567 = 0.011377778f;
    private static final int MAX_STALACTITE_GROWTH = 7;
    private static final int STALACTITE_FLOOR_SEARCH_RANGE = 10;
    private static final float field_31203 = 0.6875f;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape UP_TIP_SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape DOWN_TIP_SHAPE = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape BASE_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final float field_31204 = 0.125f;
    private static final VoxelShape DRIP_COLLISION_SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public MapCodec<PointedAmberBlock> codec() {
        return CODEC;
    }

    public PointedAmberBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)VERTICAL_DIRECTION, (Comparable)Direction.UP)).setValue(THICKNESS, (Comparable)DripstoneThickness.TIP)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{VERTICAL_DIRECTION, THICKNESS, WATERLOGGED});
    }

    protected boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return PointedAmberBlock.canPlaceAtWithDirection(world, pos, (Direction)state.getValue((Property)VERTICAL_DIRECTION));
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (direction != Direction.UP && direction != Direction.DOWN) {
            return state;
        }
        Direction direction2 = (Direction)state.getValue((Property)VERTICAL_DIRECTION);
        if (direction2 == Direction.DOWN && world.getBlockTicks().hasScheduledTick(pos, (Object)this)) {
            return state;
        }
        if (direction == direction2.getOpposite() && !this.canSurvive(state, (LevelReader)world, pos)) {
            if (direction2 == Direction.DOWN) {
                world.scheduleTick(pos, (Block)this, 2);
            } else {
                world.scheduleTick(pos, (Block)this, 1);
            }
            return state;
        }
        boolean bl = state.getValue(THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness thickness = PointedAmberBlock.getThickness((LevelReader)world, pos, direction2, bl);
        return (BlockState)state.setValue(THICKNESS, (Comparable)thickness);
    }

    protected void onProjectileHit(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockPos;
        if (!world.isClientSide && projectile.mayInteract(world, blockPos = hit.getBlockPos()) && projectile.mayBreak(world) && projectile instanceof ThrownTrident && projectile.getDeltaMovement().length() > 0.6) {
            world.destroyBlock(blockPos, true);
        }
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (state.getValue((Property)VERTICAL_DIRECTION) == Direction.UP && state.getValue(THICKNESS) == DripstoneThickness.TIP) {
            entity.causeFallDamage(fallDistance + 2.0f, 2.0f, world.damageSources().stalagmite());
        } else {
            super.fallOn(world, state, pos, entity, fallDistance);
        }
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, @NotNull RandomSource random) {
        float f;
        if (PointedAmberBlock.canDrip(state) && !((f = random.nextFloat()) > 0.12f)) {
            PointedAmberBlock.getFluid(world, pos, state).filter(fluid -> f < 0.02f || PointedAmberBlock.isFluidLiquid(fluid.fluid)).ifPresent(fluid -> PointedAmberBlock.createParticle(world, pos, state, fluid.fluid));
        }
    }

    protected void tick(BlockState state, ServerLevel world, BlockPos pos, @NotNull RandomSource random) {
        if (PointedAmberBlock.isPointingDown(state) && !this.canSurvive(state, (LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        } else {
            PointedAmberBlock.spawnRisingBlock(state, world, pos);
        }
    }

    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, @NotNull RandomSource random) {
        PointedAmberBlock.dripTick(state, world, pos, random.nextFloat());
        if (random.nextFloat() < 0.011377778f && PointedAmberBlock.isHeldByPointedAmber(state, (LevelReader)world, pos)) {
            PointedAmberBlock.tryGrow(state, world, pos, random);
        }
    }

    @VisibleForTesting
    public static void dripTick(BlockState state, ServerLevel world, BlockPos pos, float dripChance) {
        Optional<DrippingFluid> optional;
        if (!(dripChance > 0.17578125f) && PointedAmberBlock.isHeldByPointedAmber(state, (LevelReader)world, pos) && (optional = PointedAmberBlock.getFluid((Level)world, pos, state)).isPresent()) {
            BlockPos blockPos;
            float f;
            Fluid fluid = optional.get().fluid;
            if (fluid == Fluids.WATER) {
                f = 0.17578125f;
            } else {
                if (fluid != Fluids.LAVA) {
                    return;
                }
                f = 0.05859375f;
            }
            if (!(dripChance >= f) && (blockPos = PointedAmberBlock.getTipPos(state, (LevelAccessor)world, pos, 11, false)) != null) {
                if (optional.get().state.is(Blocks.MUD) && fluid == Fluids.WATER) {
                    BlockState blockState = Blocks.CLAY.defaultBlockState();
                    world.setBlockAndUpdate(optional.get().pos, blockState);
                    Block.pushEntitiesUp((BlockState)optional.get().state, (BlockState)blockState, (LevelAccessor)world, (BlockPos)optional.get().pos);
                    world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, optional.get().pos, GameEvent.Context.of((BlockState)blockState));
                    world.levelEvent(1504, blockPos, 0);
                } else {
                    BlockPos blockPos2 = PointedAmberBlock.getCauldronPos((Level)world, blockPos, fluid);
                    if (blockPos2 != null) {
                        world.levelEvent(1504, blockPos, 0);
                        int i = blockPos.getY() - blockPos2.getY();
                        int j = 50 + i;
                        BlockState blockState2 = world.getBlockState(blockPos2);
                        world.scheduleTick(blockPos2, blockState2.getBlock(), j);
                    }
                }
            }
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction direction;
        BlockPos blockPos;
        Level worldAccess = ctx.getLevel();
        Direction direction2 = PointedAmberBlock.getDirectionToPlaceAt((LevelReader)worldAccess, blockPos = ctx.getClickedPos(), direction = ctx.getNearestLookingVerticalDirection().getOpposite());
        if (direction2 == null) {
            return null;
        }
        boolean bl = !ctx.isSecondaryUseActive();
        DripstoneThickness thickness = PointedAmberBlock.getThickness((LevelReader)worldAccess, blockPos, direction2, bl);
        return thickness == null ? null : (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)VERTICAL_DIRECTION, (Comparable)direction2)).setValue(THICKNESS, (Comparable)thickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldAccess.getFluidState(blockPos).getType() == Fluids.WATER));
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter world, BlockPos pos) {
        return Shapes.empty();
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        DripstoneThickness thickness = (DripstoneThickness)state.getValue(THICKNESS);
        VoxelShape voxelShape = thickness == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (thickness == DripstoneThickness.TIP ? (state.getValue((Property)VERTICAL_DIRECTION) == Direction.DOWN ? DOWN_TIP_SHAPE : UP_TIP_SHAPE) : (thickness == DripstoneThickness.FRUSTUM ? BASE_SHAPE : (thickness == DripstoneThickness.MIDDLE ? FRUSTUM_SHAPE : MIDDLE_SHAPE)));
        Vec3 vec3d = state.getOffset(world, pos);
        return voxelShape.move(vec3d.x, 0.0, vec3d.z);
    }

    protected boolean isCollisionShapeFullBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    protected float getMaxHorizontalOffset() {
        return 0.125f;
    }

    @Override
    public void onDestroyedOnLanding(Level world, BlockPos pos, RisingBlockEntity fallingBlockEntity) {
        if (!fallingBlockEntity.isSilent()) {
            world.levelEvent(9045, pos, 0);
        }
    }

    @Override
    public DamageSource getFallDamageSource(Entity attacker) {
        return attacker.damageSources().fallingStalactite(attacker);
    }

    private static void spawnFallingBlock(BlockState state, ServerLevel world, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        BlockState blockState = state;
        while (PointedAmberBlock.isPointingDown(blockState)) {
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.fall((Level)world, (BlockPos)mutable, (BlockState)blockState);
            if (PointedAmberBlock.isTip(blockState, true)) {
                int i = Math.max(1 + pos.getY() - mutable.getY(), 6);
                float f = i;
                fallingBlockEntity.setHurtsEntities(f, 40);
                break;
            }
            mutable.move(Direction.DOWN);
            blockState = world.getBlockState((BlockPos)mutable);
        }
    }

    private static void spawnRisingBlock(BlockState state, ServerLevel world, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        BlockState blockState = state;
        while (PointedAmberBlock.isPointingUp(blockState)) {
            RisingBlockEntity fallingBlockEntity = RisingBlockEntity.fall((Level)world, (BlockPos)mutable, blockState);
            if (PointedAmberBlock.isTip(blockState, true)) {
                int i = Math.max(1 + pos.getY() - mutable.getY(), 6);
                float f = i;
                fallingBlockEntity.setHurtsEntities(f, 40);
                break;
            }
            mutable.move(Direction.UP);
            blockState = world.getBlockState((BlockPos)mutable);
        }
    }

    @VisibleForTesting
    public static void tryGrow(BlockState state, ServerLevel world, BlockPos pos, @NotNull RandomSource random) {
        BlockState blockState3;
        BlockPos blockPos;
        BlockState blockState2;
        BlockState blockState = world.getBlockState(pos.above(1));
        if (PointedAmberBlock.canGrow(blockState, blockState2 = world.getBlockState(pos.above(2))) && (blockPos = PointedAmberBlock.getTipPos(state, (LevelAccessor)world, pos, 7, false)) != null && PointedAmberBlock.canDrip(blockState3 = world.getBlockState(blockPos)) && PointedAmberBlock.canGrow(blockState3, world, blockPos)) {
            if (random.nextBoolean()) {
                PointedAmberBlock.tryGrow(world, blockPos, Direction.DOWN);
            } else {
                PointedAmberBlock.tryGrowStalagmite(world, blockPos);
            }
        }
    }

    private static void tryGrowStalagmite(ServerLevel world, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        for (int i = 0; i < 10; ++i) {
            mutable.move(Direction.DOWN);
            BlockState blockState = world.getBlockState((BlockPos)mutable);
            if (!blockState.getFluidState().isEmpty()) {
                return;
            }
            if (PointedAmberBlock.isTip(blockState, Direction.UP) && PointedAmberBlock.canGrow(blockState, world, (BlockPos)mutable)) {
                PointedAmberBlock.tryGrow(world, (BlockPos)mutable, Direction.UP);
                return;
            }
            if (PointedAmberBlock.canPlaceAtWithDirection((LevelReader)world, (BlockPos)mutable, Direction.UP) && !world.isWaterAt(mutable.below())) {
                PointedAmberBlock.tryGrow(world, mutable.below(), Direction.UP);
                return;
            }
            if (PointedAmberBlock.canDripThrough((BlockGetter)world, (BlockPos)mutable, blockState)) continue;
            return;
        }
    }

    private static void tryGrow(ServerLevel world, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.relative(direction);
        BlockState blockState = world.getBlockState(blockPos);
        if (PointedAmberBlock.isTip(blockState, direction.getOpposite())) {
            PointedAmberBlock.growMerged(blockState, (LevelAccessor)world, blockPos);
        } else if (blockState.isAir() || blockState.is(Blocks.WATER)) {
            PointedAmberBlock.place((LevelAccessor)world, blockPos, direction, DripstoneThickness.TIP);
        }
    }

    private static void place(LevelAccessor world, BlockPos pos, Direction direction, DripstoneThickness thickness) {
        BlockState blockState = (BlockState)((BlockState)((BlockState)Blocks.POINTED_DRIPSTONE.defaultBlockState().setValue((Property)VERTICAL_DIRECTION, (Comparable)direction)).setValue(THICKNESS, (Comparable)thickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos).getType() == Fluids.WATER));
        world.setBlock(pos, blockState, 3);
    }

    private static void growMerged(BlockState state, LevelAccessor world, BlockPos pos) {
        BlockPos blockPos2;
        BlockPos blockPos;
        if (state.getValue((Property)VERTICAL_DIRECTION) == Direction.UP) {
            blockPos = pos;
            blockPos2 = pos.above();
        } else {
            blockPos2 = pos;
            blockPos = pos.below();
        }
        PointedAmberBlock.place(world, blockPos2, Direction.DOWN, DripstoneThickness.TIP_MERGE);
        PointedAmberBlock.place(world, blockPos, Direction.UP, DripstoneThickness.TIP_MERGE);
    }

    public static void createParticle(Level world, BlockPos pos, BlockState state) {
        PointedAmberBlock.getFluid(world, pos, state).ifPresent(fluid -> PointedAmberBlock.createParticle(world, pos, state, fluid.fluid));
    }

    private static void createParticle(Level world, BlockPos pos, BlockState state, Fluid fluid) {
        Vec3 vec3d = state.getOffset((BlockGetter)world, pos);
        double d = 0.0625;
        double e = (double)pos.getX() + 0.5 + vec3d.x;
        double f = (double)((float)(pos.getY() + 1) - 0.6875f) - 0.0625;
        double g = (double)pos.getZ() + 0.5 + vec3d.z;
        Fluid fluid2 = PointedAmberBlock.getDripFluid(world, fluid);
        SimpleParticleType particleEffect = fluid2.is(FluidTags.LAVA) ? ParticleTypes.DRIPPING_DRIPSTONE_LAVA : ParticleTypes.DRIPPING_DRIPSTONE_WATER;
        world.addParticle((ParticleOptions)particleEffect, e, f, g, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPos getTipPos(BlockState state, LevelAccessor world, BlockPos pos, int range, boolean allowMerged) {
        if (PointedAmberBlock.isTip(state, allowMerged)) {
            return pos;
        }
        Direction direction = (Direction)state.getValue((Property)VERTICAL_DIRECTION);
        BiPredicate<BlockPos, BlockState> biPredicate = (posx, statex) -> statex.is(Blocks.POINTED_DRIPSTONE) && statex.getValue((Property)VERTICAL_DIRECTION) == direction;
        return PointedAmberBlock.searchInDirection(world, pos, direction.getAxisDirection(), biPredicate, statex -> PointedAmberBlock.isTip(statex, allowMerged), range).orElse(null);
    }

    @Nullable
    private static Direction getDirectionToPlaceAt(LevelReader world, BlockPos pos, Direction direction) {
        Direction direction2;
        if (PointedAmberBlock.canPlaceAtWithDirection(world, pos, direction)) {
            direction2 = direction;
        } else {
            if (!PointedAmberBlock.canPlaceAtWithDirection(world, pos, direction.getOpposite())) {
                return null;
            }
            direction2 = direction.getOpposite();
        }
        return direction2;
    }

    private static DripstoneThickness getThickness(LevelReader world, BlockPos pos, Direction direction, boolean tryMerge) {
        Direction direction2 = direction.getOpposite();
        BlockState blockState = world.getBlockState(pos.relative(direction));
        if (PointedAmberBlock.isPointedAmberFacingDirection(blockState, direction2)) {
            return !tryMerge && blockState.getValue(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!PointedAmberBlock.isPointedAmberFacingDirection(blockState, direction)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness thickness = (DripstoneThickness)blockState.getValue(THICKNESS);
        if (thickness != DripstoneThickness.TIP && thickness != DripstoneThickness.TIP_MERGE) {
            BlockState blockState2 = world.getBlockState(pos.relative(direction2));
            return !PointedAmberBlock.isPointedAmberFacingDirection(blockState2, direction) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public static boolean canDrip(BlockState state) {
        return PointedAmberBlock.isPointingDown(state) && state.getValue(THICKNESS) == DripstoneThickness.TIP && (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    private static boolean canGrow(BlockState state, ServerLevel world, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)VERTICAL_DIRECTION);
        BlockPos blockPos = pos.relative(direction);
        BlockState blockState = world.getBlockState(blockPos);
        if (!blockState.getFluidState().isEmpty()) {
            return false;
        }
        return blockState.isAir() || PointedAmberBlock.isTip(blockState, direction.getOpposite());
    }

    private static Optional<BlockPos> getSupportingPos(Level world, BlockPos pos, BlockState state, int range) {
        Direction direction = (Direction)state.getValue((Property)VERTICAL_DIRECTION);
        BiPredicate<BlockPos, BlockState> biPredicate = (posx, statex) -> statex.is(Blocks.POINTED_DRIPSTONE) && statex.getValue((Property)VERTICAL_DIRECTION) == direction;
        return PointedAmberBlock.searchInDirection((LevelAccessor)world, pos, direction.getOpposite().getAxisDirection(), biPredicate, statex -> !statex.is(Blocks.POINTED_DRIPSTONE), range);
    }

    private static boolean canPlaceAtWithDirection(LevelReader world, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.relative(direction.getOpposite());
        BlockState blockState = world.getBlockState(blockPos);
        return blockState.isFaceSturdy((BlockGetter)world, blockPos, direction) || PointedAmberBlock.isPointedAmberFacingDirection(blockState, direction);
    }

    private static boolean isTip(BlockState state, boolean allowMerged) {
        if (!state.is(Blocks.POINTED_DRIPSTONE)) {
            return false;
        }
        DripstoneThickness thickness = (DripstoneThickness)state.getValue(THICKNESS);
        return thickness == DripstoneThickness.TIP || allowMerged && thickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isTip(BlockState state, Direction direction) {
        return PointedAmberBlock.isTip(state, false) && state.getValue((Property)VERTICAL_DIRECTION) == direction;
    }

    private static boolean isPointingDown(BlockState state) {
        return PointedAmberBlock.isPointedAmberFacingDirection(state, Direction.DOWN);
    }

    private static boolean isPointingUp(BlockState state) {
        return PointedAmberBlock.isPointedAmberFacingDirection(state, Direction.UP);
    }

    private static boolean isHeldByPointedAmber(BlockState state, LevelReader world, BlockPos pos) {
        return PointedAmberBlock.isPointingDown(state) && !world.getBlockState(pos.above()).is(Blocks.POINTED_DRIPSTONE);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    private static boolean isPointedAmberFacingDirection(BlockState state, Direction direction) {
        return state.is(Blocks.POINTED_DRIPSTONE) && state.getValue((Property)VERTICAL_DIRECTION) == direction;
    }

    @Nullable
    private static BlockPos getCauldronPos(Level world, BlockPos pos, Fluid fluid) {
        Predicate<BlockState> predicate = state -> state.getBlock() instanceof AbstractCauldronBlock;
        BiPredicate<BlockPos, BlockState> biPredicate = (posx, state) -> PointedAmberBlock.canDripThrough((BlockGetter)world, posx, state);
        return PointedAmberBlock.searchInDirection((LevelAccessor)world, pos, Direction.DOWN.getAxisDirection(), biPredicate, predicate, 11).orElse(null);
    }

    @Nullable
    public static BlockPos getDripPos(Level world, BlockPos pos) {
        BiPredicate<BlockPos, BlockState> biPredicate = (posx, state) -> PointedAmberBlock.canDripThrough((BlockGetter)world, posx, state);
        return PointedAmberBlock.searchInDirection((LevelAccessor)world, pos, Direction.UP.getAxisDirection(), biPredicate, PointedAmberBlock::canDrip, 11).orElse(null);
    }

    public static Fluid getDripFluid(ServerLevel world, BlockPos pos) {
        return PointedAmberBlock.getFluid((Level)world, pos, world.getBlockState(pos)).map(fluid -> fluid.fluid).filter(PointedAmberBlock::isFluidLiquid).orElse(Fluids.EMPTY);
    }

    private static Optional<DrippingFluid> getFluid(Level world, BlockPos pos, BlockState state) {
        return !PointedAmberBlock.isPointingDown(state) ? Optional.empty() : PointedAmberBlock.getSupportingPos(world, pos, state, 11).map(posx -> {
            BlockPos blockPos = posx.above();
            BlockState blockState = world.getBlockState(blockPos);
            Object fluid = blockState.is(Blocks.MUD) && !world.dimensionType().ultraWarm() ? Fluids.WATER : world.getFluidState(blockPos).getType();
            return new DrippingFluid(blockPos, (Fluid)fluid, blockState);
        });
    }

    private static boolean isFluidLiquid(Fluid fluid) {
        return fluid == Fluids.LAVA || fluid == Fluids.WATER;
    }

    private static boolean canGrow(BlockState dripstoneBlockState, BlockState waterState) {
        return dripstoneBlockState.is(Blocks.DRIPSTONE_BLOCK) && waterState.is(Blocks.WATER) && waterState.getFluidState().isSource();
    }

    private static Fluid getDripFluid(Level world, Fluid fluid) {
        if (fluid.isSame(Fluids.EMPTY)) {
            return world.dimensionType().ultraWarm() ? Fluids.LAVA : Fluids.WATER;
        }
        return fluid;
    }

    private static Optional<BlockPos> searchInDirection(LevelAccessor world, BlockPos pos, Direction.AxisDirection direction, BiPredicate<BlockPos, BlockState> continuePredicate, Predicate<BlockState> stopPredicate, int range) {
        Direction direction2 = Direction.get((Direction.AxisDirection)direction, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos mutable = pos.mutable();
        for (int i = 1; i < range; ++i) {
            mutable.move(direction2);
            BlockState blockState = world.getBlockState((BlockPos)mutable);
            if (stopPredicate.test(blockState)) {
                return Optional.of(mutable.immutable());
            }
            if (!world.isOutsideBuildHeight(mutable.getY()) && continuePredicate.test((BlockPos)mutable, blockState)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean canDripThrough(BlockGetter world, BlockPos pos, BlockState state) {
        if (state.isAir()) {
            return true;
        }
        if (state.isSolidRender(world, pos)) {
            return false;
        }
        if (!state.getFluidState().isEmpty()) {
            return false;
        }
        VoxelShape voxelShape = state.getCollisionShape(world, pos);
        return !Shapes.joinIsNotEmpty((VoxelShape)DRIP_COLLISION_SHAPE, (VoxelShape)voxelShape, (BooleanOp)BooleanOp.AND);
    }

    record DrippingFluid(BlockPos pos, Fluid fluid, BlockState state) {
    }
}

