/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block;

import com.jamiedev.bygone.common.block.entity.PrimordialUrchinEntity;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrimordialUrchinBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<PrimordialUrchinBlock> CODEC = PrimordialUrchinBlock.simpleCodec(PrimordialUrchinBlock::new);
    public static final IntegerProperty ACTIVATED;
    public static BooleanProperty ACTIVATEDBOOL;
    public static final VoxelShape SHAPE;
    public static final BooleanProperty WATERLOGGED;
    public static boolean test;

    public MapCodec<PrimordialUrchinBlock> codec() {
        return CODEC;
    }

    public PrimordialUrchinBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACTIVATED, (Comparable)Integer.valueOf(0))).setValue((Property)ACTIVATEDBOOL, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected static boolean isInWater(BlockState state, BlockGetter world, BlockPos pos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            return true;
        }
        for (Direction direction : Direction.values()) {
            if (!world.getFluidState(pos.relative(direction)).is(FluidTags.WATER)) continue;
            return true;
        }
        return false;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void tick(BlockState state, ServerLevel world, BlockPos pos, @NotNull RandomSource random) {
        if (!PrimordialUrchinBlock.isInWater(state, (BlockGetter)world, pos)) {
            world.setBlock(pos, (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    private static void updateState(BlockState state, Level world, BlockPos pos) {
        boolean bl = (Boolean)state.getValue((Property)ACTIVATEDBOOL);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.getLevel().getFluidState(ctx.getClickedPos());
        BlockState blockState = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        return blockState;
    }

    private void updatePowered(Level world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        boolean bl = (Boolean)blockState.getValue((Property)ACTIVATEDBOOL);
        boolean bl2 = false;
        List list = world.getEntities(null, blockState.getShape((BlockGetter)world, pos).bounds().move(pos));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.isIgnoringBlockTriggers()) continue;
                bl2 = true;
                break;
            }
        }
        if (bl2 != bl) {
            blockState = (BlockState)blockState.setValue((Property)ACTIVATEDBOOL, (Comparable)Boolean.valueOf(bl2));
            world.setBlock(pos, blockState, 3);
        }
        if (bl2) {
            world.scheduleTick(new BlockPos((Vec3i)pos), (Block)this, 10);
        }
    }

    protected void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!world.isClientSide && world.getDifficulty() != Difficulty.PEACEFUL && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!(((Boolean)state.getValue((Property)ACTIVATEDBOOL)).booleanValue() || livingEntity.isInvulnerableTo(world.damageSources().cactus()) || livingEntity.hasInfiniteMaterials())) {
                world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.PUFFER_FISH_BLOW_UP, SoundSource.BLOCKS, 0.5f + world.random.nextFloat(), world.random.nextFloat() * 0.7f + 0.6f, false);
                BlockState blockState = (BlockState)state.cycle((Property)ACTIVATEDBOOL);
                world.setBlock(pos, blockState, 2);
                world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)blockState));
                PrimordialUrchinBlock.updateState(blockState, world, pos);
                test = true;
                entity.hurt(world.damageSources().cactus(), 1.0f);
                livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 10));
            }
        }
        super.entityInside(state, world, pos, entity);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PrimordialUrchinEntity(pos, state);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVATEDBOOL, ACTIVATED, WATERLOGGED});
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    static {
        test = false;
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
        ACTIVATED = BlockStateProperties.POWER;
        ACTIVATEDBOOL = BlockStateProperties.INVERTED;
        SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    }
}

