/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block;

import com.jamiedev.bygone.core.registry.BGBlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.NetherVines;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SableBranchBlock
extends GrowingPlantHeadBlock {
    public static final MapCodec<SableBranchBlock> CODEC = SableBranchBlock.simpleCodec(SableBranchBlock::new);
    public static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0);

    public MapCodec<SableBranchBlock> codec() {
        return CODEC;
    }

    public SableBranchBlock(BlockBehaviour.Properties p_154864_) {
        super(p_154864_, Direction.UP, SHAPE, false, 5.0E-5);
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource p_222649_) {
        return NetherVines.getBlocksToGrowWhenBonemealed((RandomSource)p_222649_);
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        LivingEntity livingentity;
        Vec3 vec3 = new Vec3((double)0.85f, 0.75, (double)0.85f);
        if (entity instanceof LivingEntity && (livingentity = (LivingEntity)entity).hasEffect(MobEffects.MOVEMENT_SPEED)) {
            vec3 = new Vec3((double)0.95f, (double)0.85f, (double)0.95f);
        }
        entity.makeStuckInBlock(state, vec3);
    }

    protected Block getBodyBlock() {
        return BGBlocks.SABLE_BRANCH_PLANT.get();
    }

    protected boolean canGrowInto(BlockState p_154869_) {
        return NetherVines.isValidGrowthState((BlockState)p_154869_);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.relative(this.growthDirection.getOpposite());
        BlockState blockstate = level.getBlockState(blockpos);
        return this.canAttachTo(blockstate) && (blockstate.is((Block)this.getHeadBlock()) || blockstate.is(this.getBodyBlock()) || blockstate.is(BGBlocks.SABLE_LEAVES.get()) || blockstate.isFaceSturdy((BlockGetter)level, blockpos, this.growthDirection));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.getValue((Property)AGE) == 5;
    }
}

