/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block;

import com.jamiedev.bygone.core.registry.BGBlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ThornySableBranchPlantBlock
extends GrowingPlantBodyBlock {
    public static final MapCodec<ThornySableBranchPlantBlock> CODEC = ThornySableBranchPlantBlock.simpleCodec(ThornySableBranchPlantBlock::new);
    public static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public MapCodec<ThornySableBranchPlantBlock> codec() {
        return CODEC;
    }

    public ThornySableBranchPlantBlock(BlockBehaviour.Properties p_154873_) {
        super(p_154873_, Direction.UP, SHAPE, false);
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        LivingEntity livingentity;
        Vec3 vec3 = new Vec3(0.75, (double)0.65f, 0.75);
        if (entity instanceof LivingEntity && (livingentity = (LivingEntity)entity).hasEffect(MobEffects.MOVEMENT_SPEED)) {
            vec3 = new Vec3((double)0.95f, (double)0.85f, (double)0.95f);
        }
        entity.makeStuckInBlock(state, vec3);
        entity.hurt(level.damageSources().cactus(), 2.0f);
    }

    protected GrowingPlantHeadBlock getHeadBlock() {
        return (GrowingPlantHeadBlock)BGBlocks.THORNY_SABLE_BRANCH.get();
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.relative(this.growthDirection.getOpposite());
        BlockState blockstate = level.getBlockState(blockpos);
        return !this.canAttachTo(blockstate) ? false : blockstate.is((Block)this.getHeadBlock()) || blockstate.is(this.getBodyBlock()) || blockstate.is(BGBlocks.SABLE_LEAVES.get()) || blockstate.isFaceSturdy((BlockGetter)level, blockpos, this.growthDirection);
    }
}

