/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block.entity;

import com.google.common.collect.Lists;
import com.jamiedev.bygone.common.block.CopperbugNestBlock;
import com.jamiedev.bygone.common.entity.CopperbugEntity;
import com.jamiedev.bygone.core.init.JamiesModTag;
import com.jamiedev.bygone.core.registry.BGBlockEntities;
import com.jamiedev.bygone.core.registry.BGDataComponentTypes;
import com.jamiedev.bygone.core.registry.BGEntityTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class CopperbugNestBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String FLOWER_POS_KEY = "flower_pos";
    private static final String COPPERBUGS_KEY = "copperbugs";
    static final List<String> IRRELEVANT_COPPERBUG_NBT_KEYS = Arrays.asList("Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "SleepingX", "SleepingY", "SleepingZ", "CannotEnterNestTicks", "TicksSincePollination", "CropsGrownSincePollination", "Nest_pos", "Passengers", "leash", "UUID");
    public static final int MAX_COPPERBUG_COUNT = 3;
    private static final int ANGERED_CANNOT_ENTER_NEST_TICKS = 400;
    private static final int MIN_OCCUPATION_TICKS_WITH_NECTAR = 2400;
    public static final int MIN_OCCUPATION_TICKS_WITHOUT_NECTAR = 600;
    private final List<Copperbug> copperbugs = Lists.newArrayList();
    @Nullable
    private BlockPos flowerPos;

    public CopperbugNestBlockEntity(BlockPos pos, BlockState state) {
        super(BGBlockEntities.COPPERBUGNEST.get(), pos, state);
    }

    public void setChanged() {
        if (this.isNearFire()) {
            this.angerCopperbugs(null, this.level.getBlockState(this.getBlockPos()), CopperbugState.EMERGENCY);
        }
        super.setChanged();
    }

    public boolean isNearFire() {
        BlockPos blockPos;
        if (this.level == null) {
            return false;
        }
        Iterator var1 = BlockPos.betweenClosed((BlockPos)this.worldPosition.offset(-1, -1, -1), (BlockPos)this.worldPosition.offset(1, 1, 1)).iterator();
        do {
            if (var1.hasNext()) continue;
            return false;
        } while (!(this.level.getBlockState(blockPos = (BlockPos)var1.next()).getBlock() instanceof FireBlock));
        return true;
    }

    public boolean hasNoCopperbugs() {
        return this.copperbugs.isEmpty();
    }

    public boolean isFullOfCopperbugs() {
        return this.copperbugs.size() == 3;
    }

    public void angerCopperbugs(@Nullable Player player, BlockState state, CopperbugState beeState) {
        List<Entity> list = this.tryReleaseCopperbug(state, beeState);
        if (player != null) {
            for (Entity entity : list) {
                if (!(entity instanceof CopperbugEntity)) continue;
                CopperbugEntity beeEntity = (CopperbugEntity)entity;
                if (!(player.position().distanceToSqr(entity.position()) <= 16.0)) continue;
                if (!this.isSmoked()) {
                    beeEntity.setTarget((LivingEntity)player);
                    continue;
                }
                beeEntity.setCannotEnterNestTicks(400);
            }
        }
    }

    private List<Entity> tryReleaseCopperbug(BlockState state, CopperbugState beeState) {
        ArrayList list = Lists.newArrayList();
        this.copperbugs.removeIf(bee -> CopperbugNestBlockEntity.releaseCopperbug(this.level, this.worldPosition, state, bee.createData(), list, beeState, this.flowerPos));
        if (!list.isEmpty()) {
            super.setChanged();
        }
        return list;
    }

    @VisibleForDebug
    public int getCopperbugCount() {
        return this.copperbugs.size();
    }

    public static int getOxidizationLevel(BlockState state) {
        return (Integer)state.getValue((Property)CopperbugNestBlock.OXIDIZATION_LEVEL);
    }

    @VisibleForDebug
    public boolean isSmoked() {
        return CampfireBlock.isSmokeyPos((Level)this.level, (BlockPos)this.getBlockPos());
    }

    public void tryEnterNest(Entity entity) {
        if (this.copperbugs.size() < 15) {
            entity.stopRiding();
            entity.ejectPassengers();
            this.addCopperbug(CopperbugData.of(entity));
            if (this.level != null) {
                CopperbugEntity beeEntity;
                if (entity instanceof CopperbugEntity && (beeEntity = (CopperbugEntity)entity).hasCopperBlock() && (!this.hasCopperBlockPos() || this.level.random.nextBoolean())) {
                    this.flowerPos = beeEntity.getCopperBlockPos();
                }
                BlockPos blockPos = this.getBlockPos();
                this.level.playSound(null, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), SoundEvents.COPPER_BULB_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)entity, (BlockState)this.getBlockState()));
            }
            entity.discard();
            super.setChanged();
        }
    }

    public void addCopperbug(CopperbugData bee) {
        this.copperbugs.add(new Copperbug(bee));
    }

    private static boolean releaseCopperbug(Level world, BlockPos pos, BlockState state, CopperbugData bee, @Nullable List<Entity> entities, CopperbugState beeState, @Nullable BlockPos flowerPos) {
        boolean bl;
        if ((world.isNight() || world.isRaining()) && beeState != CopperbugState.EMERGENCY) {
            return false;
        }
        Direction direction = (Direction)state.getValue((Property)CopperbugNestBlock.FACING);
        BlockPos blockPos = pos.relative(direction);
        boolean bl2 = bl = !world.getBlockState(blockPos).getCollisionShape((BlockGetter)world, blockPos).isEmpty();
        if (bl && beeState != CopperbugState.EMERGENCY) {
            return false;
        }
        Entity entity = bee.loadEntity(world, pos);
        if (entity != null) {
            if (entity instanceof CopperbugEntity) {
                CopperbugEntity beeEntity = (CopperbugEntity)entity;
                if (flowerPos != null && !beeEntity.hasCopperBlock() && world.random.nextFloat() < 0.9f) {
                    beeEntity.setCopperBlockPos(flowerPos);
                }
                if (beeState == CopperbugState.HONEY_DELIVERED) {
                    int i;
                    beeEntity.onOxidizationDelivered();
                    if (state.is(JamiesModTag.COPPERBUGNESTS, statex -> statex.hasProperty((Property)CopperbugNestBlock.OXIDIZATION_LEVEL)) && (i = CopperbugNestBlockEntity.getOxidizationLevel(state)) < 5) {
                        int j;
                        int n = j = world.random.nextInt(100) == 0 ? 2 : 1;
                        if (i + j > 5) {
                            --j;
                        }
                        world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CopperbugNestBlock.OXIDIZATION_LEVEL, (Comparable)Integer.valueOf(i + j)));
                    }
                }
                if (entities != null) {
                    entities.add((Entity)beeEntity);
                }
                float f = entity.getBbWidth();
                double d = bl ? 0.0 : 0.55 + (double)(f / 2.0f);
                double e = (double)pos.getX() + 0.5 + d * (double)direction.getStepX();
                double g = (double)pos.getY() + 0.5 - (double)(entity.getBbHeight() / 2.0f);
                double h = (double)pos.getZ() + 0.5 + d * (double)direction.getStepZ();
                entity.moveTo(e, g, h, entity.getYRot(), entity.getXRot());
            }
            world.playSound(null, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)world.getBlockState(pos)));
            return world.addFreshEntity(entity);
        }
        return false;
    }

    private boolean hasCopperBlockPos() {
        return this.flowerPos != null;
    }

    private static void tickCopperbugs(Level world, BlockPos pos, BlockState state, List<Copperbug> copperbugs, @Nullable BlockPos flowerPos) {
        boolean bl = false;
        Iterator<Copperbug> iterator = copperbugs.iterator();
        while (iterator.hasNext()) {
            CopperbugState beeState;
            Copperbug bee = iterator.next();
            if (!bee.canExitNest()) continue;
            CopperbugState copperbugState = beeState = bee.hasNectar() ? CopperbugState.HONEY_DELIVERED : CopperbugState.COPPERBUG_RELEASED;
            if (!CopperbugNestBlockEntity.releaseCopperbug(world, pos, state, bee.createData(), null, beeState, flowerPos)) continue;
            bl = true;
            iterator.remove();
        }
        if (bl) {
            CopperbugNestBlockEntity.setChanged((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, CopperbugNestBlockEntity blockEntity) {
        CopperbugNestBlockEntity.tickCopperbugs(world, pos, state, blockEntity.copperbugs, blockEntity.flowerPos);
        if (!blockEntity.copperbugs.isEmpty() && world.getRandom().nextDouble() < 0.005) {
            double d = (double)pos.getX() + 0.5;
            double e = pos.getY();
            double f = (double)pos.getZ() + 0.5;
            world.playSound(null, d, e, f, SoundEvents.COPPER_GRATE_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.copperbugs.clear();
        if (nbt.contains(COPPERBUGS_KEY)) {
            CopperbugData.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get(COPPERBUGS_KEY)).resultOrPartial(string -> LOGGER.error("Failed to parse copperbugs: '{}'", string)).ifPresent(list -> list.forEach(this::addCopperbug));
        }
        this.flowerPos = NbtUtils.readBlockPos((CompoundTag)nbt, (String)FLOWER_POS_KEY).orElse(null);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.put(COPPERBUGS_KEY, (Tag)CopperbugData.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.createCopperbugsData()).getOrThrow());
        if (this.hasCopperBlockPos()) {
            nbt.put(FLOWER_POS_KEY, NbtUtils.writeBlockPos((BlockPos)this.flowerPos));
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        super.applyImplicitComponents(components);
        this.copperbugs.clear();
        List list = (List)components.getOrDefault(BGDataComponentTypes.COPPERBUGS, List.of());
        list.forEach(this::addCopperbug);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder componentMapBuilder) {
        super.collectImplicitComponents(componentMapBuilder);
        componentMapBuilder.set(BGDataComponentTypes.COPPERBUGS, this.createCopperbugsData());
    }

    public void removeComponentsFromTag(CompoundTag nbt) {
        super.removeComponentsFromTag(nbt);
        nbt.remove(COPPERBUGS_KEY);
    }

    private List<CopperbugData> createCopperbugsData() {
        return this.copperbugs.stream().map(Copperbug::createData).toList();
    }

    public static enum CopperbugState {
        HONEY_DELIVERED,
        COPPERBUG_RELEASED,
        EMERGENCY;

    }

    public record CopperbugData(CustomData entityData, int ticksInNest, int minTicksInNest) {
        static CustomData nbt;
        static int minTicksInNests;
        public static final Codec<CopperbugData> CODEC;
        public static final Codec<List<CopperbugData>> LIST_CODEC;
        public static final StreamCodec<ByteBuf, CopperbugData> PACKET_CODEC;

        public CopperbugData(CustomData entityData, int ticksInNest, int minTicksInNest) {
            nbt = entityData;
            this.entityData = entityData;
            this.ticksInNest = ticksInNest;
            minTicksInNests = minTicksInNest;
            this.minTicksInNest = minTicksInNest;
        }

        public static CopperbugData of(Entity entity) {
            CompoundTag nbtCompound = new CompoundTag();
            entity.save(nbtCompound);
            List<String> var10000 = IRRELEVANT_COPPERBUG_NBT_KEYS;
            Objects.requireNonNull(nbtCompound);
            var10000.forEach(arg_0 -> ((CompoundTag)nbtCompound).remove(arg_0));
            boolean bl = nbtCompound.getBoolean("HasNectar");
            return new CopperbugData(CustomData.of((CompoundTag)nbtCompound), 0, bl ? 2400 : 600);
        }

        public static CopperbugData create(int ticksInNest) {
            CompoundTag nbtCompound = new CompoundTag();
            nbtCompound.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(BGEntityTypes.COPPERBUG.get()).toString());
            return new CopperbugData(CustomData.of((CompoundTag)nbtCompound), ticksInNest, 600);
        }

        @Nullable
        public Entity loadEntity(Level world, BlockPos pos) {
            CompoundTag nbtCompound = this.entityData.copyTag();
            Objects.requireNonNull(nbtCompound);
            List<String> var10000 = IRRELEVANT_COPPERBUG_NBT_KEYS;
            Entity entity = EntityType.loadEntityRecursive((CompoundTag)nbtCompound, (Level)world, entityx -> entityx);
            var10000.forEach(arg_0 -> ((CompoundTag)nbtCompound).remove(arg_0));
            if (entity != null && entity.getType().is(JamiesModTag.COPPERBUGNEST_INHABITORS)) {
                entity.setNoGravity(true);
                if (entity instanceof CopperbugEntity) {
                    CopperbugEntity beeEntity = (CopperbugEntity)entity;
                    beeEntity.setNestPos(pos);
                    CopperbugData.tickEntity(this.ticksInNest, beeEntity);
                }
                return entity;
            }
            return null;
        }

        private static void tickEntity(int ticksInNest, CopperbugEntity beeEntity) {
            int i = beeEntity.getAge();
            if (i < 0) {
                beeEntity.setAge(Math.min(0, i + ticksInNest));
            } else if (i > 0) {
                beeEntity.setAge(Math.max(0, i - ticksInNest));
            }
            beeEntity.setInLoveTime(Math.max(0, beeEntity.getInLoveTime() - ticksInNest));
        }

        static {
            CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CustomData.CODEC.optionalFieldOf("entity_data", (Object)CustomData.EMPTY).forGetter(CopperbugData::entityData), (App)Codec.INT.fieldOf("ticks_in_Nest").forGetter(CopperbugData::ticksInNest), (App)Codec.INT.fieldOf("min_ticks_in_Nest").forGetter(CopperbugData::minTicksInNest)).apply((Applicative)instance, CopperbugData::new));
            LIST_CODEC = CODEC.listOf();
            PACKET_CODEC = StreamCodec.composite((StreamCodec)CustomData.STREAM_CODEC, CopperbugData::entityData, (StreamCodec)ByteBufCodecs.VAR_INT, CopperbugData::ticksInNest, (StreamCodec)ByteBufCodecs.VAR_INT, CopperbugData::minTicksInNest, CopperbugData::new);
        }
    }

    static class Copperbug {
        private final CopperbugData data;
        private int ticksInNest;

        Copperbug(CopperbugData data) {
            this.data = data;
            this.ticksInNest = data.ticksInNest();
        }

        public boolean canExitNest() {
            return this.ticksInNest++ > this.data.minTicksInNest;
        }

        public CopperbugData createData() {
            return new CopperbugData(this.data.entityData, this.ticksInNest, this.data.minTicksInNest);
        }

        public boolean hasNectar() {
            return this.data.entityData.getUnsafe().getBoolean("HasNectar");
        }
    }
}

