/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block.gourds;

import com.jamiedev.bygone.common.block.gourds.GourdVineBlock;
import com.jamiedev.bygone.core.registry.BGBlocks;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class GourdLanternBlock
extends GrowingPlantBodyBlock
implements BonemealableBlock {
    public static final MapCodec<GourdLanternBlock> CODEC = GourdLanternBlock.simpleCodec(GourdLanternBlock::new);
    public static final BooleanProperty HANGING;
    public static final BooleanProperty WATERLOGGED;
    protected static final VoxelShape STANDING_SHAPE;
    protected static final VoxelShape HANGING_SHAPE;
    protected static final VoxelShape[] STANDING_AGING_SHAPE;
    protected static final VoxelShape[] HANGING_AGING_SHAPE;
    public static final int MAX_AGE = 2;
    public static final IntegerProperty AGE;
    public static final BooleanProperty GROW_VINE;
    CocoaBlock ref1;

    public MapCodec<GourdLanternBlock> codec() {
        return CODEC;
    }

    public GourdLanternBlock(BlockBehaviour.Properties settings) {
        super(settings, Direction.DOWN, HANGING_SHAPE, false);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HANGING, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)GROW_VINE, (Comparable)Boolean.valueOf(true)));
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 2;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int i;
        if (level.random.nextInt(5) == 0 && (i = ((Integer)state.getValue((Property)AGE)).intValue()) < 2) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
        }
        if (level.random.nextInt(2) == 0 && (i = ((Integer)state.getValue((Property)AGE)).intValue()) < 2 && level.getBlockState(pos.below()).is(Blocks.AIR) && ((Boolean)state.getValue((Property)GROW_VINE)).booleanValue()) {
            Set<Block> gourds = Set.of(BGBlocks.GOURD_LANTERN_BEIGE.get(), BGBlocks.GOURD_LANTERN_MUAVE.get(), BGBlocks.GOURD_LANTERN_VERDANT.get());
            ArrayList<Block> gourdsList = new ArrayList<Block>(gourds);
            level.setBlock(pos, (BlockState)BGBlocks.GOURD_VINE.get().defaultBlockState().setValue((Property)GourdVineBlock.GOURD_TYPE, (Comparable)Integer.valueOf(gourdsList.indexOf((Object)this))), 2);
            level.setBlock(pos.below(), (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
        }
    }

    public boolean isFullyGrown(BlockState state) {
        int i = (Integer)state.getValue((Property)AGE);
        return i == 2 | i > 2;
    }

    public boolean getGrowVine(BlockState state) {
        return (Boolean)state.getValue((Property)GROW_VINE);
    }

    protected void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockpos;
        if (!level.isClientSide && projectile.mayInteract(level, blockpos = hit.getBlockPos()) && projectile.mayBreak(level) && projectile instanceof Projectile && projectile.getDeltaMovement().length() > 0.6) {
            GourdLanternBlock.spawnFallingGourd(state, (ServerLevel)level, blockpos);
        }
    }

    protected void tick(BlockState state, ServerLevel world, BlockPos pos, @NotNull RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            GourdLanternBlock.spawnFallingGourd(state, world, pos);
        }
    }

    private static void spawnFallingGourd(BlockState state, ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        BlockState blockstate = state;
        FallingBlockEntity fallingblockentity = FallingBlockEntity.fall((Level)level, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate);
        fallingblockentity.dropItem = false;
        blockpos$mutableblockpos.move(Direction.DOWN);
        blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.above()).isFaceSturdy((BlockGetter)level, pos.above(), Direction.DOWN) || level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP) && this.isFullyGrown(state);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int i = (Integer)state.getValue((Property)AGE);
        return (Boolean)state.getValue((Property)HANGING) != false ? HANGING_AGING_SHAPE[i] : STANDING_AGING_SHAPE[i];
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HANGING, WATERLOGGED, AGE, GROW_VINE});
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 2;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)AGE) + 1)), 2);
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @NotNull
    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.getBodyBlock());
    }

    protected GrowingPlantHeadBlock getHeadBlock() {
        return (GrowingPlantHeadBlock)BGBlocks.GOURD_VINE.get();
    }

    static {
        STANDING_AGING_SHAPE = new VoxelShape[]{Shapes.or((VoxelShape)Block.box((double)5.5, (double)4.0, (double)5.5, (double)9.5, (double)7.0, (double)9.5), (VoxelShape)Block.box((double)6.0, (double)7.0, (double)6.0, (double)9.0, (double)9.0, (double)9.0)), Shapes.or((VoxelShape)Block.box((double)4.5, (double)4.0, (double)4.5, (double)10.5, (double)7.0, (double)10.5), (VoxelShape)Block.box((double)6.0, (double)7.0, (double)6.0, (double)9.0, (double)9.0, (double)9.0)), Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), (VoxelShape)Block.box((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0))};
        HANGING_AGING_SHAPE = new VoxelShape[]{Shapes.or((VoxelShape)Block.box((double)5.5, (double)4.0, (double)5.5, (double)9.5, (double)7.0, (double)9.5), (VoxelShape)Block.box((double)6.0, (double)7.0, (double)6.0, (double)9.0, (double)9.0, (double)9.0)), Shapes.or((VoxelShape)Block.box((double)4.5, (double)4.0, (double)4.5, (double)10.5, (double)7.0, (double)10.5), (VoxelShape)Block.box((double)6.0, (double)7.0, (double)6.0, (double)9.0, (double)9.0, (double)9.0)), Shapes.or((VoxelShape)Block.box((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), (VoxelShape)Block.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0))};
        AGE = BlockStateProperties.AGE_2;
        GROW_VINE = BooleanProperty.create((String)"grow_vine");
        HANGING = BlockStateProperties.HANGING;
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
        STANDING_SHAPE = Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), (VoxelShape)Block.box((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0));
        HANGING_SHAPE = Shapes.or((VoxelShape)Block.box((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), (VoxelShape)Block.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0));
    }
}

