/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block.gourds;

import com.jamiedev.bygone.common.block.gourds.GourdLanternBlock;
import com.jamiedev.bygone.core.registry.BGBlocks;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.NetherVines;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GourdVineBlock
extends GrowingPlantHeadBlock {
    public static final MapCodec<GourdVineBlock> CODEC = GourdVineBlock.simpleCodec(GourdVineBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private final double growPerTickProbability;
    public static final IntegerProperty GOURD_TYPE = IntegerProperty.create((String)"gourd_type", (int)0, (int)2);

    public MapCodec<GourdVineBlock> codec() {
        return CODEC;
    }

    public GourdVineBlock(BlockBehaviour.Properties settings) {
        super(settings, Direction.DOWN, SHAPE, false, 0.1);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)GOURD_TYPE, (Comparable)Integer.valueOf(0)));
        this.growPerTickProbability = 0.1;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{GOURD_TYPE});
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource random) {
        return NetherVines.getBlocksToGrowWhenBonemealed((RandomSource)random);
    }

    protected Block getBodyBlock() {
        return BGBlocks.GOURD_VINE.get();
    }

    protected boolean canGrowInto(BlockState state) {
        return NetherVines.isValidGrowthState((BlockState)state);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos blockpos;
        if (random.nextDouble() < this.growPerTickProbability && random.nextInt(0, 6) == 1 && this.canGrowInto(level.getBlockState(blockpos = pos.relative(this.growthDirection)))) {
            Set<Block> gourds = Set.of(BGBlocks.GOURD_LANTERN_BEIGE.get(), BGBlocks.GOURD_LANTERN_MUAVE.get(), BGBlocks.GOURD_LANTERN_VERDANT.get());
            ArrayList<Block> gourdsList = new ArrayList<Block>(gourds);
            level.setBlockAndUpdate(blockpos, (BlockState)((Block)gourdsList.get((Integer)state.getValue((Property)GOURD_TYPE))).defaultBlockState().setValue((Property)GourdLanternBlock.GROW_VINE, (Comparable)Boolean.valueOf(false)));
        }
    }
}

