/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block.shelf;

import com.google.common.collect.ImmutableMap;
import com.jamiedev.bygone.common.block.shelf.ShelfFungiFanBlock;
import com.mojang.serialization.MapCodec;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelfFungiWallFanBlock2
extends ShelfFungiFanBlock {
    public static final MapCodec<ShelfFungiWallFanBlock2> CODEC = ShelfFungiWallFanBlock2.simpleCodec(ShelfFungiWallFanBlock2::new);
    public static final BooleanProperty UP = PipeBlock.UP;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final Map<Direction, BooleanProperty> FACING_PROPERTIES = (Map)PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().filter(entry -> entry.getKey() != Direction.DOWN).collect(Util.toMap());
    protected static final float field_31275 = 1.0f;
    private static final VoxelShape UP_SHAPE = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.box((double)0.0, (double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)16.0);
    private static final VoxelShape WEST_SHAPE = Block.box((double)5.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape SOUTH_SHAPE = Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)11.0);
    private static final VoxelShape NORTH_SHAPE = Block.box((double)0.0, (double)4.0, (double)5.0, (double)16.0, (double)12.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesByState;

    public MapCodec<ShelfFungiWallFanBlock2> codec() {
        return CODEC;
    }

    public ShelfFungiWallFanBlock2(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.shapesByState = ImmutableMap.copyOf(this.stateDefinition.getPossibleStates().stream().collect(Collectors.toMap(Function.identity(), ShelfFungiWallFanBlock2::getShapeForState)));
    }

    private static VoxelShape getShapeForState(BlockState state) {
        VoxelShape voxelShape = Shapes.empty();
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            voxelShape = UP_SHAPE;
        }
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)SOUTH_SHAPE);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)NORTH_SHAPE);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)WEST_SHAPE);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)EAST_SHAPE);
        }
        return voxelShape.isEmpty() ? Shapes.block() : voxelShape;
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.shapesByState.get(state);
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    protected boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return this.hasAdjacentBlocks(this.getPlacementShape(state, (BlockGetter)world, pos));
    }

    private boolean hasAdjacentBlocks(BlockState state) {
        return this.getAdjacentBlockCount(state) > 0;
    }

    private int getAdjacentBlockCount(BlockState state) {
        int i = 0;
        for (BooleanProperty booleanProperty : FACING_PROPERTIES.values()) {
            if (!((Boolean)state.getValue((Property)booleanProperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private boolean shouldHaveSide(BlockGetter world, BlockPos pos, Direction side) {
        if (side == Direction.DOWN) {
            return false;
        }
        BlockPos blockPos = pos.relative(side);
        if (ShelfFungiWallFanBlock2.shouldConnectTo(world, blockPos, side)) {
            return true;
        }
        if (side.getAxis() == Direction.Axis.Y) {
            return false;
        }
        BooleanProperty booleanProperty = FACING_PROPERTIES.get(side);
        BlockState blockState = world.getBlockState(pos.above());
        return blockState.is((Block)this) && (Boolean)blockState.getValue((Property)booleanProperty) != false;
    }

    public static boolean shouldConnectTo(BlockGetter world, BlockPos pos, Direction direction) {
        return MultifaceBlock.canAttachTo((BlockGetter)world, (Direction)direction, (BlockPos)pos, (BlockState)world.getBlockState(pos));
    }

    private BlockState getPlacementShape(BlockState state, BlockGetter world, BlockPos pos) {
        BlockPos blockPos = pos.above();
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            state = (BlockState)state.setValue((Property)UP, (Comparable)Boolean.valueOf(ShelfFungiWallFanBlock2.shouldConnectTo(world, blockPos, Direction.DOWN)));
        }
        BlockState blockState = null;
        Iterator var6 = Direction.Plane.HORIZONTAL.iterator();
        while (var6.hasNext()) {
            Direction direction = (Direction)var6.next();
            BooleanProperty booleanProperty = ShelfFungiWallFanBlock2.getFacingProperty(direction);
            if (!((Boolean)state.getValue((Property)booleanProperty)).booleanValue()) continue;
            boolean bl = this.shouldHaveSide(world, pos, direction);
            if (!bl) {
                if (blockState == null) {
                    blockState = world.getBlockState(blockPos);
                }
                bl = blockState.is((Block)this) && (Boolean)blockState.getValue((Property)booleanProperty) != false;
            }
            state = (BlockState)state.setValue((Property)booleanProperty, (Comparable)Boolean.valueOf(bl));
        }
        return state;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN) {
            return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
        }
        BlockState blockState = this.getPlacementShape(state, (BlockGetter)world, pos);
        return !this.hasAdjacentBlocks(blockState) ? Blocks.AIR.defaultBlockState() : blockState;
    }

    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, @NotNull RandomSource random) {
        if (world.getGameRules().getBoolean(GameRules.RULE_DO_VINES_SPREAD) && random.nextInt(4) == 0) {
            Direction direction = Direction.getRandom((RandomSource)random);
            BlockPos blockPos = pos.above();
            if (direction.getAxis().isHorizontal() && !((Boolean)state.getValue((Property)ShelfFungiWallFanBlock2.getFacingProperty(direction))).booleanValue()) {
                if (this.canGrowAt((BlockGetter)world, pos)) {
                    BlockPos blockPos2 = pos.relative(direction);
                    BlockState blockState = world.getBlockState(blockPos2);
                    if (blockState.isAir()) {
                        Direction direction2 = direction.getClockWise();
                        Direction direction3 = direction.getCounterClockWise();
                        boolean bl = (Boolean)state.getValue((Property)ShelfFungiWallFanBlock2.getFacingProperty(direction2));
                        boolean bl2 = (Boolean)state.getValue((Property)ShelfFungiWallFanBlock2.getFacingProperty(direction3));
                        BlockPos blockPos3 = blockPos2.relative(direction2);
                        BlockPos blockPos4 = blockPos2.relative(direction3);
                        if (bl && ShelfFungiWallFanBlock2.shouldConnectTo((BlockGetter)world, blockPos3, direction2)) {
                            world.setBlock(blockPos2, (BlockState)this.defaultBlockState().setValue((Property)ShelfFungiWallFanBlock2.getFacingProperty(direction2), (Comparable)Boolean.valueOf(true)), 2);
                        } else if (bl2 && ShelfFungiWallFanBlock2.shouldConnectTo((BlockGetter)world, blockPos4, direction3)) {
                            world.setBlock(blockPos2, (BlockState)this.defaultBlockState().setValue((Property)ShelfFungiWallFanBlock2.getFacingProperty(direction3), (Comparable)Boolean.valueOf(true)), 2);
                        } else {
                            Direction direction4 = direction.getOpposite();
                            if (bl && world.isEmptyBlock(blockPos3) && ShelfFungiWallFanBlock2.shouldConnectTo((BlockGetter)world, pos.relative(direction2), direction4)) {
                                world.setBlock(blockPos3, (BlockState)this.defaultBlockState().setValue((Property)ShelfFungiWallFanBlock2.getFacingProperty(direction4), (Comparable)Boolean.valueOf(true)), 2);
                            } else if (bl2 && world.isEmptyBlock(blockPos4) && ShelfFungiWallFanBlock2.shouldConnectTo((BlockGetter)world, pos.relative(direction3), direction4)) {
                                world.setBlock(blockPos4, (BlockState)this.defaultBlockState().setValue((Property)ShelfFungiWallFanBlock2.getFacingProperty(direction4), (Comparable)Boolean.valueOf(true)), 2);
                            } else if ((double)random.nextFloat() < 0.05 && ShelfFungiWallFanBlock2.shouldConnectTo((BlockGetter)world, blockPos2.above(), Direction.UP)) {
                                world.setBlock(blockPos2, (BlockState)this.defaultBlockState().setValue((Property)UP, (Comparable)Boolean.valueOf(true)), 2);
                            }
                        }
                    } else if (ShelfFungiWallFanBlock2.shouldConnectTo((BlockGetter)world, blockPos2, direction)) {
                        world.setBlock(pos, (BlockState)state.setValue((Property)ShelfFungiWallFanBlock2.getFacingProperty(direction), (Comparable)Boolean.valueOf(true)), 2);
                    }
                }
            } else {
                BlockState blockState4;
                BlockState blockState3;
                BlockPos blockPos2;
                BlockState blockState;
                if (direction == Direction.UP && pos.getY() < world.getMaxBuildHeight() - 1) {
                    if (this.shouldHaveSide((BlockGetter)world, pos, direction)) {
                        world.setBlock(pos, (BlockState)state.setValue((Property)UP, (Comparable)Boolean.valueOf(true)), 2);
                        return;
                    }
                    if (world.isEmptyBlock(blockPos)) {
                        if (!this.canGrowAt((BlockGetter)world, pos)) {
                            return;
                        }
                        BlockState blockState2 = state;
                        Iterator var17 = Direction.Plane.HORIZONTAL.iterator();
                        while (true) {
                            if (!var17.hasNext()) {
                                if (this.hasHorizontalSide(blockState2)) {
                                    world.setBlock(blockPos, blockState2, 2);
                                }
                                return;
                            }
                            Direction direction2 = (Direction)var17.next();
                            if (!random.nextBoolean() && ShelfFungiWallFanBlock2.shouldConnectTo((BlockGetter)world, blockPos.relative(direction2), direction2)) continue;
                            blockState2 = (BlockState)blockState2.setValue((Property)ShelfFungiWallFanBlock2.getFacingProperty(direction2), (Comparable)Boolean.valueOf(false));
                        }
                    }
                }
                if (pos.getY() > world.getMinBuildHeight() && ((blockState = world.getBlockState(blockPos2 = pos.below())).isAir() || blockState.is((Block)this)) && (blockState3 = blockState.isAir() ? this.defaultBlockState() : blockState) != (blockState4 = this.getGrownState(state, blockState3, random)) && this.hasHorizontalSide(blockState4)) {
                    world.setBlock(blockPos2, blockState4, 2);
                }
            }
        }
    }

    private BlockState getGrownState(BlockState above, BlockState state, @NotNull RandomSource random) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanProperty;
            if (!random.nextBoolean() || !((Boolean)above.getValue((Property)(booleanProperty = ShelfFungiWallFanBlock2.getFacingProperty(direction)))).booleanValue()) continue;
            state = (BlockState)state.setValue((Property)booleanProperty, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    private boolean hasHorizontalSide(BlockState state) {
        return (Boolean)state.getValue((Property)NORTH) != false || (Boolean)state.getValue((Property)EAST) != false || (Boolean)state.getValue((Property)SOUTH) != false || (Boolean)state.getValue((Property)WEST) != false;
    }

    private boolean canGrowAt(BlockGetter world, BlockPos pos) {
        Iterable iterable = BlockPos.betweenClosed((int)(pos.getX() - 4), (int)(pos.getY() - 1), (int)(pos.getZ() - 4), (int)(pos.getX() + 4), (int)(pos.getY() + 1), (int)(pos.getZ() + 4));
        int j = 5;
        for (BlockPos blockPos : iterable) {
            if (!world.getBlockState(blockPos).is((Block)this) || --j > 0) continue;
            return false;
        }
        return true;
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        BlockState blockState = context.getLevel().getBlockState(context.getClickedPos());
        if (blockState.is((Block)this)) {
            return this.getAdjacentBlockCount(blockState) < FACING_PROPERTIES.size();
        }
        return super.canBeReplaced(state, context);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState blockState = ctx.getLevel().getBlockState(ctx.getClickedPos());
        boolean bl = blockState.is((Block)this);
        BlockState blockState2 = bl ? blockState : this.defaultBlockState();
        for (Direction direction : ctx.getNearestLookingDirections()) {
            boolean bl2;
            if (direction == Direction.DOWN) continue;
            BooleanProperty booleanProperty = ShelfFungiWallFanBlock2.getFacingProperty(direction);
            boolean bl3 = bl2 = bl && (Boolean)blockState.getValue((Property)booleanProperty) != false;
            if (bl2 || !this.shouldHaveSide((BlockGetter)ctx.getLevel(), ctx.getClickedPos(), direction)) continue;
            return (BlockState)blockState2.setValue((Property)booleanProperty, (Comparable)Boolean.valueOf(true));
        }
        return bl ? blockState2 : null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, NORTH, EAST, SOUTH, WEST});
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)SOUTH)));
            }
        }
        return state;
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            }
        }
        return super.mirror(state, mirror);
    }

    public static BooleanProperty getFacingProperty(Direction direction) {
        return FACING_PROPERTIES.get(direction);
    }
}

