/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block.shelf;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ShelfMushroomBlock
extends Block {
    public int variation;
    BedBlock ref;
    public static final MapCodec<ShelfMushroomBlock> CODEC = ShelfMushroomBlock.simpleCodec(ShelfMushroomBlock::new);

    public ShelfMushroomBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<ShelfMushroomBlock> codec() {
        return CODEC;
    }

    public ShelfMushroomBlock(BlockBehaviour.Properties settings, int variation) {
        super(settings);
        this.variation = variation;
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (entity.isSuppressingBounce()) {
            super.fallOn(world, state, pos, entity, fallDistance);
        } else {
            entity.causeFallDamage(fallDistance, 0.0f, world.damageSources().fall());
        }
    }

    public void updateEntityAfterFallOn(BlockGetter world, Entity entity) {
        if (entity.isSuppressingBounce()) {
            super.updateEntityAfterFallOn(world, entity);
        } else {
            this.bounce(entity);
        }
    }

    private void bounceEntity(Entity entity) {
        Vec3 vec3d = entity.getDeltaMovement();
        if (vec3d.y < 0.0) {
            double d = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.setDeltaMovement(vec3d.x, -vec3d.y * (double)0.66f * d, vec3d.z);
        }
    }

    private void bounce(Entity entity) {
        double d;
        Vec3 vec3d;
        if (this.variation == 1) {
            vec3d = entity.getDeltaMovement();
            if (vec3d.y < 0.0) {
                d = entity instanceof LivingEntity ? 1.0 : 0.5;
                entity.setDeltaMovement(vec3d.x, -vec3d.y * d * 0.6, vec3d.z);
            }
        }
        if (this.variation == 2) {
            vec3d = entity.getDeltaMovement();
            if (vec3d.y < 0.0) {
                d = entity instanceof LivingEntity ? 1.0 : 0.1;
                entity.setDeltaMovement(vec3d.x, -vec3d.y * d * 1.5, vec3d.z);
            }
        } else {
            vec3d = entity.getDeltaMovement();
            if (vec3d.y < 0.0) {
                d = entity instanceof LivingEntity ? 1.0 : 0.8;
                entity.setDeltaMovement(vec3d.x, -vec3d.y * d, vec3d.z);
            }
        }
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        double d = Math.abs(entity.getDeltaMovement().y);
        if (d < 0.1 && !entity.isSteppingCarefully()) {
            double e = 0.4 + d * 0.2;
            entity.setDeltaMovement(entity.getDeltaMovement().multiply(e, 1.0, e));
        }
        super.stepOn(world, pos, state, entity);
    }
}

