/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity;

import com.jamiedev.bygone.common.entity.FungalParentEntity;
import com.jamiedev.bygone.core.registry.BGEntityTypes;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FungalChildEntity
extends FungalParentEntity {
    EnderMan ref;
    private static final EntityDataAccessor<Boolean> WARNING = SynchedEntityData.defineId(FungalChildEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final float field_30352 = 6.0f;
    private float lastWarningAnimationProgress;
    private float warningAnimationProgress;
    private int warningSoundCooldown;
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int angerTime;
    @Nullable
    private UUID angryAt;

    public FungalChildEntity(EntityType<? extends FungalChildEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)BGEntityTypes.FUNGAL_PARENT.get().create((Level)world);
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return false;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AttackGoal());
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 4.0, polarBear -> polarBear.isBaby() ? DamageTypeTags.PANIC_CAUSES : DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 63.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new FungalParentRevengeGoal());
        this.targetSelector.addGoal(2, (Goal)new ProtectBabiesGoal());
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((FungalChildEntity)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Fox.class, 10, true, true, null));
        this.targetSelector.addGoal(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier.Builder createFungieAttributes() {
        return FungalChildEntity.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 6.0);
    }

    public static boolean canSpawn(EntityType<FungalParentEntity> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, @NotNull RandomSource random) {
        Holder registryEntry = world.getBiome(pos);
        if (!registryEntry.is(BiomeTags.POLAR_BEARS_SPAWN_ON_ALTERNATE_BLOCKS)) {
            return FungalChildEntity.checkAnimalSpawnRules(type, (LevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random);
        }
        return FungalChildEntity.isBrightEnoughToSpawn((BlockAndTintGetter)world, (BlockPos)pos) && world.getBlockState(pos.below()).is(BlockTags.POLAR_BEARS_SPAWNABLE_ON_ALTERNATE);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.readPersistentAngerSaveData(this.level(), nbt);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        this.addPersistentAngerSaveData(nbt);
    }

    @Override
    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_TIME_RANGE.sample(this.random));
    }

    @Override
    public void setRemainingPersistentAngerTime(int angerTime) {
        this.angerTime = angerTime;
    }

    @Override
    public int getRemainingPersistentAngerTime() {
        return this.angerTime;
    }

    @Override
    public void setPersistentAngerTarget(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    @Override
    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.angryAt;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return this.isBaby() ? SoundEvents.POLAR_BEAR_AMBIENT_BABY : SoundEvents.POLAR_BEAR_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.POLAR_BEAR_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.POLAR_BEAR_DEATH;
    }

    @Override
    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.POLAR_BEAR_STEP, 0.15f, 1.0f);
    }

    @Override
    protected void playWarningSound() {
        if (this.warningSoundCooldown <= 0) {
            this.makeSound(SoundEvents.POLAR_BEAR_WARNING);
            this.warningSoundCooldown = 40;
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(WARNING, (Object)false);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.warningAnimationProgress != this.lastWarningAnimationProgress) {
                this.refreshDimensions();
            }
            this.lastWarningAnimationProgress = this.warningAnimationProgress;
            this.warningAnimationProgress = this.isWarning() ? Mth.clamp((float)(this.warningAnimationProgress + 1.0f), (float)0.0f, (float)6.0f) : Mth.clamp((float)(this.warningAnimationProgress - 1.0f), (float)0.0f, (float)6.0f);
        }
        if (this.warningSoundCooldown > 0) {
            --this.warningSoundCooldown;
        }
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    @Override
    public EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.warningAnimationProgress > 0.0f) {
            float f = this.warningAnimationProgress / 6.0f;
            float g = 1.0f + f;
            return super.getDefaultDimensions(pose).scale(1.0f, g);
        }
        return super.getDefaultDimensions(pose);
    }

    @Override
    public boolean isWarning() {
        return (Boolean)this.entityData.get(WARNING);
    }

    @Override
    public void setWarning(boolean warning) {
        this.entityData.set(WARNING, (Object)warning);
    }

    @Override
    public float getWarningAnimationProgress(float tickDelta) {
        return Mth.lerp((float)tickDelta, (float)this.lastWarningAnimationProgress, (float)this.warningAnimationProgress) / 6.0f;
    }

    @Override
    protected float getWaterSlowDown() {
        return 0.98f;
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        if (entityData == null) {
            entityData = new AgeableMob.AgeableMobGroupData(1.0f);
        }
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    private class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal() {
            super((PathfinderMob)FungalChildEntity.this, 1.25, true);
        }

        protected void checkAndPerformAttack(LivingEntity target) {
            if (this.canPerformAttack(target)) {
                this.resetAttackCooldown();
                this.mob.doHurtTarget((Entity)target);
                FungalChildEntity.this.setWarning(false);
            } else if (this.mob.distanceToSqr((Entity)target) < (double)((target.getBbWidth() + 3.0f) * (target.getBbWidth() + 3.0f))) {
                if (this.isTimeToAttack()) {
                    FungalChildEntity.this.setWarning(false);
                    this.resetAttackCooldown();
                }
                if (this.getTicksUntilNextAttack() <= 10) {
                    FungalChildEntity.this.setWarning(true);
                    FungalChildEntity.this.playWarningSound();
                }
            } else {
                this.resetAttackCooldown();
                FungalChildEntity.this.setWarning(false);
            }
        }

        public void stop() {
            FungalChildEntity.this.setWarning(false);
            super.stop();
        }
    }

    class FungalParentRevengeGoal
    extends HurtByTargetGoal {
        public FungalParentRevengeGoal() {
            super((PathfinderMob)FungalChildEntity.this, new Class[0]);
        }

        public void start() {
            super.start();
            if (FungalChildEntity.this.isBaby()) {
                this.alertOthers();
                this.stop();
            }
        }

        protected void alertOther(Mob mob, LivingEntity target) {
            if (mob instanceof FungalChildEntity && !mob.isBaby()) {
                super.alertOther(mob, target);
            }
        }
    }

    class ProtectBabiesGoal
    extends NearestAttackableTargetGoal<Player> {
        public ProtectBabiesGoal() {
            super((Mob)FungalChildEntity.this, Player.class, 20, true, true, null);
        }

        public boolean canUse() {
            if (FungalChildEntity.this.isBaby()) {
                return false;
            }
            if (super.canUse()) {
                List list = FungalChildEntity.this.level().getEntitiesOfClass(FungalChildEntity.class, FungalChildEntity.this.getBoundingBox().inflate(8.0, 4.0, 8.0));
                for (FungalChildEntity polarBearEntity : list) {
                    if (!polarBearEntity.isBaby()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double getFollowDistance() {
            return super.getFollowDistance() * 0.5;
        }
    }
}

