/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity;

import com.jamiedev.bygone.core.registry.BGEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class RisingBlockEntity
extends FallingBlockEntity {
    private Level world;

    public RisingBlockEntity(EntityType<? extends FallingBlockEntity> entityType, Level world) {
        super(entityType, world);
    }

    private RisingBlockEntity(Level world, double x, double y, double z, BlockState block) {
        this(BGEntityTypes.RISING_BLOCK.get(), world);
        ((FallingBlockEntityAccess)((Object)this)).setBlockState(block);
        this.blocksBuilding = true;
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.setStartPos(this.blockPosition());
    }

    public void move(MoverType movementType, Vec3 movement) {
        super.move(movementType, movementType == MoverType.SELF ? movement.scale(-1.0) : movement);
    }

    public void tick() {
        boolean collisionOverhead;
        super.tick();
        BlockPos blockPos = this.blockPosition();
        boolean bl = collisionOverhead = !this.world.getBlockState(blockPos.above()).getCollisionShape((BlockGetter)this.world, blockPos.above()).isEmpty();
        if (!this.world.isClientSide && this.world.isOutsideBuildHeight(blockPos.getY()) && this.world.isOutsideBuildHeight(blockPos.getY() - 10)) {
            this.discard();
            return;
        }
        if (!this.world.isClientSide && !this.isRemoved() && collisionOverhead) {
            boolean shouldPlace;
            BlockState state = this.getBlockState();
            Block block = state.getBlock();
            BlockState currState = this.world.getBlockState(blockPos);
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, 0.5, 0.7));
            boolean replaceable = currState.canBeReplaced((BlockPlaceContext)new DirectionalPlaceContext(this.world, blockPos, Direction.UP, ItemStack.EMPTY, Direction.DOWN));
            boolean bl2 = shouldPlace = state.canSurvive((LevelReader)this.world, blockPos) && !FallingBlock.isFree((BlockState)this.world.getBlockState(blockPos.above()));
            if (replaceable && shouldPlace) {
                if (this.world.setBlock(blockPos, state, 3)) {
                    ((ServerLevel)this.world).getChunkSource().chunkMap.broadcast((Entity)this, (Packet)new ClientboundBlockUpdatePacket(blockPos, this.world.getBlockState(blockPos)));
                    this.discard();
                } else if (this.dropItem && this.world.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
                    this.discard();
                    this.callOnBrokenAfterFall(block, blockPos);
                    this.spawnAtLocation((ItemLike)block);
                }
            } else {
                this.discard();
                if (this.dropItem && this.world.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
                    this.callOnBrokenAfterFall(block, blockPos);
                    this.spawnAtLocation((ItemLike)block);
                }
            }
        }
    }

    public static RisingBlockEntity fall(Level world, BlockPos pos, BlockState state) {
        RisingBlockEntity fallingBlockEntity = new RisingBlockEntity(world, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, state.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)) : state);
        fallingBlockEntity.time -= 1200;
        world.setBlock(pos, state.getFluidState().createLegacyBlock(), 3);
        world.addFreshEntity((Entity)fallingBlockEntity);
        return fallingBlockEntity;
    }

    public static interface FallingBlockEntityAccess {
        public void setBlockState(BlockState var1);
    }
}

