/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.jamiedev.bygone.common.entity.GlareEntity;
import com.jamiedev.bygone.common.entity.ai.GlareFloatTask;
import com.jamiedev.bygone.core.registry.BGEntityTypes;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StayCloseToTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class GlareBrain {
    public static final List<MemoryModuleType<?>> MEMORY_MODULES;
    public static final List<SensorType<? extends Sensor<? super GlareEntity>>> SENSORS;

    public static Brain<?> create(Dynamic<?> dynamic) {
        Brain.Provider profile = Brain.provider(MEMORY_MODULES, SENSORS);
        Brain brain = profile.makeBrain(dynamic);
        GlareBrain.addCoreActivities((Brain<GlareEntity>)brain);
        GlareBrain.addAvoidActivities((Brain<GlareEntity>)brain);
        GlareBrain.addIdleActivities((Brain<GlareEntity>)brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void addCoreActivities(Brain<GlareEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS)));
    }

    private static void addAvoidActivities(Brain<GlareEntity> brain) {
        brain.addActivityWithConditions(Activity.AVOID, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)1.25f, (int)16, (boolean)false))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.AVOID_TARGET, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static void addIdleActivities(Brain<GlareEntity> brain) {
        brain.addActivityWithConditions(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new FollowTemptation(glare -> Float.valueOf(1.25f))), (Object)Pair.of((Object)1, (Object)new AnimalMakeLove(BGEntityTypes.GLARE.get())), (Object)Pair.of((Object)2, (Object)BabyFollowAdult.create((UniformInt)UniformInt.of((int)5, (int)16), (float)1.25f)), (Object)Pair.of((Object)3, (Object)StayCloseToTarget.create(glare -> GlareBrain.getOwner((GlareEntity)((Object)glare)), glare -> true, (int)3, (int)8, (float)2.0f)), (Object)Pair.of((Object)4, (Object)SetEntityLookTargetSometimes.create((float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)5, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)((Object)new GlareFloatTask()), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.AVOID_TARGET, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static Optional<PositionTracker> getOwner(GlareEntity glare) {
        if (!glare.hasExactlyOnePlayerPassenger() || !glare.isInWaterRainOrBubble()) {
            return Optional.empty();
        }
        return Optional.of(new EntityTracker((Entity)glare.getTarget(), true));
    }

    public static void updateActivities(GlareEntity glare) {
        glare.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.AVOID, (Object)Activity.IDLE));
    }

    static {
        SENSORS = List.of(SensorType.NEAREST_ITEMS, SensorType.NEAREST_ADULT, SensorType.NEAREST_LIVING_ENTITIES, SensorType.NEAREST_PLAYERS);
        MEMORY_MODULES = List.of(MemoryModuleType.BREED_TARGET, MemoryModuleType.AVOID_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, MemoryModuleType.IS_TEMPTED, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.PATH, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, MemoryModuleType.IS_PANICKING, MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET, MemoryModuleType.ATE_RECENTLY);
    }
}

