/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.jamiedev.bygone.common.entity.SabeastEntity;
import com.jamiedev.bygone.common.entity.ai.behavior.SabeastSetWalkTargetFromAttackTargetIfTargetOutOfReach;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SabeastAI {
    public static Brain<?> makeBrain(SabeastEntity sabeast, Brain<SabeastEntity> brain) {
        SabeastAI.initCoreActivity(sabeast, brain);
        SabeastAI.initIdleActivity(brain);
        SabeastAI.initFightActivity(sabeast, brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initFightActivity(SabeastEntity sabeast, Brain<SabeastEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 0, ImmutableList.of(SabeastSetWalkTargetFromAttackTargetIfTargetOutOfReach.create(1.6f)), MemoryModuleType.ATTACK_TARGET);
    }

    private static void initCoreActivity(SabeastEntity sabeast, Brain<SabeastEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)StopBeingAngryIfTargetDead.create()));
    }

    private static void initIdleActivity(Brain<SabeastEntity> brain) {
        brain.addActivity(Activity.IDLE, 10, ImmutableList.of((Object)StartAttacking.create(sabeast -> sabeast.isAlive(), SabeastAI::findNearestValidAttackTarget), SabeastAI.createIdleMovementBehaviors()));
    }

    private static boolean canSetWalkTargetFromLookTarget(LivingEntity entity) {
        Level level = entity.level();
        Optional optional = entity.getBrain().getMemory(MemoryModuleType.LOOK_TARGET);
        if (optional.isPresent()) {
            BlockPos blockpos = ((PositionTracker)optional.get()).currentBlockPosition();
            return level.isWaterAt(blockpos) == entity.isInWaterOrBubble();
        }
        return false;
    }

    private static RunOne<SabeastEntity> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)0.6f), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void updateActivity(SabeastEntity sabeast) {
        Brain<SabeastEntity> brain = sabeast.getBrain();
        brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.IDLE));
        sabeast.setAggressive(brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
    }

    private static boolean isNearestValidAttackTarget(SabeastEntity sabeast, LivingEntity target) {
        return SabeastAI.findNearestValidAttackTarget(sabeast).filter(p_34887_ -> p_34887_ == target).isPresent();
    }

    private static float getSpeedModifierChasing(LivingEntity entity) {
        return entity.isInWaterOrBubble() ? 0.6f : 0.15f;
    }

    private static float getSpeedModifierFollowingAdult(LivingEntity entity) {
        return entity.isInWaterOrBubble() ? 0.6f : 0.15f;
    }

    private static float getSpeedModifier(LivingEntity entity) {
        return entity.isInWaterOrBubble() ? 0.5f : 0.15f;
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(SabeastEntity sabeast) {
        Optional optional = BehaviorUtils.getLivingEntityFromUUIDMemory((LivingEntity)sabeast, (MemoryModuleType)MemoryModuleType.ANGRY_AT);
        if (optional.isPresent() && Sensor.isEntityAttackableIgnoringLineOfSight((LivingEntity)sabeast, (LivingEntity)((LivingEntity)optional.get()))) {
            return optional;
        }
        Optional nearestValidMob = sabeast.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).flatMap(list -> list.findClosest(entity -> entity instanceof Player && Sensor.isEntityAttackableIgnoringLineOfSight((LivingEntity)sabeast, (LivingEntity)entity)));
        return nearestValidMob;
    }

    private static Optional<? extends LivingEntity> getTargetIfWithinRange(SabeastEntity sabeast, MemoryModuleType<? extends LivingEntity> memoryType) {
        return sabeast.getBrain().getMemory(memoryType).filter(p_35108_ -> p_35108_.closerThan((Entity)sabeast, 12.0));
    }

    public static Predicate<ItemStack> getTemptations() {
        return p_335657_ -> p_335657_.is(ItemTags.AXOLOTL_FOOD);
    }
}

