/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity.ai.behavior;

import com.jamiedev.bygone.common.entity.NectaurEntity;
import com.jamiedev.bygone.core.registry.BGMemoryModuleTypes;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class NectaurFollowLeader
extends Behavior<NectaurEntity> {
    public NectaurFollowLeader() {
        super(Map.of(BGMemoryModuleTypes.GROUP_LEADER, MemoryStatus.VALUE_PRESENT));
    }

    protected void tick(ServerLevel level, NectaurEntity entity, long gameTime) {
        UUID leaderId = (UUID)entity.getBrain().getMemory(BGMemoryModuleTypes.GROUP_LEADER).get();
        Entity leaderEntity = ((ServerLevel)entity.level()).getEntity(leaderId);
        if (leaderEntity instanceof NectaurEntity) {
            double distSq;
            NectaurEntity leader = (NectaurEntity)leaderEntity;
            if (!entity.getUUID().equals(leaderId) && (distSq = (double)entity.distanceTo((Entity)leader)) > 10.0) {
                entity.getNavigation().moveTo(leader.getX(), leader.getY(), leader.getZ(), 8, 1.25);
            }
        }
    }

    protected boolean canStillUse(ServerLevel level, NectaurEntity entity, long gameTime) {
        return entity.getBrain().hasMemoryValue(BGMemoryModuleTypes.GROUP_LEADER) && level.getEntity((UUID)entity.getBrain().getMemory(BGMemoryModuleTypes.GROUP_LEADER).get()) != null;
    }
}

