/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.item;

import com.jamiedev.bygone.core.registry.BGDataComponents;
import com.jamiedev.bygone.core.registry.BGSoundEvents;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class MaliciousWarHornItem
extends Item {
    private static final int MAX_VEXES = 5;
    private static final int RECHARGE_TIME_SECONDS = 100;
    private static final int VEX_LIFETIME_SECONDS = 40;
    private static final int DEATH_PENALTY_SECONDS = 20;
    private static final int USE_DURATION = 10;
    InstrumentItem ref;

    public MaliciousWarHornItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            WarHornData data = (WarHornData)itemStack.getOrDefault((DataComponentType)BGDataComponents.WAR_HORN_DATA.value(), (Object)WarHornData.EMPTY);
            if (data.cooldownSeconds() <= 0) {
                player.startUsingItem(hand);
                return InteractionResultHolder.consume((Object)itemStack);
            }
            player.displayClientMessage((Component)Component.translatable((String)"item.bygone.malicious_war_horn.cooldown", (Object[])new Object[]{data.cooldownSeconds()}).withStyle(ChatFormatting.RED), true);
            return InteractionResultHolder.fail((Object)itemStack);
        }
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity user) {
        if (!level.isClientSide && user instanceof Player) {
            Player player = (Player)user;
            level.playSound(null, player.getX(), player.getY(), player.getZ(), BGSoundEvents.WAR_HORN_USE.get(), SoundSource.RECORDS, 1.5f, 1.0f);
            level.gameEvent((Holder)GameEvent.INSTRUMENT_PLAY, player.position(), GameEvent.Context.of((Entity)player));
            this.spawnHornParticles(level, player);
            WarHornData data = this.releaseVexes(stack, level, player);
            stack.set((DataComponentType)BGDataComponents.WAR_HORN_DATA.value(), (Object)data);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.getCooldowns().addCooldown((Item)this, 20);
        }
        return stack;
    }

    private WarHornData releaseVexes(ItemStack stack, Level level, Player player) {
        if (!(level instanceof ServerLevel)) {
            return (WarHornData)stack.getOrDefault((DataComponentType)BGDataComponents.WAR_HORN_DATA.value(), (Object)WarHornData.EMPTY);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        HashSet<UUID> vexIds = new HashSet<UUID>();
        for (int i = 0; i < 5; ++i) {
            double angle = 1.2566370614359172 * (double)i;
            double x = player.getX() + Math.cos(angle) * 2.0;
            double z = player.getZ() + Math.sin(angle) * 2.0;
            double y = player.getY() + 1.0;
            Vex vex = (Vex)EntityType.VEX.create((Level)serverLevel);
            if (vex == null) continue;
            vex.moveTo(x, y, z, player.getYRot(), 0.0f);
            vex.setBoundOrigin(player.blockPosition());
            vex.setLimitedLife(800);
            vex.setPersistenceRequired();
            serverLevel.addFreshEntity((Entity)vex);
            vexIds.add(vex.getUUID());
        }
        return new WarHornData(new ArrayList<UUID>(vexIds), 100, 40);
    }

    private void spawnHornParticles(Level level, Player player) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 lookDirection = player.getLookAngle();
        double hornX = player.getX() + lookDirection.x * 0.5;
        double hornY = player.getY() + (double)player.getEyeHeight() - 0.2;
        double hornZ = player.getZ() + lookDirection.z * 0.5;
        for (int i = 0; i < 100; ++i) {
            double angle = Math.PI * 2 * level.random.nextDouble();
            double radius = level.random.nextDouble() * 3.0;
            double height = (level.random.nextDouble() - 0.5) * 2.0;
            double offsetX = Math.cos(angle) * radius * 0.3;
            double offsetY = height * 0.3;
            double offsetZ = Math.sin(angle) * radius * 0.3;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SOUL, hornX, hornY, hornZ, 1, offsetX, offsetY, offsetZ, 0.1);
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.isClientSide && entity instanceof Player && level.getGameTime() % 20L == 0L) {
            WarHornData data = (WarHornData)stack.getOrDefault((DataComponentType)BGDataComponents.WAR_HORN_DATA.value(), (Object)WarHornData.EMPTY);
            boolean needsUpdate = false;
            int newCooldown = Math.max(0, data.cooldownSeconds() - 1);
            int newVexTime = Math.max(0, data.vexTimeLeft() - 1);
            if (newCooldown != data.cooldownSeconds() || newVexTime != data.vexTimeLeft()) {
                needsUpdate = true;
            }
            List<UUID> activeVexes = data.activeVexes();
            if (newVexTime <= 0 && !activeVexes.isEmpty()) {
                for (UUID vexId : activeVexes) {
                    Entity vexEntity = ((ServerLevel)level).getEntity(vexId);
                    if (!(vexEntity instanceof Vex)) continue;
                    Vex vex = (Vex)vexEntity;
                    vex.discard();
                }
                activeVexes = new ArrayList<UUID>();
                newVexTime = 0;
                needsUpdate = true;
            }
            if (needsUpdate) {
                WarHornData newData = new WarHornData(activeVexes, newCooldown, newVexTime);
                stack.set((DataComponentType)BGDataComponents.WAR_HORN_DATA.value(), (Object)newData);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"item.bygone.malicious_war_horn.desc1").withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"item.bygone.malicious_war_horn.desc2").withStyle(ChatFormatting.GRAY));
        WarHornData data = (WarHornData)stack.getOrDefault((DataComponentType)BGDataComponents.WAR_HORN_DATA.value(), (Object)WarHornData.EMPTY);
        if (!data.activeVexes().isEmpty()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.bygone.malicious_war_horn.vexes_active", (Object[])new Object[]{data.activeVexes().size()}).withStyle(ChatFormatting.AQUA));
        }
        if (data.cooldownSeconds() > 0) {
            tooltipComponents.add((Component)Component.translatable((String)"item.bygone.malicious_war_horn.cooldown_remaining", (Object[])new Object[]{data.cooldownSeconds()}).withStyle(ChatFormatting.RED));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.bygone.malicious_war_horn.ready").withStyle(ChatFormatting.GREEN));
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 10;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.TOOT_HORN;
    }

    public boolean isFoil(ItemStack stack) {
        WarHornData data = (WarHornData)stack.getOrDefault((DataComponentType)BGDataComponents.WAR_HORN_DATA.value(), (Object)WarHornData.EMPTY);
        return !data.activeVexes().isEmpty();
    }

    public static void onVexDeath(Vex vex, ItemStack hornStack) {
        WarHornData data;
        if (hornStack.getItem() instanceof MaliciousWarHornItem && (data = (WarHornData)hornStack.getOrDefault((DataComponentType)BGDataComponents.WAR_HORN_DATA.value(), (Object)WarHornData.EMPTY)).activeVexes().contains(vex.getUUID())) {
            ArrayList<UUID> newVexes = new ArrayList<UUID>(data.activeVexes());
            newVexes.remove(vex.getUUID());
            WarHornData newData = new WarHornData(newVexes, data.cooldownSeconds() + 20, data.vexTimeLeft());
            hornStack.set((DataComponentType)BGDataComponents.WAR_HORN_DATA.value(), (Object)newData);
        }
    }

    public record WarHornData(List<UUID> activeVexes, int cooldownSeconds, int vexTimeLeft) {
        public static final WarHornData EMPTY = new WarHornData(new ArrayList<UUID>(), 0, 0);
    }
}

