/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.worldgen.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.jetbrains.annotations.Nullable;

public class PerlinDensityFunction
implements DensityFunction {
    public static final KeyDispatchDataCodec<PerlinDensityFunction> CODEC = KeyDispatchDataCodec.of((MapCodec)RecordCodecBuilder.mapCodec(p_208798_ -> p_208798_.group((App)NormalNoise.NoiseParameters.DIRECT_CODEC.fieldOf("noise").forGetter(func -> func.param), (App)Codec.DOUBLE.fieldOf("xz_scale").forGetter(func -> func.xz), (App)Codec.DOUBLE.fieldOf("y_scale").forGetter(func -> func.y), (App)Codec.LONG.fieldOf("seed").forGetter(func -> func.seed)).apply((Applicative)p_208798_, PerlinDensityFunction::new)));
    @Nullable
    public NormalNoise noise = null;
    private static final Map<Long, DensityFunction.Visitor> VISITORS = new HashMap<Long, DensityFunction.Visitor>();
    public NormalNoise.NoiseParameters param;
    public NormalNoise fake;
    long seed;
    double xz;
    double y;

    public PerlinDensityFunction(NormalNoise.NoiseParameters params, double xz, double y, long seed) {
        this.seed = seed;
        this.param = params;
        this.xz = xz;
        this.y = y;
        this.fake = NormalNoise.create((RandomSource)new XoroshiroRandomSource(seed), (int)params.firstOctave(), (double[])new double[]{params.amplitudes().getDouble(params.firstOctave())});
    }

    public double compute(DensityFunction.FunctionContext pos) {
        return 0.0;
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)this);
    }

    public double minValue() {
        return -this.maxValue();
    }

    public double maxValue() {
        if (this.noise != null) {
            return this.noise.maxValue();
        }
        return this.fake.maxValue();
    }

    public static PerlinNoiseVisitor createOrGetVisitor(long seed) {
        return (PerlinNoiseVisitor)VISITORS.computeIfAbsent(seed, l -> new PerlinNoiseVisitor(noise -> {
            if (noise.initialized()) {
                return noise;
            }
            return noise.initialize(offset -> new XoroshiroRandomSource(l + offset));
        }));
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC;
    }

    public PerlinDensityFunction initialize(Function<Long, XoroshiroRandomSource> rand) {
        this.noise = NormalNoise.create((RandomSource)((RandomSource)rand.apply(this.seed)), (int)this.param.firstOctave(), (double[])new double[]{this.param.amplitudes().getDouble(this.param.firstOctave())});
        return this;
    }

    public boolean initialized() {
        return this.noise != null;
    }

    public record PerlinNoiseVisitor(UnaryOperator<PerlinDensityFunction> operator) implements DensityFunction.Visitor
    {
        public DensityFunction apply(DensityFunction function) {
            if (function instanceof PerlinDensityFunction) {
                PerlinDensityFunction pnf = (PerlinDensityFunction)function;
                return (DensityFunction)this.operator.apply(pnf);
            }
            return function;
        }
    }
}

