/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.worldgen.feature;

import com.jamiedev.bygone.common.block.shelf.ShelfFungiWallFanBlock;
import com.jamiedev.bygone.core.init.JamiesModTag;
import com.mojang.serialization.Codec;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.CoralFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.jetbrains.annotations.NotNull;

public class ShelfFungiFeature
extends Feature<NoneFeatureConfiguration> {
    CoralFeature ref;

    public ShelfFungiFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel structureWorldAccess = context.level();
        BlockPos blockPos = context.origin();
        context.config();
        if (!structureWorldAccess.isEmptyBlock(blockPos)) {
            return false;
        }
        Direction[] var4 = Direction.values();
        int var5 = var4.length;
        for (Direction direction : var4) {
            Iterator var7;
            if (direction == Direction.DOWN || !ShelfFungiWallFanBlock.shouldConnectTo((BlockGetter)structureWorldAccess, blockPos.relative(direction), direction) || !(var7 = Direction.Plane.HORIZONTAL.iterator()).hasNext()) continue;
            Direction direction1 = (Direction)var7.next();
            return true;
        }
        return false;
    }

    protected boolean generateCoralPiece(LevelAccessor world, @NotNull RandomSource random, BlockPos pos, BlockState state) {
        BlockPos blockPos = pos.above();
        BlockState blockState = world.getBlockState(pos);
        if (blockState.is(BlockTags.MINEABLE_WITH_PICKAXE)) {
            world.setBlock(pos, state, 3);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockPos2;
                if (!(random.nextFloat() < 0.2f) || !world.getBlockState(blockPos2 = pos.relative(direction)).is(Blocks.AIR)) continue;
                BuiltInRegistries.BLOCK.getRandomElementOf(JamiesModTag.SHELF_FUNGI, random).map(Holder::value).ifPresent(block -> {
                    BlockState blockState1 = block.defaultBlockState();
                    if (blockState1.hasProperty((Property)ShelfFungiWallFanBlock.FACING)) {
                        blockState1 = (BlockState)blockState1.setValue((Property)ShelfFungiWallFanBlock.FACING, (Comparable)direction);
                    }
                    world.setBlock(blockPos2, blockState1, 2);
                });
            }
            return true;
        }
        return false;
    }
}

