/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.worldgen.structure;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.HugeFungusConfiguration;
import net.minecraft.world.level.levelgen.feature.WeepingVinesFeature;
import org.jetbrains.annotations.NotNull;

public class AncientFungusFeature
extends Feature<HugeFungusConfiguration> {
    private static final float field_31507 = 0.06f;

    public AncientFungusFeature(Codec<HugeFungusConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<HugeFungusConfiguration> context) {
        WorldGenLevel structureWorldAccess = context.level();
        BlockPos blockPos = context.origin();
        RandomSource random = context.random();
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        HugeFungusConfiguration hugeFungusFeatureConfig = (HugeFungusConfiguration)context.config();
        Block block = hugeFungusFeatureConfig.validBaseState.getBlock();
        BlockPos blockPos2 = null;
        BlockState blockState = structureWorldAccess.getBlockState(blockPos.above());
        if (blockState.is(block)) {
            blockPos2 = blockPos;
        }
        if (blockPos2 == null) {
            return false;
        }
        int i = Mth.nextInt((RandomSource)random, (int)4, (int)13);
        if (random.nextInt(12) == 0) {
            i *= 2;
        }
        if (!hugeFungusFeatureConfig.planted) {
            int j = chunkGenerator.getGenDepth();
            if (blockPos2.getY() + i + 1 >= j) {
                return false;
            }
        }
        boolean bl = !hugeFungusFeatureConfig.planted && random.nextFloat() < 0.06f;
        structureWorldAccess.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 4);
        this.generateStem(structureWorldAccess, random, hugeFungusFeatureConfig, blockPos2, i, bl);
        this.generateHat(structureWorldAccess, random, hugeFungusFeatureConfig, blockPos2, i, bl);
        return true;
    }

    private static boolean isReplaceable(WorldGenLevel world, BlockPos pos, HugeFungusConfiguration config, boolean checkConfig) {
        if (world.isStateAtPosition(pos, BlockBehaviour.BlockStateBase::canBeReplaced)) {
            return true;
        }
        return checkConfig && config.replaceableBlocks.test((Object)world, (Object)pos);
    }

    private void generateStem(WorldGenLevel world, @NotNull RandomSource random, HugeFungusConfiguration config, BlockPos pos, int stemHeight, boolean thickStem) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockState blockState = config.stemState;
        int i = thickStem ? 1 : 0;
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                boolean bl = thickStem && Mth.abs((int)j) == i && Mth.abs((int)k) == i;
                for (int l = 0; l < stemHeight; ++l) {
                    mutable.setWithOffset((Vec3i)pos, j, l, k);
                    if (!AncientFungusFeature.isReplaceable(world, (BlockPos)mutable, config, true)) continue;
                    if (config.planted) {
                        if (!world.getBlockState(mutable.above()).isAir()) {
                            world.destroyBlock((BlockPos)mutable, true);
                        }
                        world.setBlock((BlockPos)mutable, blockState, 3);
                        continue;
                    }
                    if (bl) {
                        if (!(random.nextFloat() < 0.1f)) continue;
                        this.setBlock((LevelWriter)world, (BlockPos)mutable, blockState);
                        continue;
                    }
                    this.setBlock((LevelWriter)world, (BlockPos)mutable, blockState);
                }
            }
        }
    }

    private void generateHat(WorldGenLevel world, @NotNull RandomSource random, HugeFungusConfiguration config, BlockPos pos, int hatHeight, boolean thickStem) {
        int j;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        boolean bl = config.hatState.is(Blocks.JUNGLE_LEAVES);
        int i = Math.min(random.nextInt(1 + hatHeight / 3) + 5, hatHeight);
        for (int k = j = hatHeight - i; k <= hatHeight; ++k) {
            int l;
            int n = l = k < hatHeight - random.nextInt(3) ? 2 : 1;
            if (i > 8 && k < j + 4) {
                l = 3;
            }
            if (thickStem) {
                ++l;
            }
            for (int m = -l; m <= l; ++m) {
                for (int n2 = -l; n2 <= l; ++n2) {
                    boolean bl2 = m == -l || m == l;
                    boolean bl3 = n2 == -l || n2 == l;
                    boolean bl4 = !bl2 && !bl3 && k != hatHeight;
                    boolean bl5 = bl2 && bl3;
                    boolean bl6 = k < j + 3;
                    mutable.setWithOffset((Vec3i)pos, m, k, n2);
                    if (!AncientFungusFeature.isReplaceable(world, (BlockPos)mutable, config, false)) continue;
                    if (config.planted && !world.getBlockState(mutable.above()).isAir()) {
                        world.destroyBlock((BlockPos)mutable, true);
                    }
                    if (bl6) {
                        if (bl4) continue;
                        this.placeWithOptionalVines((LevelAccessor)world, random, (BlockPos)mutable, config.hatState, bl);
                        continue;
                    }
                    if (bl4) {
                        this.placeHatBlock((LevelAccessor)world, random, config, mutable, 0.1f, 0.2f, bl ? 0.1f : 0.0f);
                        continue;
                    }
                    if (bl5) {
                        this.placeHatBlock((LevelAccessor)world, random, config, mutable, 0.01f, 0.7f, bl ? 0.083f : 0.0f);
                        continue;
                    }
                    this.placeHatBlock((LevelAccessor)world, random, config, mutable, 5.0E-4f, 0.98f, bl ? 0.07f : 0.0f);
                }
            }
        }
    }

    private void placeHatBlock(LevelAccessor world, @NotNull RandomSource random, HugeFungusConfiguration config, BlockPos.MutableBlockPos pos, float decorationChance, float generationChance, float vineChance) {
        if (random.nextFloat() < decorationChance) {
            this.setBlock((LevelWriter)world, (BlockPos)pos, config.decorState);
        } else if (random.nextFloat() < generationChance) {
            this.setBlock((LevelWriter)world, (BlockPos)pos, config.hatState);
            if (random.nextFloat() < vineChance) {
                AncientFungusFeature.generateVines((BlockPos)pos, world, random);
            }
        }
    }

    private void placeWithOptionalVines(LevelAccessor world, @NotNull RandomSource random, BlockPos pos, BlockState state, boolean vines) {
        if (world.getBlockState(pos.above()).is(state.getBlock())) {
            this.setBlock((LevelWriter)world, pos, state);
        } else if ((double)random.nextFloat() < 0.15) {
            this.setBlock((LevelWriter)world, pos, state);
            if (vines && random.nextInt(11) == 0) {
                AncientFungusFeature.generateVines(pos, world, random);
            }
        }
    }

    private static void generateVines(BlockPos pos, LevelAccessor world, @NotNull RandomSource random) {
        BlockPos.MutableBlockPos mutable = pos.mutable().move(Direction.UP);
        if (world.isEmptyBlock((BlockPos)mutable)) {
            int i = Mth.nextInt((RandomSource)random, (int)1, (int)5);
            if (random.nextInt(7) == 0) {
                i *= 2;
            }
            WeepingVinesFeature.placeWeepingVinesColumn((LevelAccessor)world, (RandomSource)random, (BlockPos.MutableBlockPos)mutable, (int)i, (int)23, (int)25);
        }
    }
}

