/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.worldgen.structure;

import com.google.common.collect.Lists;
import com.jamiedev.bygone.common.block.gourds.GourdDangoWallBlock;
import com.jamiedev.bygone.common.worldgen.structure.BygoneMineshaftStructure;
import com.jamiedev.bygone.core.init.JamiesModLootTables;
import com.jamiedev.bygone.core.registry.BGBlocks;
import com.jamiedev.bygone.core.registry.BGEntityTypes;
import com.jamiedev.bygone.core.registry.BGStructures;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BygoneMineshaftGenerator {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int field_31551 = 3;
    private static final int field_31552 = 3;
    private static final int field_31553 = 5;
    private static final int field_31554 = 20;
    private static final int field_31555 = 50;
    private static final int field_31556 = 8;
    public static final int field_34729 = 50;

    private static BygoneMineshaftPart pickPiece(StructurePieceAccessor holder, @NotNull RandomSource random, int x, int y, int z, @Nullable Direction orientation, int chainLength, BygoneMineshaftStructure.Type type) {
        int i = random.nextInt(100);
        if (i >= 80) {
            BoundingBox blockBox = BygoneMineshaftCrossing.getBoundingBox(holder, random, x, y, z, orientation);
            if (blockBox != null) {
                return new BygoneMineshaftCrossing(chainLength, blockBox, orientation, type);
            }
        } else if (i >= 70) {
            assert (orientation != null);
            BoundingBox blockBox = BygoneMineshaftStairs.getBoundingBox(holder, random, x, y, z, orientation);
            if (blockBox != null) {
                return new BygoneMineshaftStairs(chainLength, blockBox, orientation, type);
            }
        } else {
            BoundingBox blockBox = BygoneMineshaftCorridor.getBoundingBox(holder, random, x, y, z, orientation);
            if (blockBox != null) {
                return new BygoneMineshaftCorridor(chainLength, random, blockBox, orientation, type);
            }
        }
        return null;
    }

    static BygoneMineshaftPart pieceGenerator(StructurePiece start, StructurePieceAccessor holder, @NotNull RandomSource random, int x, int y, int z, Direction orientation, int chainLength) {
        if (chainLength > 8) {
            return null;
        }
        if (Math.abs(x - start.getBoundingBox().minX()) <= 80 && Math.abs(z - start.getBoundingBox().minZ()) <= 80) {
            BygoneMineshaftStructure.Type type = ((BygoneMineshaftPart)start).mineshaftType;
            BygoneMineshaftPart mineshaftPart = BygoneMineshaftGenerator.pickPiece(holder, random, x, y, z, orientation, chainLength + 1, type);
            if (mineshaftPart != null) {
                holder.addPiece((StructurePiece)mineshaftPart);
                mineshaftPart.addChildren(start, holder, random);
            }
            return mineshaftPart;
        }
        return null;
    }

    public static class BygoneMineshaftCrossing
    extends BygoneMineshaftPart {
        private final Direction direction;

        public BygoneMineshaftCrossing(StructurePieceSerializationContext context, CompoundTag nbt) {
            super(BGStructures.BYGONE_MINESHAFT_CROSSING, nbt);
            this.direction = Direction.from2DDataValue((int)nbt.getInt("D"));
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag nbt) {
            super.addAdditionalSaveData(context, nbt);
            nbt.putInt("D", this.direction.get2DDataValue());
        }

        public BygoneMineshaftCrossing(int chainLength, BoundingBox boundingBox, @Nullable Direction orientation, BygoneMineshaftStructure.Type type) {
            super(BGStructures.BYGONE_MINESHAFT_CROSSING, chainLength, type, boundingBox);
            this.direction = orientation;
        }

        @Nullable
        public static BoundingBox getBoundingBox(StructurePieceAccessor holder, @NotNull RandomSource random, int x, int y, int z, Direction orientation) {
            int i = random.nextInt(4) == 0 ? 6 : 2;
            BoundingBox blockBox = switch (orientation) {
                default -> new BoundingBox(-1, 0, -4, 3, i, 0);
                case Direction.SOUTH -> new BoundingBox(-1, 0, 0, 3, i, 4);
                case Direction.WEST -> new BoundingBox(-4, 0, -1, 0, i, 3);
                case Direction.EAST -> new BoundingBox(0, 0, -1, 4, i, 3);
            };
            blockBox.move(x, y, z);
            return holder.findCollisionPiece(blockBox) != null ? null : blockBox;
        }

        public void addChildren(StructurePiece start, StructurePieceAccessor holder, @NotNull RandomSource random) {
            int i = this.getGenDepth();
            switch (this.direction) {
                default: {
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() - 1, Direction.NORTH, i);
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX() - 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, Direction.WEST, i);
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.maxX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, Direction.EAST, i);
                    break;
                }
                case SOUTH: {
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.maxZ() + 1, Direction.SOUTH, i);
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX() - 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, Direction.WEST, i);
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.maxX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, Direction.EAST, i);
                    break;
                }
                case WEST: {
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() - 1, Direction.NORTH, i);
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.maxZ() + 1, Direction.SOUTH, i);
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX() - 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, Direction.WEST, i);
                    break;
                }
                case EAST: {
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() - 1, Direction.NORTH, i);
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.maxZ() + 1, Direction.SOUTH, i);
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.maxX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, Direction.EAST, i);
                }
            }
        }

        public void postProcess(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, @NotNull RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot) {
            if (!this.cannotGenerate((LevelAccessor)world, chunkBox)) {
                BlockState blockState = this.mineshaftType.getPlanks();
                this.generateBox(world, chunkBox, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ(), this.boundingBox.maxX() - 1, this.boundingBox.maxY(), this.boundingBox.maxZ(), CAVE_AIR, CAVE_AIR, false);
                this.generateBox(world, chunkBox, this.boundingBox.minX(), this.boundingBox.minY(), this.boundingBox.minZ() + 1, this.boundingBox.maxX(), this.boundingBox.maxY(), this.boundingBox.maxZ() - 1, CAVE_AIR, CAVE_AIR, false);
                this.generateCrossingPillar(world, chunkBox, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, this.boundingBox.maxY());
                this.generateCrossingPillar(world, chunkBox, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.maxZ() - 1, this.boundingBox.maxY());
                this.generateCrossingPillar(world, chunkBox, this.boundingBox.maxX() - 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, this.boundingBox.maxY());
                this.generateCrossingPillar(world, chunkBox, this.boundingBox.maxX() - 1, this.boundingBox.minY(), this.boundingBox.maxZ() - 1, this.boundingBox.maxY());
                int i = this.boundingBox.minY() - 1;
                for (int j = this.boundingBox.minX(); j <= this.boundingBox.maxX(); ++j) {
                    for (int k = this.boundingBox.minZ(); k <= this.boundingBox.maxZ(); ++k) {
                        this.tryPlaceFloor(world, chunkBox, blockState, j, i, k);
                    }
                }
            }
        }

        private void generateCrossingPillar(WorldGenLevel world, BoundingBox boundingBox, int x, int minY, int z, int maxY) {
            if (!this.getBlock((BlockGetter)world, x, maxY + 1, z, boundingBox).isAir()) {
                this.generateBox(world, boundingBox, x, minY, z, x, maxY, z, this.mineshaftType.getPlanks(), CAVE_AIR, false);
            }
        }
    }

    public static class BygoneMineshaftStairs
    extends BygoneMineshaftPart {
        public BygoneMineshaftStairs(int chainLength, BoundingBox boundingBox, Direction orientation, BygoneMineshaftStructure.Type type) {
            super(BGStructures.BYGONE_MINESHAFT_STAIRS, chainLength, type, boundingBox);
            this.setOrientation(orientation);
        }

        public BygoneMineshaftStairs(StructurePieceSerializationContext context, CompoundTag nbt) {
            super(BGStructures.BYGONE_MINESHAFT_STAIRS, nbt);
        }

        @Nullable
        public static BoundingBox getBoundingBox(StructurePieceAccessor holder, @NotNull RandomSource random, int x, int y, int z, Direction orientation) {
            BoundingBox blockBox = switch (orientation) {
                default -> new BoundingBox(0, -5, -8, 2, 2, 0);
                case Direction.SOUTH -> new BoundingBox(0, -5, 0, 2, 2, 8);
                case Direction.WEST -> new BoundingBox(-8, -5, 0, 0, 2, 2);
                case Direction.EAST -> new BoundingBox(0, -5, 0, 8, 2, 2);
            };
            blockBox.move(x, y, z);
            return holder.findCollisionPiece(blockBox) != null ? null : blockBox;
        }

        public void addChildren(StructurePiece start, StructurePieceAccessor holder, @NotNull RandomSource random) {
            int i = this.getGenDepth();
            Direction direction = this.getOrientation();
            if (direction != null) {
                switch (direction) {
                    default: {
                        BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX(), this.boundingBox.minY(), this.boundingBox.minZ() - 1, Direction.NORTH, i);
                        break;
                    }
                    case SOUTH: {
                        BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX(), this.boundingBox.minY(), this.boundingBox.maxZ() + 1, Direction.SOUTH, i);
                        break;
                    }
                    case WEST: {
                        BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX() - 1, this.boundingBox.minY(), this.boundingBox.minZ(), Direction.WEST, i);
                        break;
                    }
                    case EAST: {
                        BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.maxX() + 1, this.boundingBox.minY(), this.boundingBox.minZ(), Direction.EAST, i);
                    }
                }
            }
        }

        public void postProcess(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, @NotNull RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot) {
            if (!this.cannotGenerate((LevelAccessor)world, chunkBox)) {
                this.generateBox(world, chunkBox, 0, 5, 0, 2, 7, 1, CAVE_AIR, CAVE_AIR, false);
                this.generateBox(world, chunkBox, 0, 0, 7, 2, 2, 8, CAVE_AIR, CAVE_AIR, false);
                for (int i = 0; i < 5; ++i) {
                    this.generateBox(world, chunkBox, 0, 5 - i - (i < 4 ? 1 : 0), 2 + i, 2, 7 - i, 2 + i, CAVE_AIR, CAVE_AIR, false);
                }
            }
        }
    }

    public static class BygoneMineshaftCorridor
    extends BygoneMineshaftPart {
        private final boolean hasRails;
        private final boolean hasCobwebs;
        private boolean hasSpawner;
        private final int length;

        public BygoneMineshaftCorridor(CompoundTag nbt) {
            super(BGStructures.BYGONE_MINESHAFT_CORRIDOR, nbt);
            this.hasRails = nbt.getBoolean("hr");
            this.hasCobwebs = nbt.getBoolean("sc");
            this.hasSpawner = nbt.getBoolean("hps");
            this.length = nbt.getInt("Num");
        }

        public BygoneMineshaftCorridor(StructurePieceSerializationContext structureContext, CompoundTag nbt) {
            super(BGStructures.BYGONE_MINESHAFT_CORRIDOR, nbt);
            this.hasRails = nbt.getBoolean("hr");
            this.hasCobwebs = nbt.getBoolean("sc");
            this.hasSpawner = nbt.getBoolean("hps");
            this.length = nbt.getInt("Num");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag nbt) {
            super.addAdditionalSaveData(context, nbt);
            nbt.putBoolean("hr", this.hasRails);
            nbt.putBoolean("sc", this.hasCobwebs);
            nbt.putBoolean("hps", this.hasSpawner);
            nbt.putInt("Num", this.length);
        }

        public BygoneMineshaftCorridor(int chainLength, @NotNull RandomSource random, BoundingBox boundingBox, Direction orientation, BygoneMineshaftStructure.Type type) {
            super(BGStructures.BYGONE_MINESHAFT_CORRIDOR, chainLength, type, boundingBox);
            this.setOrientation(orientation);
            this.hasRails = random.nextInt(3) == 0;
            this.hasCobwebs = !this.hasRails && random.nextInt(23) == 0;
            this.length = Objects.requireNonNull(this.getOrientation()).getAxis() == Direction.Axis.Z ? boundingBox.getZSpan() / 5 : boundingBox.getXSpan() / 5;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        public static BoundingBox getBoundingBox(StructurePieceAccessor holder, @NotNull RandomSource random, int x, int y, int z, Direction orientation) {
            int i = random.nextInt(3) + 2;
            while (i > 0) {
                int j = i * 5;
                BoundingBox blockBox = switch (orientation) {
                    default -> new BoundingBox(0, 0, -(j - 1), 2, 2, 0);
                    case Direction.SOUTH -> new BoundingBox(0, 0, 0, 2, 2, j - 1);
                    case Direction.WEST -> new BoundingBox(-(j - 1), 0, 0, 0, 2, 2);
                    case Direction.EAST -> new BoundingBox(0, 0, 0, j - 1, 2, 2);
                };
                blockBox.move(x, y, z);
                if (holder.findCollisionPiece(blockBox) == null) {
                    return blockBox;
                }
                --i;
            }
            return null;
        }

        public void addChildren(StructurePiece start, StructurePieceAccessor holder, @NotNull RandomSource random) {
            block24: {
                int i = this.getGenDepth();
                int j = random.nextInt(4);
                Direction direction = this.getOrientation();
                if (direction != null) {
                    switch (direction) {
                        default: {
                            if (j <= 1) {
                                BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX(), this.boundingBox.minY() - 1 + random.nextInt(3), this.boundingBox.minZ() - 1, direction, i);
                                break;
                            }
                            if (j == 2) {
                                BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX() - 1, this.boundingBox.minY() - 1 + random.nextInt(3), this.boundingBox.minZ(), Direction.WEST, i);
                                break;
                            }
                            BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.maxX() + 1, this.boundingBox.minY() - 1 + random.nextInt(3), this.boundingBox.minZ(), Direction.EAST, i);
                            break;
                        }
                        case SOUTH: {
                            if (j <= 1) {
                                BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX(), this.boundingBox.minY() - 1 + random.nextInt(3), this.boundingBox.maxZ() + 1, direction, i);
                                break;
                            }
                            if (j == 2) {
                                BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX() - 1, this.boundingBox.minY() - 1 + random.nextInt(3), this.boundingBox.maxZ() - 3, Direction.WEST, i);
                                break;
                            }
                            BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.maxX() + 1, this.boundingBox.minY() - 1 + random.nextInt(3), this.boundingBox.maxZ() - 3, Direction.EAST, i);
                            break;
                        }
                        case WEST: {
                            if (j <= 1) {
                                BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX() - 1, this.boundingBox.minY() - 1 + random.nextInt(3), this.boundingBox.minZ(), direction, i);
                                break;
                            }
                            if (j == 2) {
                                BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX(), this.boundingBox.minY() - 1 + random.nextInt(3), this.boundingBox.minZ() - 1, Direction.NORTH, i);
                                break;
                            }
                            BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX(), this.boundingBox.minY() - 1 + random.nextInt(3), this.boundingBox.maxZ() + 1, Direction.SOUTH, i);
                            break;
                        }
                        case EAST: {
                            if (j <= 1) {
                                BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.maxX() + 1, this.boundingBox.minY() - 1 + random.nextInt(3), this.boundingBox.minZ(), direction, i);
                                break;
                            }
                            if (j == 2) {
                                BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.maxX() - 3, this.boundingBox.minY() - 1 + random.nextInt(3), this.boundingBox.minZ() - 1, Direction.NORTH, i);
                                break;
                            }
                            BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.maxX() - 3, this.boundingBox.minY() - 1 + random.nextInt(3), this.boundingBox.maxZ() + 1, Direction.SOUTH, i);
                        }
                    }
                }
                if (i >= 8) break block24;
                if (direction != Direction.NORTH && direction != Direction.SOUTH) {
                    int k = this.boundingBox.minX() + 3;
                    while (k + 3 <= this.boundingBox.maxX()) {
                        int l = random.nextInt(5);
                        if (l == 0) {
                            BygoneMineshaftGenerator.pieceGenerator(start, holder, random, k, this.boundingBox.minY(), this.boundingBox.minZ() - 1, Direction.NORTH, i + 1);
                        } else if (l == 1) {
                            BygoneMineshaftGenerator.pieceGenerator(start, holder, random, k, this.boundingBox.minY(), this.boundingBox.maxZ() + 1, Direction.SOUTH, i + 1);
                        }
                        k += 5;
                    }
                } else {
                    int k = this.boundingBox.minZ() + 3;
                    while (k + 3 <= this.boundingBox.maxZ()) {
                        int l = random.nextInt(5);
                        if (l == 0) {
                            BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX() - 1, this.boundingBox.minY(), k, Direction.WEST, i + 1);
                        } else if (l == 1) {
                            BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.maxX() + 1, this.boundingBox.minY(), k, Direction.EAST, i + 1);
                        }
                        k += 5;
                    }
                }
            }
        }

        protected boolean createChest(WorldGenLevel world, BoundingBox boundingBox, @NotNull RandomSource random, int x, int y, int z, ResourceKey<LootTable> lootTable) {
            BlockPos.MutableBlockPos blockPos = this.getWorldPos(x, y, z);
            if (boundingBox.isInside((Vec3i)blockPos) && world.getBlockState((BlockPos)blockPos).isAir() && !world.getBlockState(blockPos.below()).isAir()) {
                BlockState blockState = (BlockState)Blocks.RAIL.defaultBlockState().setValue((Property)RailBlock.SHAPE, (Comparable)(random.nextBoolean() ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST));
                this.placeBlock(world, blockState, x, y, z, boundingBox);
                MinecartChest chestMinecartEntity = new MinecartChest((Level)world.getLevel(), (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5);
                chestMinecartEntity.setLootTable(lootTable, random.nextLong());
                world.addFreshEntity((Entity)chestMinecartEntity);
                return true;
            }
            return false;
        }

        public void postProcess(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, @NotNull RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot) {
            if (!this.cannotGenerate((LevelAccessor)world, chunkBox)) {
                int o;
                int n;
                int m = this.length * 5 - 1;
                BlockState blockState = this.mineshaftType.getPlanks();
                this.generateBox(world, chunkBox, 0, 0, 0, 2, 1, m, CAVE_AIR, CAVE_AIR, false);
                this.generateMaybeBox(world, chunkBox, random, 0.8f, 0, 2, 0, 2, 2, m, CAVE_AIR, CAVE_AIR, false, false);
                if (this.hasCobwebs) {
                    this.generateMaybeBox(world, chunkBox, random, 0.6f, 0, 0, 0, 2, 1, m, Blocks.COBWEB.defaultBlockState(), CAVE_AIR, false, true);
                }
                for (n = 0; n < this.length; ++n) {
                    int q;
                    BlockPos.MutableBlockPos blockPos;
                    o = 2 + n * 5;
                    this.generateSupports(world, chunkBox, 0, 0, o, 2, 2, random);
                    this.addCobwebsUnderground(world, chunkBox, random, 0.1f, 0, 2, o - 1);
                    this.addCobwebsUnderground(world, chunkBox, random, 0.1f, 2, 2, o - 1);
                    this.addCobwebsUnderground(world, chunkBox, random, 0.1f, 0, 2, o + 1);
                    this.addCobwebsUnderground(world, chunkBox, random, 0.1f, 2, 2, o + 1);
                    this.addCobwebsUnderground(world, chunkBox, random, 0.05f, 0, 2, o - 2);
                    this.addCobwebsUnderground(world, chunkBox, random, 0.05f, 2, 2, o - 2);
                    this.addCobwebsUnderground(world, chunkBox, random, 0.05f, 0, 2, o + 2);
                    this.addCobwebsUnderground(world, chunkBox, random, 0.05f, 2, 2, o + 2);
                    if (random.nextInt(100) == 0) {
                        this.createChest(world, chunkBox, random, 2, 0, o - 1, JamiesModLootTables.ABANDONED_MINESHAFT_CHEST);
                    }
                    if (random.nextInt(100) == 0) {
                        this.createChest(world, chunkBox, random, 0, 0, o + 1, JamiesModLootTables.ABANDONED_MINESHAFT_CHEST);
                    }
                    if (!this.hasCobwebs || this.hasSpawner || !chunkBox.isInside((Vec3i)(blockPos = this.getWorldPos(1, 0, q = o - 1 + random.nextInt(3)))) || !this.isInterior((LevelReader)world, 1, 0, q, chunkBox)) continue;
                    this.hasSpawner = true;
                    world.setBlock((BlockPos)blockPos, Blocks.SPAWNER.defaultBlockState(), 2);
                    BlockEntity blockEntity = world.getBlockEntity((BlockPos)blockPos);
                    if (!(blockEntity instanceof SpawnerBlockEntity)) continue;
                    SpawnerBlockEntity mobSpawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
                    mobSpawnerBlockEntity.setEntityId(BGEntityTypes.PESKY.get(), random);
                }
                for (n = 0; n <= 2; ++n) {
                    for (o = 0; o <= m; ++o) {
                        this.tryPlaceFloor(world, chunkBox, blockState, n, -1, o);
                    }
                }
                this.fillSupportBeam(world, chunkBox, 0, -1, 2);
                if (this.length > 1) {
                    o = m - 2;
                    this.fillSupportBeam(world, chunkBox, 0, -1, o);
                }
                if (this.hasRails) {
                    BlockState blockState2 = (BlockState)Blocks.RAIL.defaultBlockState().setValue((Property)RailBlock.SHAPE, (Comparable)RailShape.NORTH_SOUTH);
                    for (int p = 0; p <= m; ++p) {
                        BlockState blockState3 = this.getBlock((BlockGetter)world, 1, -1, p, chunkBox);
                        if (blockState3.isAir() || !blockState3.isSolidRender((BlockGetter)world, (BlockPos)this.getWorldPos(1, -1, p))) continue;
                        float f = this.isInterior((LevelReader)world, 1, 0, p, chunkBox) ? 0.7f : 0.9f;
                        this.maybeGenerateBlock(world, chunkBox, random, f, 1, 0, p, blockState2);
                    }
                }
            }
        }

        private void fillSupportBeam(WorldGenLevel world, BoundingBox box, int x, int y, int z) {
            BlockState blockState = this.mineshaftType.getLog();
            BlockState blockState2 = this.mineshaftType.getPlanks();
            if (this.getBlock((BlockGetter)world, x, y, z, box).is(blockState2.getBlock())) {
                this.fillSupportBeam(world, blockState, x, y, z, box);
            }
            if (this.getBlock((BlockGetter)world, x + 2, y, z, box).is(blockState2.getBlock())) {
                this.fillSupportBeam(world, blockState, x + 2, y, z, box);
            }
        }

        protected void fillColumnDown(WorldGenLevel world, BlockState state, int x, int y, int z, BoundingBox box) {
            BlockPos.MutableBlockPos mutable = this.getWorldPos(x, y, z);
            if (box.isInside((Vec3i)mutable)) {
                int i = mutable.getY();
                while (this.isReplaceableByStructures(world.getBlockState((BlockPos)mutable)) && mutable.getY() > world.getMinBuildHeight() + 1) {
                    mutable.move(Direction.DOWN);
                }
                if (this.isUpsideSolidFullSquare((LevelReader)world, (BlockPos)mutable, world.getBlockState((BlockPos)mutable))) {
                    while (mutable.getY() < i) {
                        mutable.move(Direction.UP);
                        world.setBlock((BlockPos)mutable, state, 2);
                    }
                }
            }
        }

        protected void fillSupportBeam(WorldGenLevel world, BlockState state, int x, int y, int z, BoundingBox box) {
            BlockPos.MutableBlockPos mutable = this.getWorldPos(x, y, z);
            if (box.isInside((Vec3i)mutable)) {
                int i = mutable.getY();
                int j = 1;
                boolean bl = true;
                boolean bl2 = true;
                while (bl || bl2) {
                    boolean bl3;
                    BlockState blockState;
                    if (bl) {
                        mutable.setY(i - j);
                        blockState = world.getBlockState((BlockPos)mutable);
                        boolean bl4 = bl3 = this.isReplaceableByStructures(blockState) && !blockState.is(Blocks.LAVA);
                        if (!bl3 && this.isUpsideSolidFullSquare((LevelReader)world, (BlockPos)mutable, blockState)) {
                            BygoneMineshaftCorridor.fillColumn(world, state, mutable, i - j + 1, i);
                            return;
                        }
                        boolean bl5 = bl = j <= 20 && bl3 && mutable.getY() > world.getMinBuildHeight() + 1;
                    }
                    if (bl2) {
                        mutable.setY(i + j);
                        blockState = world.getBlockState((BlockPos)mutable);
                        bl3 = this.isReplaceableByStructures(blockState);
                        if (!bl3 && this.sideCoversSmallSquare((LevelReader)world, (BlockPos)mutable, blockState)) {
                            world.setBlock((BlockPos)mutable.setY(i + 1), this.mineshaftType.getFence(), 2);
                            BygoneMineshaftCorridor.fillColumn(world, Blocks.CHAIN.defaultBlockState(), mutable, i + 2, i + j);
                            return;
                        }
                        bl2 = j <= 50 && bl3 && mutable.getY() < world.getMaxBuildHeight() - 1;
                    }
                    ++j;
                }
            }
        }

        private static void fillColumn(WorldGenLevel world, BlockState state, BlockPos.MutableBlockPos pos, int startY, int endY) {
            for (int i = startY; i < endY; ++i) {
                world.setBlock((BlockPos)pos.setY(i), state, 2);
            }
        }

        private boolean isUpsideSolidFullSquare(LevelReader world, BlockPos pos, BlockState state) {
            return state.isFaceSturdy((BlockGetter)world, pos, Direction.UP);
        }

        private boolean sideCoversSmallSquare(LevelReader world, BlockPos pos, BlockState state) {
            return Block.canSupportCenter((LevelReader)world, (BlockPos)pos, (Direction)Direction.DOWN) && !(state.getBlock() instanceof FallingBlock);
        }

        private void generateSupports(WorldGenLevel world, BoundingBox boundingBox, int minX, int minY, int z, int maxY, int maxX, @NotNull RandomSource random) {
            if (this.isSolidCeiling((BlockGetter)world, boundingBox, minX, maxX, maxY, z)) {
                BlockState blockState = this.mineshaftType.getPlanks();
                BlockState blockState2 = this.mineshaftType.getFence();
                this.generateBox(world, boundingBox, minX, minY, z, minX, maxY - 1, z, (BlockState)blockState2.setValue((Property)FenceBlock.WEST, (Comparable)Boolean.valueOf(true)), CAVE_AIR, false);
                this.generateBox(world, boundingBox, maxX, minY, z, maxX, maxY - 1, z, (BlockState)blockState2.setValue((Property)FenceBlock.EAST, (Comparable)Boolean.valueOf(true)), CAVE_AIR, false);
                if (random.nextInt(4) == 0) {
                    this.generateBox(world, boundingBox, minX, maxY, z, minX, maxY, z, blockState, CAVE_AIR, false);
                    this.generateBox(world, boundingBox, maxX, maxY, z, maxX, maxY, z, blockState, CAVE_AIR, false);
                } else {
                    this.generateBox(world, boundingBox, minX, maxY, z, maxX, maxY, z, blockState, CAVE_AIR, false);
                    this.maybeGenerateBlock(world, boundingBox, random, 0.05f, minX + 1, maxY, z - 1, (BlockState)BGBlocks.GOURD_DANGO_WALL.get().defaultBlockState().setValue((Property)GourdDangoWallBlock.FACING, (Comparable)Direction.SOUTH));
                    this.maybeGenerateBlock(world, boundingBox, random, 0.05f, minX + 1, maxY, z + 1, (BlockState)BGBlocks.GOURD_DANGO_WALL.get().defaultBlockState().setValue((Property)GourdDangoWallBlock.FACING, (Comparable)Direction.NORTH));
                }
            }
        }

        private void addCobwebsUnderground(WorldGenLevel world, BoundingBox box, @NotNull RandomSource random, float threshold, int x, int y, int z) {
            if (this.isInterior((LevelReader)world, x, y, z, box) && random.nextFloat() < threshold && this.hasSolidNeighborBlocks(world, box, x, y, z, 2)) {
                this.placeBlock(world, Blocks.COBWEB.defaultBlockState(), x, y, z, box);
            }
        }

        private boolean hasSolidNeighborBlocks(WorldGenLevel world, BoundingBox box, int x, int y, int z, int count) {
            BlockPos.MutableBlockPos mutable = this.getWorldPos(x, y, z);
            int i = 0;
            for (Direction direction : Direction.values()) {
                mutable.move(direction);
                if (box.isInside((Vec3i)mutable) && world.getBlockState((BlockPos)mutable).isFaceSturdy((BlockGetter)world, (BlockPos)mutable, direction.getOpposite()) && ++i >= count) {
                    return true;
                }
                mutable.move(direction.getOpposite());
            }
            return false;
        }
    }

    private static abstract class BygoneMineshaftPart
    extends StructurePiece {
        protected BygoneMineshaftStructure.Type mineshaftType;

        public BygoneMineshaftPart(StructurePieceType structurePieceType, int chainLength, BygoneMineshaftStructure.Type type, BoundingBox box) {
            super(structurePieceType, chainLength, box);
            this.mineshaftType = type;
        }

        public BygoneMineshaftPart(StructurePieceType structurePieceType, CompoundTag nbtCompound) {
            super(structurePieceType, nbtCompound);
            this.mineshaftType = BygoneMineshaftStructure.Type.byId(nbtCompound.getInt("MST"));
        }

        protected boolean canBeReplaced(LevelReader world, int x, int y, int z, BoundingBox box) {
            BlockState blockState = this.getBlock((BlockGetter)world, x, y, z, box);
            return !blockState.is(this.mineshaftType.getPlanks().getBlock()) && !blockState.is(this.mineshaftType.getLog().getBlock()) && !blockState.is(this.mineshaftType.getFence().getBlock()) && !blockState.is(Blocks.CHAIN);
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag nbt) {
            nbt.putInt("MST", this.mineshaftType.ordinal());
        }

        protected boolean isSolidCeiling(BlockGetter world, BoundingBox boundingBox, int minX, int maxX, int y, int z) {
            for (int i = minX; i <= maxX; ++i) {
                if (!this.getBlock(world, i, y + 1, z, boundingBox).isAir()) continue;
                return false;
            }
            return true;
        }

        protected boolean cannotGenerate(LevelAccessor world, BoundingBox box) {
            int p;
            int o;
            int n;
            int m;
            int i = Math.max(this.boundingBox.minX() - 1, box.minX());
            int j = Math.max(this.boundingBox.minY() - 1, box.minY());
            int k = Math.max(this.boundingBox.minZ() - 1, box.minZ());
            int l = Math.min(this.boundingBox.maxX() + 1, box.maxX());
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos((i + l) / 2, (j + (m = Math.min(this.boundingBox.maxY() + 1, box.maxY()))) / 2, (k + (n = Math.min(this.boundingBox.maxZ() + 1, box.maxZ()))) / 2);
            if (world.getBiome((BlockPos)mutable).is(BiomeTags.MINESHAFT_BLOCKING)) {
                return true;
            }
            for (o = i; o <= l; ++o) {
                for (p = k; p <= n; ++p) {
                    if (world.getBlockState((BlockPos)mutable.set(o, j, p)).liquid()) {
                        return true;
                    }
                    if (!world.getBlockState((BlockPos)mutable.set(o, m, p)).liquid()) continue;
                    return true;
                }
            }
            for (o = i; o <= l; ++o) {
                for (p = j; p <= m; ++p) {
                    if (world.getBlockState((BlockPos)mutable.set(o, p, k)).liquid()) {
                        return true;
                    }
                    if (!world.getBlockState((BlockPos)mutable.set(o, p, n)).liquid()) continue;
                    return true;
                }
            }
            for (o = k; o <= n; ++o) {
                for (p = j; p <= m; ++p) {
                    if (world.getBlockState((BlockPos)mutable.set(i, p, o)).liquid()) {
                        return true;
                    }
                    if (!world.getBlockState((BlockPos)mutable.set(l, p, o)).liquid()) continue;
                    return true;
                }
            }
            return false;
        }

        protected void tryPlaceFloor(WorldGenLevel world, BoundingBox box, BlockState state, int x, int y, int z) {
            BlockPos.MutableBlockPos blockPos;
            BlockState blockState;
            if (this.isInterior((LevelReader)world, x, y, z, box) && !(blockState = world.getBlockState((BlockPos)(blockPos = this.getWorldPos(x, y, z)))).isFaceSturdy((BlockGetter)world, (BlockPos)blockPos, Direction.UP)) {
                world.setBlock((BlockPos)blockPos, state, 2);
            }
        }
    }

    public static class BygoneMineshaftRoom
    extends BygoneMineshaftPart {
        private final List<BoundingBox> entrances = Lists.newLinkedList();

        public BygoneMineshaftRoom(int chainLength, @NotNull RandomSource random, int x, int z, BygoneMineshaftStructure.Type type) {
            super(BGStructures.BYGONE_MINESHAFT_ROOM, chainLength, type, new BoundingBox(x, 100, z, x + 7 + random.nextInt(6), 200, z + 7 + random.nextInt(6)));
            this.mineshaftType = type;
        }

        public BygoneMineshaftRoom(StructurePieceSerializationContext context, CompoundTag nbt) {
            super(BGStructures.BYGONE_MINESHAFT_ROOM, nbt);
            DataResult var10000 = BoundingBox.CODEC.listOf().parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.getList("Entrances", 11));
            Logger var10001 = LOGGER;
            Objects.requireNonNull(var10001);
            Optional var2 = var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0));
            List<BoundingBox> var3 = this.entrances;
            Objects.requireNonNull(var3);
            var2.ifPresent(var3::addAll);
        }

        public void addChildren(StructurePiece start, StructurePieceAccessor holder, @NotNull RandomSource random) {
            BoundingBox blockBox;
            BygoneMineshaftPart structurePiece;
            int k;
            int i = this.getGenDepth();
            int j = this.boundingBox.getYSpan() - 3 - 1;
            if (j <= 0) {
                j = 1;
            }
            for (k = 0; k < this.boundingBox.getXSpan() && (k += random.nextInt(this.boundingBox.getXSpan())) + 3 <= this.boundingBox.getXSpan(); k += 4) {
                structurePiece = BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX() + k, this.boundingBox.minY() + random.nextInt(j) + 1, this.boundingBox.minZ() - 1, Direction.NORTH, i);
                if (structurePiece == null) continue;
                blockBox = structurePiece.getBoundingBox();
                this.entrances.add(new BoundingBox(blockBox.minX(), blockBox.minY(), this.boundingBox.minZ(), blockBox.maxX(), blockBox.maxY(), this.boundingBox.minZ() + 1));
            }
            for (k = 0; k < this.boundingBox.getXSpan() && (k += random.nextInt(this.boundingBox.getXSpan())) + 3 <= this.boundingBox.getXSpan(); k += 4) {
                structurePiece = BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX() + k, this.boundingBox.minY() + random.nextInt(j) + 1, this.boundingBox.maxZ() + 1, Direction.SOUTH, i);
                if (structurePiece == null) continue;
                blockBox = structurePiece.getBoundingBox();
                this.entrances.add(new BoundingBox(blockBox.minX(), blockBox.minY(), this.boundingBox.maxZ() - 1, blockBox.maxX(), blockBox.maxY(), this.boundingBox.maxZ()));
            }
            for (k = 0; k < this.boundingBox.getZSpan() && (k += random.nextInt(this.boundingBox.getZSpan())) + 3 <= this.boundingBox.getZSpan(); k += 4) {
                structurePiece = BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.minX() - 1, this.boundingBox.minY() + random.nextInt(j) + 1, this.boundingBox.minZ() + k, Direction.WEST, i);
                if (structurePiece == null) continue;
                blockBox = structurePiece.getBoundingBox();
                this.entrances.add(new BoundingBox(this.boundingBox.minX(), blockBox.minY(), blockBox.minZ(), this.boundingBox.minX() + 1, blockBox.maxY(), blockBox.maxZ()));
            }
            for (k = 0; k < this.boundingBox.getZSpan() && (k += random.nextInt(this.boundingBox.getZSpan())) + 3 <= this.boundingBox.getZSpan(); k += 4) {
                structurePiece = BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.boundingBox.maxX() + 1, this.boundingBox.minY() + random.nextInt(j) + 1, this.boundingBox.minZ() + k, Direction.EAST, i);
                if (structurePiece == null) continue;
                blockBox = structurePiece.getBoundingBox();
                this.entrances.add(new BoundingBox(this.boundingBox.maxX() - 1, blockBox.minY(), blockBox.minZ(), this.boundingBox.maxX(), blockBox.maxY(), blockBox.maxZ()));
            }
        }

        public void postProcess(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, @NotNull RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot) {
            if (!this.cannotGenerate((LevelAccessor)world, chunkBox)) {
                this.generateBox(world, chunkBox, this.boundingBox.minX(), this.boundingBox.minY() + 1, this.boundingBox.minZ(), this.boundingBox.maxX(), Math.min(this.boundingBox.minY() + 3, this.boundingBox.maxY()), this.boundingBox.maxZ(), CAVE_AIR, CAVE_AIR, false);
                for (BoundingBox blockBox : this.entrances) {
                    this.generateBox(world, chunkBox, blockBox.minX(), blockBox.maxY() - 2, blockBox.minZ(), blockBox.maxX(), blockBox.maxY(), blockBox.maxZ(), CAVE_AIR, CAVE_AIR, false);
                }
                this.generateUpperHalfSphere(world, chunkBox, this.boundingBox.minX(), this.boundingBox.minY() + 4, this.boundingBox.minZ(), this.boundingBox.maxX(), this.boundingBox.maxY(), this.boundingBox.maxZ(), CAVE_AIR, false);
            }
        }

        public void move(int x, int y, int z) {
            super.move(x, y, z);
            for (BoundingBox blockBox : this.entrances) {
                blockBox.move(x, y, z);
            }
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag nbt) {
            super.addAdditionalSaveData(context, nbt);
            DataResult var10000 = BoundingBox.CODEC.listOf().encodeStart((DynamicOps)NbtOps.INSTANCE, this.entrances);
            Logger var10001 = LOGGER;
            Objects.requireNonNull(var10001);
            var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).ifPresent(nbtElement -> nbt.put("Entrances", nbtElement));
        }
    }
}

