/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.worldgen.structure;

import com.jamiedev.bygone.common.worldgen.structure.BygoneMineshaftGenerator;
import com.jamiedev.bygone.core.registry.BGBlocks;
import com.jamiedev.bygone.core.registry.BGStructures;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class BygoneMineshaftStructure
extends Structure {
    public static final MapCodec<BygoneMineshaftStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BygoneMineshaftStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)Type.CODEC.fieldOf("mineshaft_type").forGetter(mineshaftStructure -> mineshaftStructure.type)).apply((Applicative)instance, BygoneMineshaftStructure::new));
    private final Type type;

    public BygoneMineshaftStructure(Structure.StructureSettings config, Type type) {
        super(config);
        this.type = type;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        context.random().nextDouble();
        ChunkPos chunkPos = context.chunkPos();
        BlockPos blockPos = new BlockPos(chunkPos.getMiddleBlockX(), 50, chunkPos.getMinBlockZ());
        StructurePiecesBuilder structurePiecesCollector = new StructurePiecesBuilder();
        int i = this.addPieces(structurePiecesCollector, context);
        return Optional.of(new Structure.GenerationStub(blockPos.offset(0, i, 0), Either.right((Object)structurePiecesCollector)));
    }

    private int addPieces(StructurePiecesBuilder collector, Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        WorldgenRandom chunkRandom = context.random();
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        BygoneMineshaftGenerator.BygoneMineshaftRoom mineshaftRoom = new BygoneMineshaftGenerator.BygoneMineshaftRoom(0, (RandomSource)chunkRandom, chunkPos.getBlockX(2), chunkPos.getBlockZ(2), this.type);
        collector.addPiece((StructurePiece)mineshaftRoom);
        mineshaftRoom.addChildren(mineshaftRoom, (StructurePieceAccessor)collector, (RandomSource)chunkRandom);
        int i = chunkGenerator.getSeaLevel();
        return collector.moveBelowSeaLevel(i, chunkGenerator.getMinY() + 150, (RandomSource)chunkRandom, 10);
    }

    public StructureType<?> type() {
        return BGStructures.BYGONE_MINESHAFT;
    }

    public static enum Type implements StringRepresentable
    {
        NORMAL("ancient", BGBlocks.ANCIENT_LOG.get(), BGBlocks.ANCIENT_PLANKS.get(), BGBlocks.ANCIENT_FENCE.get());

        public static final Codec<Type> CODEC;
        private static final IntFunction<Type> BY_ID;
        private final String name;
        private final BlockState log;
        private final BlockState planks;
        private final BlockState fence;

        private Type(String name, Block log, Block planks, Block fence) {
            this.name = name;
            this.log = log.defaultBlockState();
            this.planks = planks.defaultBlockState();
            this.fence = fence.defaultBlockState();
        }

        public String getName() {
            return this.name;
        }

        public static Type byId(int id) {
            return BY_ID.apply(id);
        }

        public BlockState getLog() {
            return this.log;
        }

        public BlockState getPlanks() {
            return BGBlocks.ANCIENT_PLANKS.get().defaultBlockState();
        }

        public BlockState getFence() {
            return this.fence;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

