/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.core.registry;

import com.jamiedev.bygone.common.block.entity.GumboPotBlockEntity;
import com.jamiedev.bygone.common.item.MaliciousWarHornItem;
import com.jamiedev.bygone.core.registry.BGDataComponentTypes;
import com.jamiedev.bygone.core.registry.BGDataComponents;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.registries.DeferredRegister;

public class BGDataComponentsNeoForge {
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENTS = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"bygone");
    private static final Supplier<DataComponentType<MaliciousWarHornItem.WarHornData>> WAR_HORN_DATA_SUPPLIER = DATA_COMPONENTS.register("war_horn_data", () -> {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.listOf().fieldOf("active_vexes").forGetter(MaliciousWarHornItem.WarHornData::activeVexes), (App)Codec.INT.fieldOf("cooldown_seconds").forGetter(MaliciousWarHornItem.WarHornData::cooldownSeconds), (App)Codec.INT.fieldOf("vex_time_left").forGetter(MaliciousWarHornItem.WarHornData::vexTimeLeft)).apply((Applicative)instance, MaliciousWarHornItem.WarHornData::new));
        StreamCodec streamCodec = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC.apply(ByteBufCodecs.list()), MaliciousWarHornItem.WarHornData::activeVexes, (StreamCodec)ByteBufCodecs.VAR_INT, MaliciousWarHornItem.WarHornData::cooldownSeconds, (StreamCodec)ByteBufCodecs.VAR_INT, MaliciousWarHornItem.WarHornData::vexTimeLeft, MaliciousWarHornItem.WarHornData::new);
        return DataComponentType.builder().persistent(codec).networkSynchronized(streamCodec).build();
    });
    private static final Supplier<DataComponentType<BGDataComponentTypes.EchoGongData>> ECHO_GONG_DATA_SUPPLIER = DATA_COMPONENTS.register("echo_gong_data", () -> {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("charge").forGetter(BGDataComponentTypes.EchoGongData::charge)).apply((Applicative)instance, BGDataComponentTypes.EchoGongData::new));
        StreamCodec streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, BGDataComponentTypes.EchoGongData::charge, BGDataComponentTypes.EchoGongData::new);
        return DataComponentType.builder().persistent(codec).networkSynchronized(streamCodec).build();
    });
    private static final Supplier<DataComponentType<GumboPotBlockEntity.GumboIngredientComponent>> GUMBO_INGREDIENT_DATA_SUPPLIER = DATA_COMPONENTS.register("gumbo_ingredient_data", () -> DataComponentType.builder().persistent(GumboPotBlockEntity.GumboIngredientComponent.CODEC).networkSynchronized(GumboPotBlockEntity.GumboIngredientComponent.STREAM_CODEC).build());

    public static void init() {
        DataComponentType<MaliciousWarHornItem.WarHornData> dataComponentType = WAR_HORN_DATA_SUPPLIER.get();
        BGDataComponents.WAR_HORN_DATA = BuiltInRegistries.DATA_COMPONENT_TYPE.wrapAsHolder(dataComponentType);
        DataComponentType<BGDataComponentTypes.EchoGongData> echoGongDataComponentType = ECHO_GONG_DATA_SUPPLIER.get();
        BGDataComponents.ECHO_GONG_DATA = BuiltInRegistries.DATA_COMPONENT_TYPE.wrapAsHolder(echoGongDataComponentType);
        DataComponentType<GumboPotBlockEntity.GumboIngredientComponent> gumboIngredientDataComponentType = GUMBO_INGREDIENT_DATA_SUPPLIER.get();
        BGDataComponents.GUMBO_INGREDIENT_DATA = BuiltInRegistries.DATA_COMPONENT_TYPE.wrapAsHolder(gumboIngredientDataComponentType);
    }
}

