/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block;

import com.google.common.base.Predicates;
import com.jamiedev.bygone.common.block.entity.CasterBlockEntity;
import com.jamiedev.bygone.core.init.JamiesModDamageTypes;
import com.jamiedev.bygone.core.registry.BGBlockEntities;
import com.jamiedev.bygone.core.registry.BGBlocks;
import com.jamiedev.bygone.core.registry.BGItems;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5575;
import org.jetbrains.annotations.Nullable;

public class CasterBlock
extends class_2237
implements class_5558<CasterBlockEntity> {
    public static final MapCodec<CasterBlock> CODEC = CasterBlock.method_54094(CasterBlock::new);
    public static final class_2753 FACING = class_2318.field_10927;
    public static final class_2746 TRIGGERED = class_2741.field_12484;
    public static final class_2754<CasterType> TYPE = class_2754.method_11850((String)"caster_type", CasterType.class);

    public CasterBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)TRIGGERED, (Comparable)Boolean.valueOf(false))).method_11657(TYPE, (Comparable)((Object)CasterType.NONE)));
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_7715().method_10153());
    }

    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_1264.method_54291((class_2680)state, (class_2680)newState, (class_1937)world, (class_2338)pos);
        super.method_9536(state, world, pos, newState, moved);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_1792 item = player.method_6047().method_7909();
        if (item == class_1802.field_8894) {
            world.method_8501(pos, (class_2680)state.method_11657(TYPE, (Comparable)((Object)CasterType.BLAZE)));
        } else if (item == class_1802.field_49821) {
            world.method_8501(pos, (class_2680)state.method_11657(TYPE, (Comparable)((Object)CasterType.BREEZE)));
        } else if (item == BGItems.SCUTTLE_SPIKE) {
            world.method_8501(pos, (class_2680)state.method_11657(TYPE, (Comparable)((Object)CasterType.GUARDIAN)));
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CasterBlockEntity(pos, state);
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, TRIGGERED, TYPE});
    }

    protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        boolean bl = world.method_49803(pos) || world.method_49803(pos.method_10084());
        boolean bl2 = (Boolean)state.method_11654((class_2769)TRIGGERED);
        if (bl && !bl2) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)TRIGGERED, (Comparable)Boolean.valueOf(true)));
        } else if (!bl && bl2) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)TRIGGERED, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected boolean method_9498(class_2680 state) {
        return true;
    }

    protected int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 entity = world.method_8321(pos);
        if (entity instanceof CasterBlockEntity) {
            CasterBlockEntity casterBlockEntity = (CasterBlockEntity)entity;
            if (casterBlockEntity.cooldownTicks > 0) {
                return (int)Math.max(Math.min(Math.round((double)casterBlockEntity.cooldownTicks / 6.0), 15L), 1L);
            }
        }
        return 0;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        return blockEntityType == BGBlockEntities.CASTER ? (var1, var2, var3, var4) -> this.tick(var1, var2, var3, (CasterBlockEntity)var4) : null;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, CasterBlockEntity blockEntity) {
        block20: {
            block19: {
                blockEntity.renderSpike = false;
                if (!((Boolean)state.method_11654((class_2769)TRIGGERED)).booleanValue()) break block19;
                if (!world.field_9236) {
                    if (blockEntity.cooldownTicks > 0) {
                        --blockEntity.cooldownTicks;
                        world.method_8455(pos, BGBlocks.CASTER.get());
                        return;
                    }
                    ++blockEntity.ticks;
                    if (blockEntity.ticks >= 100) {
                        blockEntity.ticks = 0;
                        blockEntity.cooldownTicks = 100;
                    }
                } else if (blockEntity.onCooldown) {
                    return;
                }
                class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
                class_238 box = new class_238(pos.method_10093(direction));
                switch (((CasterType)((Object)state.method_11654(TYPE))).ordinal()) {
                    case 1: {
                        int i;
                        int i1 = 2;
                        for (i = 1; i < 4; ++i) {
                            if (!world.method_8320(pos.method_10079(direction, i1)).method_26215()) continue;
                            ++i;
                        }
                        List entities = world.method_18023(class_5575.method_31795(class_1297.class), box.method_991(new class_238(pos.method_10079(direction, i))), (Predicate)Predicates.alwaysTrue());
                        for (class_1297 entity : entities) {
                            entity.method_5762((double)direction.method_10148() / 10.0, (double)direction.method_10164() / 10.0, (double)direction.method_10165() / 10.0);
                        }
                        if (blockEntity.ticks % 40 == 0) {
                            class_243 blockPos = pos.method_10093(direction).method_46558();
                            world.method_17452((class_2394)class_2398.field_11203, true, blockPos.field_1352, blockPos.field_1351, blockPos.field_1350, (double)direction.method_10148() / 0.5, (double)direction.method_10164() / 0.5, (double)direction.method_10165() / 0.5);
                            break;
                        }
                        break block20;
                    }
                    case 0: {
                        List entities = world.method_18023(class_5575.method_31795(class_1297.class), box, (Predicate)Predicates.alwaysTrue());
                        for (class_1297 entity : entities) {
                            entity.method_5639(15.0f);
                        }
                        class_243 blockPos = pos.method_10093(direction).method_46558();
                        for (int i = 0; i < 5; ++i) {
                            world.method_17452((class_2394)class_2398.field_11240, true, blockPos.field_1352 + (Math.random() - 0.5), blockPos.field_1351 + (Math.random() - 0.5), blockPos.field_1350 + (Math.random() - 0.5), 0.0, 0.0, 0.0);
                        }
                        break block20;
                    }
                    case 2: {
                        List entities = world.method_18023(class_5575.method_31795(class_1297.class), box, (Predicate)Predicates.alwaysTrue());
                        for (class_1297 entity : entities) {
                            entity.method_5643(world.method_48963().method_48795(JamiesModDamageTypes.SPIKE), 1.0f);
                        }
                        blockEntity.renderSpike = true;
                        class_243 blockPos = pos.method_10093(direction).method_46558();
                        for (int i = 0; i < 5; ++i) {
                            world.method_17452((class_2394)class_2398.field_22246, true, blockPos.field_1352 + (Math.random() - 0.5), blockPos.field_1351 + (Math.random() - 0.5), blockPos.field_1350 + (Math.random() - 0.5), 0.0, 0.0, 0.0);
                        }
                        break;
                    }
                }
                break block20;
            }
            if (blockEntity.cooldownTicks > 0 && !world.field_9236) {
                --blockEntity.cooldownTicks;
            }
        }
        world.method_8455(pos, BGBlocks.CASTER.get());
        if (!blockEntity.method_11015() && !world.field_9236 && (blockEntity.onCooldown && blockEntity.cooldownTicks <= 0 || !blockEntity.onCooldown && blockEntity.cooldownTicks > 0)) {
            blockEntity.onCooldown = blockEntity.cooldownTicks > 0;
        }
    }

    public static enum CasterType implements class_3542
    {
        BLAZE,
        BREEZE,
        GUARDIAN,
        NONE;


        public String method_15434() {
            switch (this.ordinal()) {
                case 0: {
                    return "blaze";
                }
                case 1: {
                    return "breeze";
                }
                case 2: {
                    return "guardian";
                }
            }
            return "none";
        }
    }
}

