/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jamiedev.bygone.common.block.BlemishVeinBlock;
import com.jamiedev.bygone.common.block.entity.BlemishSpreadable;
import com.jamiedev.bygone.core.init.JamiesModTag;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5778;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BlemishSpreadManager {
    public static final int field_37609 = 24;
    public static final int MAX_CHARGE = 1000;
    public static final float field_37611 = 0.5f;
    private static final int MAX_CURSORS = 32;
    public static final int field_37612 = 11;
    final boolean worldGen;
    private final class_6862<class_2248> replaceableTag;
    private final int extraBlockChance;
    private final int maxDistance;
    private final int spreadChance;
    private final int decayChance;
    private List<Cursor> cursors = new ArrayList<Cursor>();
    private static final Logger LOGGER = LogUtils.getLogger();

    public BlemishSpreadManager(boolean worldGen, class_6862<class_2248> replaceableTag, int extraBlockChance, int maxDistance, int spreadChance, int decayChance) {
        this.worldGen = worldGen;
        this.replaceableTag = replaceableTag;
        this.extraBlockChance = extraBlockChance;
        this.maxDistance = maxDistance;
        this.spreadChance = spreadChance;
        this.decayChance = decayChance;
    }

    public static BlemishSpreadManager create() {
        return new BlemishSpreadManager(false, JamiesModTag.BLEMISH_REPLACEABLE, 10, 4, 10, 5);
    }

    public static BlemishSpreadManager createWorldGen() {
        return new BlemishSpreadManager(true, JamiesModTag.BLEMISH_REPLACEABLE_WORLD_GEN, 50, 1, 5, 10);
    }

    public class_6862<class_2248> getReplaceableTag() {
        return this.replaceableTag;
    }

    public int getExtraBlockChance() {
        return this.extraBlockChance;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    public int getSpreadChance() {
        return this.spreadChance;
    }

    public int getDecayChance() {
        return this.decayChance;
    }

    public boolean isWorldGen() {
        return this.worldGen;
    }

    @VisibleForTesting
    public List<Cursor> getCursors() {
        return this.cursors;
    }

    public void clearCursors() {
        this.cursors.clear();
    }

    public void readNbt(class_2487 nbt) {
        if (nbt.method_10573("cursors", 9)) {
            this.cursors.clear();
            DataResult var10000 = Cursor.CODEC.listOf().parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt.method_10554("cursors", 10)));
            Logger var10001 = LOGGER;
            Objects.requireNonNull(var10001);
            List list = var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).orElseGet(ArrayList::new);
            int i = Math.min(list.size(), 32);
            for (int j = 0; j < i; ++j) {
                this.addCursor((Cursor)list.get(j));
            }
        }
    }

    public void writeNbt(class_2487 nbt) {
        DataResult var10000 = Cursor.CODEC.listOf().encodeStart((DynamicOps)class_2509.field_11560, this.cursors);
        Logger var10001 = LOGGER;
        Objects.requireNonNull(var10001);
        var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).ifPresent(cursorsNbt -> nbt.method_10566("cursors", cursorsNbt));
    }

    public void spread(class_2338 pos, int charge) {
        while (charge > 0) {
            int i = Math.min(charge, 1000);
            this.addCursor(new Cursor(pos, i));
            charge -= i;
        }
    }

    private void addCursor(Cursor cursor) {
        if (this.cursors.size() < 32) {
            this.cursors.add(cursor);
        }
    }

    public void tick(class_1936 world, class_2338 pos, @NotNull class_5819 random, boolean shouldConvertToBlock) {
        if (!this.cursors.isEmpty()) {
            class_2338 blockPos;
            ArrayList<Cursor> list = new ArrayList<Cursor>();
            HashMap<class_2338, Cursor> map = new HashMap<class_2338, Cursor>();
            Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
            for (Cursor cursor : this.cursors) {
                cursor.spread(world, pos, random, this, shouldConvertToBlock);
                if (cursor.charge <= 0) {
                    world.method_20290(6006, cursor.getPos(), 0);
                    continue;
                }
                blockPos = cursor.getPos();
                object2IntMap.computeInt((Object)blockPos, (posx, charge) -> (charge == null ? 0 : charge) + cursor.charge);
                Cursor cursor2 = (Cursor)map.get(blockPos);
                if (cursor2 == null) {
                    map.put(blockPos, cursor);
                    list.add(cursor);
                    continue;
                }
                if (!this.isWorldGen() && cursor.charge + cursor2.charge <= 1000) {
                    cursor2.merge(cursor);
                    continue;
                }
                list.add(cursor);
                if (cursor.charge >= cursor2.charge) continue;
                map.put(blockPos, cursor);
            }
            for (Object2IntMap.Entry entry : object2IntMap.object2IntEntrySet()) {
                Set<class_2350> collection;
                blockPos = (class_2338)entry.getKey();
                int i = entry.getIntValue();
                Cursor cursor3 = (Cursor)map.get(blockPos);
                Set<class_2350> set = collection = cursor3 == null ? null : cursor3.getFaces();
                if (i <= 0 || collection == null) continue;
                int j = (int)(Math.log1p(i) / (double)2.3f) + 1;
                int k = (j << 6) + class_5778.method_41439(collection);
                world.method_20290(6006, blockPos, k);
            }
            this.cursors = list;
            return;
        }
    }

    public static class Cursor {
        private static final ObjectArrayList OFFSETS = (ObjectArrayList)class_156.method_654((Object)new ObjectArrayList(18), list -> {
            Stream<class_2338> var10000 = class_2338.method_20437((class_2338)new class_2338(-1, -1, -1), (class_2338)new class_2338(1, 1, 1)).filter(pos -> (pos.method_10263() == 0 || pos.method_10264() == 0 || pos.method_10260() == 0) && !pos.equals((Object)class_2338.field_10980)).map(class_2338::method_10062);
            Objects.requireNonNull(list);
            var10000.forEach(arg_0 -> ((ObjectArrayList)list).add(arg_0));
        });
        public static final int field_37622 = 1;
        private class_2338 pos;
        int charge;
        private int update;
        private int decay;
        @Nullable
        private Set<class_2350> faces;
        private static final Codec<Set<class_2350>> DIRECTION_SET_CODEC = class_2350.field_29502.listOf().xmap(directions -> Sets.newEnumSet((Iterable)directions, class_2350.class), Lists::newArrayList);
        public static final Codec<Cursor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("pos").forGetter(Cursor::getPos), (App)Codec.intRange((int)0, (int)1000).fieldOf("charge").orElse((Object)0).forGetter(Cursor::getCharge), (App)Codec.intRange((int)0, (int)1).fieldOf("decay_delay").orElse((Object)1).forGetter(Cursor::getDecay), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("update_delay").orElse((Object)0).forGetter(cursor -> cursor.update), (App)DIRECTION_SET_CODEC.lenientOptionalFieldOf("facings").forGetter(cursor -> Optional.ofNullable(cursor.getFaces()))).apply((Applicative)instance, Cursor::new));

        private Cursor(class_2338 pos, int charge, int decay, int update, Optional<Set<class_2350>> faces) {
            this.pos = pos;
            this.charge = charge;
            this.decay = decay;
            this.update = update;
            this.faces = faces.orElse(null);
        }

        public Cursor(class_2338 pos, int charge) {
            this(pos, charge, 1, 0, Optional.empty());
        }

        public class_2338 getPos() {
            return this.pos;
        }

        public int getCharge() {
            return this.charge;
        }

        public int getDecay() {
            return this.decay;
        }

        @Nullable
        public Set<class_2350> getFaces() {
            return this.faces;
        }

        private boolean canSpread(class_1936 world, class_2338 pos, boolean worldGen) {
            if (this.charge <= 0) {
                return false;
            }
            if (worldGen) {
                return true;
            }
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                return serverWorld.method_41411(pos);
            }
            return false;
        }

        public void spread(class_1936 world, class_2338 pos, @NotNull class_5819 random, BlemishSpreadManager spreadManager, boolean shouldConvertToBlock) {
            if (this.canSpread(world, pos, spreadManager.worldGen)) {
                if (this.update > 0) {
                    --this.update;
                } else {
                    class_2680 blockState = world.method_8320(this.pos);
                    BlemishSpreadable BlemishSpreadable2 = Cursor.getSpreadable(blockState);
                    if (shouldConvertToBlock && BlemishSpreadable2.spread(world, this.pos, blockState, this.faces, spreadManager.isWorldGen())) {
                        if (BlemishSpreadable2.shouldConvertToSpreadable()) {
                            blockState = world.method_8320(this.pos);
                            BlemishSpreadable2 = Cursor.getSpreadable(blockState);
                        }
                        world.method_8396(null, this.pos, class_3417.field_37357, class_3419.field_15245, 1.0f, 1.0f);
                    }
                    this.charge = BlemishSpreadable2.spread(this, world, pos, random, spreadManager, shouldConvertToBlock);
                    if (this.charge <= 0) {
                        BlemishSpreadable2.spreadAtSamePosition(world, blockState, this.pos, random);
                    } else {
                        class_2338 blockPos = Cursor.getSpreadPos(world, this.pos, random);
                        if (blockPos != null) {
                            BlemishSpreadable2.spreadAtSamePosition(world, blockState, this.pos, random);
                            this.pos = blockPos.method_10062();
                            if (spreadManager.isWorldGen() && !this.pos.method_19771(new class_2382(pos.method_10263(), this.pos.method_10264(), pos.method_10260()), 15.0)) {
                                this.charge = 0;
                                return;
                            }
                            blockState = world.method_8320(blockPos);
                        }
                        if (blockState.method_26204() instanceof BlemishSpreadable) {
                            this.faces = class_5778.method_41440((class_2680)blockState);
                        }
                        this.decay = BlemishSpreadable2.getDecay(this.decay);
                        this.update = BlemishSpreadable2.getUpdate();
                    }
                }
            }
        }

        void merge(Cursor cursor) {
            this.charge += cursor.charge;
            cursor.charge = 0;
            this.update = Math.min(this.update, cursor.update);
        }

        private static BlemishSpreadable getSpreadable(class_2680 state) {
            BlemishSpreadable BlemishSpreadable2;
            class_2248 var2 = state.method_26204();
            BlemishSpreadable var10000 = var2 instanceof BlemishSpreadable ? (BlemishSpreadable2 = (BlemishSpreadable)var2) : BlemishSpreadable.VEIN_ONLY_SPREADER;
            return var10000;
        }

        private static List<class_2382> shuffleOffsets(class_5819 random) {
            return class_156.method_43027((ObjectArrayList)OFFSETS, (class_5819)random);
        }

        @Nullable
        private static class_2338 getSpreadPos(class_1936 world, class_2338 pos, @NotNull class_5819 random) {
            class_2338.class_2339 mutable = pos.method_25503();
            class_2338.class_2339 mutable2 = pos.method_25503();
            for (class_2382 vec3i : Cursor.shuffleOffsets(random)) {
                mutable2.method_35831((class_2382)pos, vec3i);
                class_2680 blockState = world.method_8320((class_2338)mutable2);
                if (!(blockState.method_26204() instanceof BlemishSpreadable) || !Cursor.canSpread(world, pos, (class_2338)mutable2)) continue;
                mutable.method_10101((class_2382)mutable2);
                if (!BlemishVeinBlock.veinCoversBlemishReplaceable(world, blockState, (class_2338)mutable2)) continue;
                break;
            }
            return mutable.equals((Object)pos) ? null : mutable;
        }

        private static boolean canSpread(class_1936 world, class_2338 sourcePos, class_2338 targetPos) {
            if (sourcePos.method_19455((class_2382)targetPos) == 1) {
                return true;
            }
            class_2338 blockPos = targetPos.method_10059((class_2382)sourcePos);
            class_2350 direction = class_2350.method_10169((class_2350.class_2351)class_2350.class_2351.field_11048, (class_2350.class_2352)(blockPos.method_10263() < 0 ? class_2350.class_2352.field_11060 : class_2350.class_2352.field_11056));
            class_2350 direction2 = class_2350.method_10169((class_2350.class_2351)class_2350.class_2351.field_11052, (class_2350.class_2352)(blockPos.method_10264() < 0 ? class_2350.class_2352.field_11060 : class_2350.class_2352.field_11056));
            class_2350 direction3 = class_2350.method_10169((class_2350.class_2351)class_2350.class_2351.field_11051, (class_2350.class_2352)(blockPos.method_10260() < 0 ? class_2350.class_2352.field_11060 : class_2350.class_2352.field_11056));
            if (blockPos.method_10263() == 0) {
                return Cursor.canSpread(world, sourcePos, direction2) || Cursor.canSpread(world, sourcePos, direction3);
            }
            if (blockPos.method_10264() == 0) {
                return Cursor.canSpread(world, sourcePos, direction) || Cursor.canSpread(world, sourcePos, direction3);
            }
            return Cursor.canSpread(world, sourcePos, direction) || Cursor.canSpread(world, sourcePos, direction2);
        }

        private static boolean canSpread(class_1936 world, class_2338 pos, class_2350 direction) {
            class_2338 blockPos = pos.method_10093(direction);
            return !world.method_8320(blockPos).method_26206((class_1922)world, blockPos, direction.method_10153());
        }
    }
}

