/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block.entity;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.jamiedev.bygone.common.block.GumboPotBlock;
import com.jamiedev.bygone.core.init.JamiesModTag;
import com.jamiedev.bygone.core.registry.BGBlockEntities;
import com.jamiedev.bygone.core.registry.BGDataComponents;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1291;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4174;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9298;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GumboPotBlockEntity
extends class_2586 {
    public static final int BASE_SERVINGS_PER_INGREDIENT = 12;
    public static final Codec<Pair<Integer, class_4174>> INGREDIENT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("servings").forGetter(Pair::getFirst), (App)class_4174.field_49992.fieldOf("properties").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::new));
    public static final Codec<List<Pair<Integer, class_4174>>> CONTENTS_CODEC = INGREDIENT_CODEC.listOf();
    public static final String NBT_KEY_CONTENTS = "contents";
    protected final List<Pair<Integer, class_4174>> potContents = new ArrayList<Pair<Integer, class_4174>>();

    public GumboPotBlockEntity(class_2338 pos, class_2680 blockState) {
        super(BGBlockEntities.GUMBO_POT.get(), pos, blockState);
    }

    public ImmutableList<Pair<Integer, class_4174>> ingredientsView() {
        return ImmutableList.copyOf(this.potContents);
    }

    public void addIngredient(class_4174 ingredient) {
        this.potContents.add((Pair<Integer, class_4174>)Pair.of((Object)12, (Object)ingredient));
    }

    public boolean canAddIngredient(class_1799 ingredient) {
        class_2680 state = this.method_11010();
        if (GumboPotBlock.canFitAdditionalIngredients(state) && !ingredient.method_31573(JamiesModTag.CANNOT_ADD_TO_GUMBO)) {
            class_4174 foodProperties = (class_4174)ingredient.method_57824(class_9334.field_50075);
            if (foodProperties != null) {
                return true;
            }
            GumboIngredientComponent gumboIngredientComponent = (GumboIngredientComponent)ingredient.method_57824((class_9331)BGDataComponents.GUMBO_INGREDIENT_DATA.comp_349());
            return gumboIngredientComponent != null;
        }
        return false;
    }

    public void addIngredient(class_1799 ingredient) {
        class_2680 state = this.method_11010();
        if (GumboPotBlock.canFitAdditionalIngredients(state) && !ingredient.method_31573(JamiesModTag.CANNOT_ADD_TO_GUMBO)) {
            GumboIngredientComponent gumboIngredientComponent;
            class_9298 suspiciousStewEffects = (class_9298)ingredient.method_57824(class_9334.field_49652);
            class_4174 foodProperties = (class_4174)ingredient.method_57824(class_9334.field_50075);
            if (foodProperties == null && (gumboIngredientComponent = (GumboIngredientComponent)ingredient.method_57824((class_9331)BGDataComponents.GUMBO_INGREDIENT_DATA.comp_349())) != null) {
                foodProperties = gumboIngredientComponent.properties;
            }
            if (foodProperties != null) {
                this.addIngredient(this.removeNegativeEffectsIf(this.spliceStewEffects(foodProperties, suspiciousStewEffects), ingredient.method_31573(JamiesModTag.GUMBO_MAKES_SAFE) || this.method_11010().method_28500(GumboPotBlock.HEATED).orElse(false) != false));
            }
        }
    }

    public boolean canScoopBowl(@Nullable class_1799 bowl) {
        if (bowl == null) {
            return false;
        }
        class_2680 state = this.method_11010();
        if (GumboPotBlock.canScoopBowl(state)) {
            return GumboScooping.getFilled(bowl.method_7909()) != null;
        }
        return false;
    }

    @NotNull
    public class_1799 scoopBowl(@Nullable class_1799 bowl) {
        class_1792 filledItem;
        class_2680 state = this.method_11010();
        if (bowl != null && GumboPotBlock.canScoopBowl(state) && (filledItem = GumboScooping.getFilled(bowl.method_7909())) != null) {
            class_1799 filledStack = new class_1799((class_1935)filledItem);
            filledStack.method_57379(class_9334.field_50075, (Object)this.extractFood(Optional.ofNullable(GumboScooping.getEmptied(filledItem)).map(class_1799::new)));
            return filledStack;
        }
        return class_1799.field_8037;
    }

    private class_4174 extractFood(Optional<class_1799> convertsTo) {
        boolean thisIsTheLastOfIt = this.method_11010().method_28500((class_2769)GumboPotBlock.LEVEL).orElse(0) <= 1;
        ArrayList<Pair> resultingContents = new ArrayList<Pair>();
        ArrayList<class_4174> toCombine = new ArrayList<class_4174>();
        for (Pair<Integer, class_4174> pair : this.potContents) {
            class_4174 currentIngredient = (class_4174)pair.getSecond();
            int count = (Integer)pair.getFirst();
            if (count > 1 && !thisIsTheLastOfIt) {
                resultingContents.add(Pair.of((Object)(count - 1), (Object)currentIngredient));
            }
            toCombine.add(currentIngredient);
        }
        this.potContents.clear();
        this.potContents.addAll(resultingContents);
        return this.combineFoods(toCombine, convertsTo);
    }

    private class_4174 combineFoods(List<class_4174> toCombine, Optional<class_1799> convertsTo) {
        int count = toCombine.size();
        float scaleFactor = 1.0f / (float)count;
        int totalNutrition = 0;
        float totalSaturation = 0.0f;
        boolean canAlwaysEat = false;
        float eatSeconds = 0.0f;
        ArrayList effects = new ArrayList();
        for (class_4174 properties : toCombine) {
            totalNutrition += properties.comp_2491();
            totalSaturation += properties.comp_2492();
            eatSeconds += properties.comp_2494();
            canAlwaysEat |= properties.comp_2493();
            effects.addAll(properties.comp_2495());
        }
        totalNutrition = class_3532.method_15386((float)(scaleFactor * (float)totalNutrition)) + 1;
        totalSaturation = (float)class_3532.method_15386((float)(scaleFactor * totalSaturation)) + 0.05f;
        if ((eatSeconds = (float)class_3532.method_15386((float)(scaleFactor * eatSeconds))) == 0.0f) {
            eatSeconds += 0.05f;
        }
        effects.replaceAll(possibleEffect -> new class_4174.class_9423(possibleEffect.comp_2496(), scaleFactor * possibleEffect.comp_2497()));
        return new class_4174(totalNutrition, totalSaturation, canAlwaysEat, eatSeconds, convertsTo, effects);
    }

    protected class_4174 removeNegativeEffectsIf(class_4174 properties, boolean removeIfTrue) {
        return removeIfTrue ? this.removeNegativeEffects(properties) : properties;
    }

    protected class_4174 removeNegativeEffects(class_4174 properties) {
        return new class_4174(properties.comp_2491(), properties.comp_2492(), properties.comp_2493(), properties.comp_2494(), properties.comp_2794(), properties.comp_2495().stream().filter(possibleEffect -> ((class_1291)possibleEffect.comp_2496().method_5579().comp_349()).method_5573()).toList());
    }

    protected class_4174 spliceStewEffects(class_4174 properties, @Nullable class_9298 effects) {
        return effects == null ? properties : new class_4174(properties.comp_2491(), properties.comp_2492(), properties.comp_2493(), properties.comp_2494(), properties.comp_2794(), Streams.concat((Stream[])new Stream[]{properties.comp_2495().stream(), effects.comp_2416().stream().map(entry -> new class_4174.class_9423(entry.method_53247(), 1.0f))}).toList());
    }

    protected void method_11014(@NotNull class_2487 nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.potContents.clear();
        class_2520 contents = nbt.method_10580(NBT_KEY_CONTENTS);
        this.potContents.addAll((Collection)((Pair)CONTENTS_CODEC.decode((DynamicOps)class_2509.field_11560, (Object)contents).getOrThrow()).getFirst());
    }

    protected void method_11007(@NotNull class_2487 nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        DataResult contentsResult = CONTENTS_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.potContents);
        contentsResult.ifError(tagError -> System.out.println("Warning! Gumbo pot block entity encountered an error while saving: " + tagError.message()));
        contentsResult.ifSuccess(contents -> nbt.method_10566(NBT_KEY_CONTENTS, contents));
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registryLookup) {
        class_2487 nbtCompound = super.method_16887(registryLookup);
        DataResult contentsResult = CONTENTS_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.potContents);
        contentsResult.ifError(tagError -> System.out.println("Warning! Gumbo pot block entity encountered an error while constructing an update tag: " + tagError.message()));
        contentsResult.ifSuccess(contents -> nbtCompound.method_10566(NBT_KEY_CONTENTS, contents));
        return nbtCompound;
    }

    public record GumboIngredientComponent(class_4174 properties) {
        public static final Codec<GumboIngredientComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4174.field_49992.fieldOf("food_properties").forGetter(GumboIngredientComponent::properties)).apply((Applicative)instance, GumboIngredientComponent::new));
        public static final class_9139<class_9129, GumboIngredientComponent> STREAM_CODEC = class_9139.method_56434((class_9139)class_4174.field_49993, GumboIngredientComponent::properties, GumboIngredientComponent::new);
    }

    public static class GumboScooping {
        protected static final BiMap<class_1792, class_1792> SCOOPING_MAP = HashBiMap.create();

        @Nullable
        public static class_1792 getFilled(class_1792 in) {
            return (class_1792)SCOOPING_MAP.get((Object)in);
        }

        @Nullable
        public static class_1792 getEmptied(class_1792 out) {
            return (class_1792)SCOOPING_MAP.inverse().get((Object)out);
        }

        @Nullable
        public static class_1792 setFilled(class_1792 in, class_1792 out) {
            return (class_1792)SCOOPING_MAP.put((Object)in, (Object)out);
        }
    }
}

