/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.item;

import com.jamiedev.bygone.core.registry.BGDataComponents;
import com.jamiedev.bygone.core.registry.BGSoundEvents;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1634;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7430;
import net.minecraft.class_9331;

public class MaliciousWarHornItem
extends class_1792 {
    private static final int MAX_VEXES = 5;
    private static final int RECHARGE_TIME_SECONDS = 100;
    private static final int VEX_LIFETIME_SECONDS = 40;
    private static final int DEATH_PENALTY_SECONDS = 20;
    private static final int USE_DURATION = 10;
    class_7430 ref;

    public MaliciousWarHornItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (!level.field_9236) {
            WarHornData data = (WarHornData)itemStack.method_57825((class_9331)BGDataComponents.WAR_HORN_DATA.comp_349(), (Object)WarHornData.EMPTY);
            if (data.cooldownSeconds() <= 0) {
                player.method_6019(hand);
                return class_1271.method_22428((Object)itemStack);
            }
            player.method_7353((class_2561)class_2561.method_43469((String)"item.bygone.malicious_war_horn.cooldown", (Object[])new Object[]{data.cooldownSeconds()}).method_27692(class_124.field_1061), true);
            return class_1271.method_22431((Object)itemStack);
        }
        return class_1271.method_22428((Object)itemStack);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 level, class_1309 user) {
        if (!level.field_9236 && user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), BGSoundEvents.WAR_HORN_USE.get(), class_3419.field_15247, 1.5f, 1.0f);
            level.method_32888((class_6880)class_5712.field_39415, player.method_19538(), class_5712.class_7397.method_43285((class_1297)player));
            this.spawnHornParticles(level, player);
            WarHornData data = this.releaseVexes(stack, level, player);
            stack.method_57379((class_9331)BGDataComponents.WAR_HORN_DATA.comp_349(), (Object)data);
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
            player.method_7357().method_7906((class_1792)this, 20);
        }
        return stack;
    }

    private WarHornData releaseVexes(class_1799 stack, class_1937 level, class_1657 player) {
        if (!(level instanceof class_3218)) {
            return (WarHornData)stack.method_57825((class_9331)BGDataComponents.WAR_HORN_DATA.comp_349(), (Object)WarHornData.EMPTY);
        }
        class_3218 serverLevel = (class_3218)level;
        HashSet<UUID> vexIds = new HashSet<UUID>();
        for (int i = 0; i < 5; ++i) {
            double angle = 1.2566370614359172 * (double)i;
            double x = player.method_23317() + Math.cos(angle) * 2.0;
            double z = player.method_23321() + Math.sin(angle) * 2.0;
            double y = player.method_23318() + 1.0;
            class_1634 vex = (class_1634)class_1299.field_6059.method_5883((class_1937)serverLevel);
            if (vex == null) continue;
            vex.method_5808(x, y, z, player.method_36454(), 0.0f);
            vex.method_7188(player.method_24515());
            vex.method_7181(800);
            vex.method_5971();
            serverLevel.method_8649((class_1297)vex);
            vexIds.add(vex.method_5667());
        }
        return new WarHornData(new ArrayList<UUID>(vexIds), 100, 40);
    }

    private void spawnHornParticles(class_1937 level, class_1657 player) {
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        class_243 lookDirection = player.method_5720();
        double hornX = player.method_23317() + lookDirection.field_1352 * 0.5;
        double hornY = player.method_23318() + (double)player.method_5751() - 0.2;
        double hornZ = player.method_23321() + lookDirection.field_1350 * 0.5;
        for (int i = 0; i < 100; ++i) {
            double angle = Math.PI * 2 * level.field_9229.method_43058();
            double radius = level.field_9229.method_43058() * 3.0;
            double height = (level.field_9229.method_43058() - 0.5) * 2.0;
            double offsetX = Math.cos(angle) * radius * 0.3;
            double offsetY = height * 0.3;
            double offsetZ = Math.sin(angle) * radius * 0.3;
            serverLevel.method_14199((class_2394)class_2398.field_23114, hornX, hornY, hornZ, 1, offsetX, offsetY, offsetZ, 0.1);
        }
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
        if (!level.field_9236 && entity instanceof class_1657 && level.method_8510() % 20L == 0L) {
            WarHornData data = (WarHornData)stack.method_57825((class_9331)BGDataComponents.WAR_HORN_DATA.comp_349(), (Object)WarHornData.EMPTY);
            boolean needsUpdate = false;
            int newCooldown = Math.max(0, data.cooldownSeconds() - 1);
            int newVexTime = Math.max(0, data.vexTimeLeft() - 1);
            if (newCooldown != data.cooldownSeconds() || newVexTime != data.vexTimeLeft()) {
                needsUpdate = true;
            }
            List<UUID> activeVexes = data.activeVexes();
            if (newVexTime <= 0 && !activeVexes.isEmpty()) {
                for (UUID vexId : activeVexes) {
                    class_1297 vexEntity = ((class_3218)level).method_14190(vexId);
                    if (!(vexEntity instanceof class_1634)) continue;
                    class_1634 vex = (class_1634)vexEntity;
                    vex.method_31472();
                }
                activeVexes = new ArrayList<UUID>();
                newVexTime = 0;
                needsUpdate = true;
            }
            if (needsUpdate) {
                WarHornData newData = new WarHornData(activeVexes, newCooldown, newVexTime);
                stack.method_57379((class_9331)BGDataComponents.WAR_HORN_DATA.comp_349(), (Object)newData);
            }
        }
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.bygone.malicious_war_horn.desc1").method_27692(class_124.field_1080));
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.bygone.malicious_war_horn.desc2").method_27692(class_124.field_1080));
        WarHornData data = (WarHornData)stack.method_57825((class_9331)BGDataComponents.WAR_HORN_DATA.comp_349(), (Object)WarHornData.EMPTY);
        if (!data.activeVexes().isEmpty()) {
            tooltipComponents.add((class_2561)class_2561.method_43469((String)"item.bygone.malicious_war_horn.vexes_active", (Object[])new Object[]{data.activeVexes().size()}).method_27692(class_124.field_1075));
        }
        if (data.cooldownSeconds() > 0) {
            tooltipComponents.add((class_2561)class_2561.method_43469((String)"item.bygone.malicious_war_horn.cooldown_remaining", (Object[])new Object[]{data.cooldownSeconds()}).method_27692(class_124.field_1061));
        } else {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.bygone.malicious_war_horn.ready").method_27692(class_124.field_1060));
        }
    }

    public int method_7881(class_1799 stack, class_1309 entity) {
        return 10;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_39058;
    }

    public boolean method_7886(class_1799 stack) {
        WarHornData data = (WarHornData)stack.method_57825((class_9331)BGDataComponents.WAR_HORN_DATA.comp_349(), (Object)WarHornData.EMPTY);
        return !data.activeVexes().isEmpty();
    }

    public static void onVexDeath(class_1634 vex, class_1799 hornStack) {
        WarHornData data;
        if (hornStack.method_7909() instanceof MaliciousWarHornItem && (data = (WarHornData)hornStack.method_57825((class_9331)BGDataComponents.WAR_HORN_DATA.comp_349(), (Object)WarHornData.EMPTY)).activeVexes().contains(vex.method_5667())) {
            ArrayList<UUID> newVexes = new ArrayList<UUID>(data.activeVexes());
            newVexes.remove(vex.method_5667());
            WarHornData newData = new WarHornData(newVexes, data.cooldownSeconds() + 20, data.vexTimeLeft());
            hornStack.method_57379((class_9331)BGDataComponents.WAR_HORN_DATA.comp_349(), (Object)newData);
        }
    }

    public record WarHornData(List<UUID> activeVexes, int cooldownSeconds, int vexTimeLeft) {
        public static final WarHornData EMPTY = new WarHornData(new ArrayList<UUID>(), 0, 0);
    }
}

