/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.worldgen.feature;

import com.jamiedev.bygone.common.worldgen.feature.config.MegalithConfig;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_4651;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class MegalithFeature
extends class_3031<MegalithConfig> {
    public MegalithFeature(Codec<MegalithConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<MegalithConfig> context) {
        class_5281 level = context.method_33652();
        class_5819 random = context.method_33654();
        MegalithConfig megalithConfig = (MegalithConfig)context.method_33656();
        class_2338 blockPos = context.method_33655();
        int lengthX = megalithConfig.sizeX().method_35008(random);
        int lengthY = megalithConfig.sizeY().method_35008(random);
        int lengthZ = megalithConfig.sizeZ().method_35008(random);
        int fallenBlockCount = megalithConfig.fallenBlockCount().method_35008(random);
        int floatingBlockCount = megalithConfig.floatingBlockCount().method_35008(random);
        ArrayList<class_2338> validFallenBlockCoords = new ArrayList<class_2338>();
        ArrayList<class_2338> validFloatingBlockCoords = new ArrayList<class_2338>();
        float[][] erosionMask = MegalithFeature.createErosionMask(lengthX, lengthZ);
        for (int x = 0; x < lengthX; ++x) {
            for (int z = 0; z < lengthZ; ++z) {
                boolean canErodeLayer = true;
                boolean lastBlockAir = true;
                for (int y = -megalithConfig.fallenBlockSearchRange(); y < lengthY; ++y) {
                    class_2338 currPos = blockPos.method_10069(x, y, z);
                    if (y < 0) {
                        boolean currBlockAir = level.method_22347(currPos);
                        if (currBlockAir) {
                            if (lastBlockAir) {
                                validFloatingBlockCoords.add(currPos);
                                continue;
                            }
                            validFallenBlockCoords.add(currPos);
                            continue;
                        }
                        lastBlockAir = false;
                        continue;
                    }
                    if (!megalithConfig.canReplaceBlocks() && !level.method_22347(currPos)) continue;
                    class_2680 blockState = class_2246.field_10124.method_9564();
                    if (y < megalithConfig.maxErosionDepth()) {
                        float erosionDepthMask = 1.0f - (float)y / (float)megalithConfig.maxErosionDepth();
                        float combinedErosionChance = (float)megalithConfig.erosionChance() * erosionMask[x][z] * erosionDepthMask;
                        if (canErodeLayer && random.method_43057() < combinedErosionChance) {
                            this.method_13153((class_1945)level, currPos, blockState);
                            continue;
                        }
                        canErodeLayer = false;
                    }
                    blockState = megalithConfig.megalithBlocks().method_23455(random, currPos);
                    this.method_13153((class_1945)level, currPos, blockState);
                }
            }
        }
        this.placeFallenBlocks(validFallenBlockCoords, fallenBlockCount, megalithConfig.megalithBlocks(), random, level);
        this.placeFallenBlocks(validFloatingBlockCoords, floatingBlockCount, megalithConfig.megalithBlocks(), random, level);
        return true;
    }

    private void placeFallenBlocks(List<class_2338> coords, int count, class_4651 blockStateProvider, class_5819 random, class_5281 level) {
        int i;
        for (i = coords.size() - 1; i > 0; --i) {
            int j = random.method_43048(i + 1);
            Collections.swap(coords, i, j);
        }
        for (i = 0; i < Math.min(count, coords.size()); ++i) {
            class_2338 pos = coords.get(i);
            class_2680 blockState = blockStateProvider.method_23455(random, pos);
            this.method_13153((class_1945)level, pos, blockState);
        }
    }

    private static float[][] createErosionMask(int x, int z) {
        float[][] mask = new float[x][z];
        float centerX = (float)x / 2.0f;
        float centerZ = (float)z / 2.0f;
        float maxDistSquared = centerX * centerX + centerZ * centerZ;
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < z; ++j) {
                float dXSquared = ((float)j - centerX) * ((float)j - centerX);
                float dZSquared = ((float)i - centerZ) * ((float)i - centerZ);
                float distSquared = dXSquared + dZSquared;
                mask[i][j] = (float)StrictMath.sqrt(StrictMath.sqrt(distSquared / maxDistSquared));
            }
        }
        return mask;
    }
}

