/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.worldgen.structure;

import com.mojang.serialization.Codec;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3532;
import net.minecraft.class_4780;
import net.minecraft.class_4784;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.jetbrains.annotations.NotNull;

public class AncientFungusFeature
extends class_3031<class_4780> {
    private static final float field_31507 = 0.06f;

    public AncientFungusFeature(Codec<class_4780> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<class_4780> context) {
        class_5281 structureWorldAccess = context.method_33652();
        class_2338 blockPos = context.method_33655();
        class_5819 random = context.method_33654();
        class_2794 chunkGenerator = context.method_33653();
        class_4780 hugeFungusFeatureConfig = (class_4780)context.method_33656();
        class_2248 block = hugeFungusFeatureConfig.field_22435.method_26204();
        class_2338 blockPos2 = null;
        class_2680 blockState = structureWorldAccess.method_8320(blockPos.method_10084());
        if (blockState.method_27852(block)) {
            blockPos2 = blockPos;
        }
        if (blockPos2 == null) {
            return false;
        }
        int i = class_3532.method_15395((class_5819)random, (int)4, (int)13);
        if (random.method_43048(12) == 0) {
            i *= 2;
        }
        if (!hugeFungusFeatureConfig.field_22194) {
            int j = chunkGenerator.method_12104();
            if (blockPos2.method_10264() + i + 1 >= j) {
                return false;
            }
        }
        boolean bl = !hugeFungusFeatureConfig.field_22194 && random.method_43057() < 0.06f;
        structureWorldAccess.method_8652(blockPos, class_2246.field_10124.method_9564(), 4);
        this.generateStem(structureWorldAccess, random, hugeFungusFeatureConfig, blockPos2, i, bl);
        this.generateHat(structureWorldAccess, random, hugeFungusFeatureConfig, blockPos2, i, bl);
        return true;
    }

    private static boolean isReplaceable(class_5281 world, class_2338 pos, class_4780 config, boolean checkConfig) {
        if (world.method_16358(pos, class_4970.class_4971::method_45474)) {
            return true;
        }
        return checkConfig && config.field_44709.test((Object)world, (Object)pos);
    }

    private void generateStem(class_5281 world, @NotNull class_5819 random, class_4780 config, class_2338 pos, int stemHeight, boolean thickStem) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2680 blockState = config.field_22191;
        int i = thickStem ? 1 : 0;
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                boolean bl = thickStem && class_3532.method_15382((int)j) == i && class_3532.method_15382((int)k) == i;
                for (int l = 0; l < stemHeight; ++l) {
                    mutable.method_25504((class_2382)pos, j, l, k);
                    if (!AncientFungusFeature.isReplaceable(world, (class_2338)mutable, config, true)) continue;
                    if (config.field_22194) {
                        if (!world.method_8320(mutable.method_10084()).method_26215()) {
                            world.method_22352((class_2338)mutable, true);
                        }
                        world.method_8652((class_2338)mutable, blockState, 3);
                        continue;
                    }
                    if (bl) {
                        if (!(random.method_43057() < 0.1f)) continue;
                        this.method_13153((class_1945)world, (class_2338)mutable, blockState);
                        continue;
                    }
                    this.method_13153((class_1945)world, (class_2338)mutable, blockState);
                }
            }
        }
    }

    private void generateHat(class_5281 world, @NotNull class_5819 random, class_4780 config, class_2338 pos, int hatHeight, boolean thickStem) {
        int j;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        boolean bl = config.field_22192.method_27852(class_2246.field_10335);
        int i = Math.min(random.method_43048(1 + hatHeight / 3) + 5, hatHeight);
        for (int k = j = hatHeight - i; k <= hatHeight; ++k) {
            int l;
            int n = l = k < hatHeight - random.method_43048(3) ? 2 : 1;
            if (i > 8 && k < j + 4) {
                l = 3;
            }
            if (thickStem) {
                ++l;
            }
            for (int m = -l; m <= l; ++m) {
                for (int n2 = -l; n2 <= l; ++n2) {
                    boolean bl2 = m == -l || m == l;
                    boolean bl3 = n2 == -l || n2 == l;
                    boolean bl4 = !bl2 && !bl3 && k != hatHeight;
                    boolean bl5 = bl2 && bl3;
                    boolean bl6 = k < j + 3;
                    mutable.method_25504((class_2382)pos, m, k, n2);
                    if (!AncientFungusFeature.isReplaceable(world, (class_2338)mutable, config, false)) continue;
                    if (config.field_22194 && !world.method_8320(mutable.method_10084()).method_26215()) {
                        world.method_22352((class_2338)mutable, true);
                    }
                    if (bl6) {
                        if (bl4) continue;
                        this.placeWithOptionalVines((class_1936)world, random, (class_2338)mutable, config.field_22192, bl);
                        continue;
                    }
                    if (bl4) {
                        this.placeHatBlock((class_1936)world, random, config, mutable, 0.1f, 0.2f, bl ? 0.1f : 0.0f);
                        continue;
                    }
                    if (bl5) {
                        this.placeHatBlock((class_1936)world, random, config, mutable, 0.01f, 0.7f, bl ? 0.083f : 0.0f);
                        continue;
                    }
                    this.placeHatBlock((class_1936)world, random, config, mutable, 5.0E-4f, 0.98f, bl ? 0.07f : 0.0f);
                }
            }
        }
    }

    private void placeHatBlock(class_1936 world, @NotNull class_5819 random, class_4780 config, class_2338.class_2339 pos, float decorationChance, float generationChance, float vineChance) {
        if (random.method_43057() < decorationChance) {
            this.method_13153((class_1945)world, (class_2338)pos, config.field_22193);
        } else if (random.method_43057() < generationChance) {
            this.method_13153((class_1945)world, (class_2338)pos, config.field_22192);
            if (random.method_43057() < vineChance) {
                AncientFungusFeature.generateVines((class_2338)pos, world, random);
            }
        }
    }

    private void placeWithOptionalVines(class_1936 world, @NotNull class_5819 random, class_2338 pos, class_2680 state, boolean vines) {
        if (world.method_8320(pos.method_10084()).method_27852(state.method_26204())) {
            this.method_13153((class_1945)world, pos, state);
        } else if ((double)random.method_43057() < 0.15) {
            this.method_13153((class_1945)world, pos, state);
            if (vines && random.method_43048(11) == 0) {
                AncientFungusFeature.generateVines(pos, world, random);
            }
        }
    }

    private static void generateVines(class_2338 pos, class_1936 world, @NotNull class_5819 random) {
        class_2338.class_2339 mutable = pos.method_25503().method_10098(class_2350.field_11036);
        if (world.method_22347((class_2338)mutable)) {
            int i = class_3532.method_15395((class_5819)random, (int)1, (int)5);
            if (random.method_43048(7) == 0) {
                i *= 2;
            }
            class_4784.method_24450((class_1936)world, (class_5819)random, (class_2338.class_2339)mutable, (int)i, (int)23, (int)25);
        }
    }
}

