/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.worldgen.structure;

import com.google.common.collect.Lists;
import com.jamiedev.bygone.common.block.gourds.GourdDangoWallBlock;
import com.jamiedev.bygone.common.worldgen.structure.BygoneMineshaftStructure;
import com.jamiedev.bygone.core.init.JamiesModLootTables;
import com.jamiedev.bygone.core.registry.BGBlocks;
import com.jamiedev.bygone.core.registry.BGEntityTypes;
import com.jamiedev.bygone.core.registry.BGStructures;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1694;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2382;
import net.minecraft.class_2443;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3773;
import net.minecraft.class_4538;
import net.minecraft.class_5138;
import net.minecraft.class_52;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import net.minecraft.class_6908;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BygoneMineshaftGenerator {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int field_31551 = 3;
    private static final int field_31552 = 3;
    private static final int field_31553 = 5;
    private static final int field_31554 = 20;
    private static final int field_31555 = 50;
    private static final int field_31556 = 8;
    public static final int field_34729 = 50;

    private static BygoneMineshaftPart pickPiece(class_6130 holder, @NotNull class_5819 random, int x, int y, int z, @Nullable class_2350 orientation, int chainLength, BygoneMineshaftStructure.Type type) {
        int i = random.method_43048(100);
        if (i >= 80) {
            class_3341 blockBox = BygoneMineshaftCrossing.getBoundingBox(holder, random, x, y, z, orientation);
            if (blockBox != null) {
                return new BygoneMineshaftCrossing(chainLength, blockBox, orientation, type);
            }
        } else if (i >= 70) {
            assert (orientation != null);
            class_3341 blockBox = BygoneMineshaftStairs.getBoundingBox(holder, random, x, y, z, orientation);
            if (blockBox != null) {
                return new BygoneMineshaftStairs(chainLength, blockBox, orientation, type);
            }
        } else {
            class_3341 blockBox = BygoneMineshaftCorridor.getBoundingBox(holder, random, x, y, z, orientation);
            if (blockBox != null) {
                return new BygoneMineshaftCorridor(chainLength, random, blockBox, orientation, type);
            }
        }
        return null;
    }

    static BygoneMineshaftPart pieceGenerator(class_3443 start, class_6130 holder, @NotNull class_5819 random, int x, int y, int z, class_2350 orientation, int chainLength) {
        if (chainLength > 8) {
            return null;
        }
        if (Math.abs(x - start.method_14935().method_35415()) <= 80 && Math.abs(z - start.method_14935().method_35417()) <= 80) {
            BygoneMineshaftStructure.Type type = ((BygoneMineshaftPart)start).mineshaftType;
            BygoneMineshaftPart mineshaftPart = BygoneMineshaftGenerator.pickPiece(holder, random, x, y, z, orientation, chainLength + 1, type);
            if (mineshaftPart != null) {
                holder.method_35462((class_3443)mineshaftPart);
                mineshaftPart.method_14918(start, holder, random);
            }
            return mineshaftPart;
        }
        return null;
    }

    public static class BygoneMineshaftCrossing
    extends BygoneMineshaftPart {
        private final class_2350 direction;

        public BygoneMineshaftCrossing(class_6625 context, class_2487 nbt) {
            super(BGStructures.BYGONE_MINESHAFT_CROSSING, nbt);
            this.direction = class_2350.method_10139((int)nbt.method_10550("D"));
        }

        @Override
        protected void method_14943(class_6625 context, class_2487 nbt) {
            super.method_14943(context, nbt);
            nbt.method_10569("D", this.direction.method_10161());
        }

        public BygoneMineshaftCrossing(int chainLength, class_3341 boundingBox, @Nullable class_2350 orientation, BygoneMineshaftStructure.Type type) {
            super(BGStructures.BYGONE_MINESHAFT_CROSSING, chainLength, type, boundingBox);
            this.direction = orientation;
        }

        @Nullable
        public static class_3341 getBoundingBox(class_6130 holder, @NotNull class_5819 random, int x, int y, int z, class_2350 orientation) {
            int i = random.method_43048(4) == 0 ? 6 : 2;
            class_3341 blockBox = switch (orientation) {
                default -> new class_3341(-1, 0, -4, 3, i, 0);
                case class_2350.field_11035 -> new class_3341(-1, 0, 0, 3, i, 4);
                case class_2350.field_11039 -> new class_3341(-4, 0, -1, 0, i, 3);
                case class_2350.field_11034 -> new class_3341(0, 0, -1, 4, i, 3);
            };
            blockBox.method_14661(x, y, z);
            return holder.method_35461(blockBox) != null ? null : blockBox;
        }

        public void method_14918(class_3443 start, class_6130 holder, @NotNull class_5819 random) {
            int i = this.method_14923();
            switch (this.direction) {
                default: {
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415() + 1, this.field_15315.method_35416(), this.field_15315.method_35417() - 1, class_2350.field_11043, i);
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415() - 1, this.field_15315.method_35416(), this.field_15315.method_35417() + 1, class_2350.field_11039, i);
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35418() + 1, this.field_15315.method_35416(), this.field_15315.method_35417() + 1, class_2350.field_11034, i);
                    break;
                }
                case field_11035: {
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415() + 1, this.field_15315.method_35416(), this.field_15315.method_35420() + 1, class_2350.field_11035, i);
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415() - 1, this.field_15315.method_35416(), this.field_15315.method_35417() + 1, class_2350.field_11039, i);
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35418() + 1, this.field_15315.method_35416(), this.field_15315.method_35417() + 1, class_2350.field_11034, i);
                    break;
                }
                case field_11039: {
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415() + 1, this.field_15315.method_35416(), this.field_15315.method_35417() - 1, class_2350.field_11043, i);
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415() + 1, this.field_15315.method_35416(), this.field_15315.method_35420() + 1, class_2350.field_11035, i);
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415() - 1, this.field_15315.method_35416(), this.field_15315.method_35417() + 1, class_2350.field_11039, i);
                    break;
                }
                case field_11034: {
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415() + 1, this.field_15315.method_35416(), this.field_15315.method_35417() - 1, class_2350.field_11043, i);
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415() + 1, this.field_15315.method_35416(), this.field_15315.method_35420() + 1, class_2350.field_11035, i);
                    BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35418() + 1, this.field_15315.method_35416(), this.field_15315.method_35417() + 1, class_2350.field_11034, i);
                }
            }
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, @NotNull class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            if (!this.cannotGenerate((class_1936)world, chunkBox)) {
                class_2680 blockState = this.mineshaftType.getPlanks();
                this.method_14940(world, chunkBox, this.field_15315.method_35415() + 1, this.field_15315.method_35416(), this.field_15315.method_35417(), this.field_15315.method_35418() - 1, this.field_15315.method_35419(), this.field_15315.method_35420(), field_15314, field_15314, false);
                this.method_14940(world, chunkBox, this.field_15315.method_35415(), this.field_15315.method_35416(), this.field_15315.method_35417() + 1, this.field_15315.method_35418(), this.field_15315.method_35419(), this.field_15315.method_35420() - 1, field_15314, field_15314, false);
                this.generateCrossingPillar(world, chunkBox, this.field_15315.method_35415() + 1, this.field_15315.method_35416(), this.field_15315.method_35417() + 1, this.field_15315.method_35419());
                this.generateCrossingPillar(world, chunkBox, this.field_15315.method_35415() + 1, this.field_15315.method_35416(), this.field_15315.method_35420() - 1, this.field_15315.method_35419());
                this.generateCrossingPillar(world, chunkBox, this.field_15315.method_35418() - 1, this.field_15315.method_35416(), this.field_15315.method_35417() + 1, this.field_15315.method_35419());
                this.generateCrossingPillar(world, chunkBox, this.field_15315.method_35418() - 1, this.field_15315.method_35416(), this.field_15315.method_35420() - 1, this.field_15315.method_35419());
                int i = this.field_15315.method_35416() - 1;
                for (int j = this.field_15315.method_35415(); j <= this.field_15315.method_35418(); ++j) {
                    for (int k = this.field_15315.method_35417(); k <= this.field_15315.method_35420(); ++k) {
                        this.tryPlaceFloor(world, chunkBox, blockState, j, i, k);
                    }
                }
            }
        }

        private void generateCrossingPillar(class_5281 world, class_3341 boundingBox, int x, int minY, int z, int maxY) {
            if (!this.method_14929((class_1922)world, x, maxY + 1, z, boundingBox).method_26215()) {
                this.method_14940(world, boundingBox, x, minY, z, x, maxY, z, this.mineshaftType.getPlanks(), field_15314, false);
            }
        }
    }

    public static class BygoneMineshaftStairs
    extends BygoneMineshaftPart {
        public BygoneMineshaftStairs(int chainLength, class_3341 boundingBox, class_2350 orientation, BygoneMineshaftStructure.Type type) {
            super(BGStructures.BYGONE_MINESHAFT_STAIRS, chainLength, type, boundingBox);
            this.method_14926(orientation);
        }

        public BygoneMineshaftStairs(class_6625 context, class_2487 nbt) {
            super(BGStructures.BYGONE_MINESHAFT_STAIRS, nbt);
        }

        @Nullable
        public static class_3341 getBoundingBox(class_6130 holder, @NotNull class_5819 random, int x, int y, int z, class_2350 orientation) {
            class_3341 blockBox = switch (orientation) {
                default -> new class_3341(0, -5, -8, 2, 2, 0);
                case class_2350.field_11035 -> new class_3341(0, -5, 0, 2, 2, 8);
                case class_2350.field_11039 -> new class_3341(-8, -5, 0, 0, 2, 2);
                case class_2350.field_11034 -> new class_3341(0, -5, 0, 8, 2, 2);
            };
            blockBox.method_14661(x, y, z);
            return holder.method_35461(blockBox) != null ? null : blockBox;
        }

        public void method_14918(class_3443 start, class_6130 holder, @NotNull class_5819 random) {
            int i = this.method_14923();
            class_2350 direction = this.method_14934();
            if (direction != null) {
                switch (direction) {
                    default: {
                        BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415(), this.field_15315.method_35416(), this.field_15315.method_35417() - 1, class_2350.field_11043, i);
                        break;
                    }
                    case field_11035: {
                        BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415(), this.field_15315.method_35416(), this.field_15315.method_35420() + 1, class_2350.field_11035, i);
                        break;
                    }
                    case field_11039: {
                        BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415() - 1, this.field_15315.method_35416(), this.field_15315.method_35417(), class_2350.field_11039, i);
                        break;
                    }
                    case field_11034: {
                        BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35418() + 1, this.field_15315.method_35416(), this.field_15315.method_35417(), class_2350.field_11034, i);
                    }
                }
            }
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, @NotNull class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            if (!this.cannotGenerate((class_1936)world, chunkBox)) {
                this.method_14940(world, chunkBox, 0, 5, 0, 2, 7, 1, field_15314, field_15314, false);
                this.method_14940(world, chunkBox, 0, 0, 7, 2, 2, 8, field_15314, field_15314, false);
                for (int i = 0; i < 5; ++i) {
                    this.method_14940(world, chunkBox, 0, 5 - i - (i < 4 ? 1 : 0), 2 + i, 2, 7 - i, 2 + i, field_15314, field_15314, false);
                }
            }
        }
    }

    public static class BygoneMineshaftCorridor
    extends BygoneMineshaftPart {
        private final boolean hasRails;
        private final boolean hasCobwebs;
        private boolean hasSpawner;
        private final int length;

        public BygoneMineshaftCorridor(class_2487 nbt) {
            super(BGStructures.BYGONE_MINESHAFT_CORRIDOR, nbt);
            this.hasRails = nbt.method_10577("hr");
            this.hasCobwebs = nbt.method_10577("sc");
            this.hasSpawner = nbt.method_10577("hps");
            this.length = nbt.method_10550("Num");
        }

        public BygoneMineshaftCorridor(class_6625 structureContext, class_2487 nbt) {
            super(BGStructures.BYGONE_MINESHAFT_CORRIDOR, nbt);
            this.hasRails = nbt.method_10577("hr");
            this.hasCobwebs = nbt.method_10577("sc");
            this.hasSpawner = nbt.method_10577("hps");
            this.length = nbt.method_10550("Num");
        }

        @Override
        protected void method_14943(class_6625 context, class_2487 nbt) {
            super.method_14943(context, nbt);
            nbt.method_10556("hr", this.hasRails);
            nbt.method_10556("sc", this.hasCobwebs);
            nbt.method_10556("hps", this.hasSpawner);
            nbt.method_10569("Num", this.length);
        }

        public BygoneMineshaftCorridor(int chainLength, @NotNull class_5819 random, class_3341 boundingBox, class_2350 orientation, BygoneMineshaftStructure.Type type) {
            super(BGStructures.BYGONE_MINESHAFT_CORRIDOR, chainLength, type, boundingBox);
            this.method_14926(orientation);
            this.hasRails = random.method_43048(3) == 0;
            this.hasCobwebs = !this.hasRails && random.method_43048(23) == 0;
            this.length = Objects.requireNonNull(this.method_14934()).method_10166() == class_2350.class_2351.field_11051 ? boundingBox.method_14663() / 5 : boundingBox.method_35414() / 5;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        public static class_3341 getBoundingBox(class_6130 holder, @NotNull class_5819 random, int x, int y, int z, class_2350 orientation) {
            int i = random.method_43048(3) + 2;
            while (i > 0) {
                int j = i * 5;
                class_3341 blockBox = switch (orientation) {
                    default -> new class_3341(0, 0, -(j - 1), 2, 2, 0);
                    case class_2350.field_11035 -> new class_3341(0, 0, 0, 2, 2, j - 1);
                    case class_2350.field_11039 -> new class_3341(-(j - 1), 0, 0, 0, 2, 2);
                    case class_2350.field_11034 -> new class_3341(0, 0, 0, j - 1, 2, 2);
                };
                blockBox.method_14661(x, y, z);
                if (holder.method_35461(blockBox) == null) {
                    return blockBox;
                }
                --i;
            }
            return null;
        }

        public void method_14918(class_3443 start, class_6130 holder, @NotNull class_5819 random) {
            block24: {
                int i = this.method_14923();
                int j = random.method_43048(4);
                class_2350 direction = this.method_14934();
                if (direction != null) {
                    switch (direction) {
                        default: {
                            if (j <= 1) {
                                BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415(), this.field_15315.method_35416() - 1 + random.method_43048(3), this.field_15315.method_35417() - 1, direction, i);
                                break;
                            }
                            if (j == 2) {
                                BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415() - 1, this.field_15315.method_35416() - 1 + random.method_43048(3), this.field_15315.method_35417(), class_2350.field_11039, i);
                                break;
                            }
                            BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35418() + 1, this.field_15315.method_35416() - 1 + random.method_43048(3), this.field_15315.method_35417(), class_2350.field_11034, i);
                            break;
                        }
                        case field_11035: {
                            if (j <= 1) {
                                BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415(), this.field_15315.method_35416() - 1 + random.method_43048(3), this.field_15315.method_35420() + 1, direction, i);
                                break;
                            }
                            if (j == 2) {
                                BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415() - 1, this.field_15315.method_35416() - 1 + random.method_43048(3), this.field_15315.method_35420() - 3, class_2350.field_11039, i);
                                break;
                            }
                            BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35418() + 1, this.field_15315.method_35416() - 1 + random.method_43048(3), this.field_15315.method_35420() - 3, class_2350.field_11034, i);
                            break;
                        }
                        case field_11039: {
                            if (j <= 1) {
                                BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415() - 1, this.field_15315.method_35416() - 1 + random.method_43048(3), this.field_15315.method_35417(), direction, i);
                                break;
                            }
                            if (j == 2) {
                                BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415(), this.field_15315.method_35416() - 1 + random.method_43048(3), this.field_15315.method_35417() - 1, class_2350.field_11043, i);
                                break;
                            }
                            BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415(), this.field_15315.method_35416() - 1 + random.method_43048(3), this.field_15315.method_35420() + 1, class_2350.field_11035, i);
                            break;
                        }
                        case field_11034: {
                            if (j <= 1) {
                                BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35418() + 1, this.field_15315.method_35416() - 1 + random.method_43048(3), this.field_15315.method_35417(), direction, i);
                                break;
                            }
                            if (j == 2) {
                                BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35418() - 3, this.field_15315.method_35416() - 1 + random.method_43048(3), this.field_15315.method_35417() - 1, class_2350.field_11043, i);
                                break;
                            }
                            BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35418() - 3, this.field_15315.method_35416() - 1 + random.method_43048(3), this.field_15315.method_35420() + 1, class_2350.field_11035, i);
                        }
                    }
                }
                if (i >= 8) break block24;
                if (direction != class_2350.field_11043 && direction != class_2350.field_11035) {
                    int k = this.field_15315.method_35415() + 3;
                    while (k + 3 <= this.field_15315.method_35418()) {
                        int l = random.method_43048(5);
                        if (l == 0) {
                            BygoneMineshaftGenerator.pieceGenerator(start, holder, random, k, this.field_15315.method_35416(), this.field_15315.method_35417() - 1, class_2350.field_11043, i + 1);
                        } else if (l == 1) {
                            BygoneMineshaftGenerator.pieceGenerator(start, holder, random, k, this.field_15315.method_35416(), this.field_15315.method_35420() + 1, class_2350.field_11035, i + 1);
                        }
                        k += 5;
                    }
                } else {
                    int k = this.field_15315.method_35417() + 3;
                    while (k + 3 <= this.field_15315.method_35420()) {
                        int l = random.method_43048(5);
                        if (l == 0) {
                            BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415() - 1, this.field_15315.method_35416(), k, class_2350.field_11039, i + 1);
                        } else if (l == 1) {
                            BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35418() + 1, this.field_15315.method_35416(), k, class_2350.field_11034, i + 1);
                        }
                        k += 5;
                    }
                }
            }
        }

        protected boolean method_14915(class_5281 world, class_3341 boundingBox, @NotNull class_5819 random, int x, int y, int z, class_5321<class_52> lootTable) {
            class_2338.class_2339 blockPos = this.method_33781(x, y, z);
            if (boundingBox.method_14662((class_2382)blockPos) && world.method_8320((class_2338)blockPos).method_26215() && !world.method_8320(blockPos.method_10074()).method_26215()) {
                class_2680 blockState = (class_2680)class_2246.field_10167.method_9564().method_11657((class_2769)class_2443.field_11369, (Comparable)(random.method_43056() ? class_2768.field_12665 : class_2768.field_12674));
                this.method_14917(world, blockState, x, y, z, boundingBox);
                class_1694 chestMinecartEntity = new class_1694((class_1937)world.method_8410(), (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5);
                chestMinecartEntity.method_7562(lootTable, random.method_43055());
                world.method_8649((class_1297)chestMinecartEntity);
                return true;
            }
            return false;
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, @NotNull class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            if (!this.cannotGenerate((class_1936)world, chunkBox)) {
                int o;
                int n;
                int m = this.length * 5 - 1;
                class_2680 blockState = this.mineshaftType.getPlanks();
                this.method_14940(world, chunkBox, 0, 0, 0, 2, 1, m, field_15314, field_15314, false);
                this.method_14933(world, chunkBox, random, 0.8f, 0, 2, 0, 2, 2, m, field_15314, field_15314, false, false);
                if (this.hasCobwebs) {
                    this.method_14933(world, chunkBox, random, 0.6f, 0, 0, 0, 2, 1, m, class_2246.field_10343.method_9564(), field_15314, false, true);
                }
                for (n = 0; n < this.length; ++n) {
                    int q;
                    class_2338.class_2339 blockPos;
                    o = 2 + n * 5;
                    this.generateSupports(world, chunkBox, 0, 0, o, 2, 2, random);
                    this.addCobwebsUnderground(world, chunkBox, random, 0.1f, 0, 2, o - 1);
                    this.addCobwebsUnderground(world, chunkBox, random, 0.1f, 2, 2, o - 1);
                    this.addCobwebsUnderground(world, chunkBox, random, 0.1f, 0, 2, o + 1);
                    this.addCobwebsUnderground(world, chunkBox, random, 0.1f, 2, 2, o + 1);
                    this.addCobwebsUnderground(world, chunkBox, random, 0.05f, 0, 2, o - 2);
                    this.addCobwebsUnderground(world, chunkBox, random, 0.05f, 2, 2, o - 2);
                    this.addCobwebsUnderground(world, chunkBox, random, 0.05f, 0, 2, o + 2);
                    this.addCobwebsUnderground(world, chunkBox, random, 0.05f, 2, 2, o + 2);
                    if (random.method_43048(100) == 0) {
                        this.method_14915(world, chunkBox, random, 2, 0, o - 1, JamiesModLootTables.ABANDONED_MINESHAFT_CHEST);
                    }
                    if (random.method_43048(100) == 0) {
                        this.method_14915(world, chunkBox, random, 0, 0, o + 1, JamiesModLootTables.ABANDONED_MINESHAFT_CHEST);
                    }
                    if (!this.hasCobwebs || this.hasSpawner || !chunkBox.method_14662((class_2382)(blockPos = this.method_33781(1, 0, q = o - 1 + random.method_43048(3)))) || !this.method_14939((class_4538)world, 1, 0, q, chunkBox)) continue;
                    this.hasSpawner = true;
                    world.method_8652((class_2338)blockPos, class_2246.field_10260.method_9564(), 2);
                    class_2586 blockEntity = world.method_8321((class_2338)blockPos);
                    if (!(blockEntity instanceof class_2636)) continue;
                    class_2636 mobSpawnerBlockEntity = (class_2636)blockEntity;
                    mobSpawnerBlockEntity.method_46408(BGEntityTypes.PESKY.get(), random);
                }
                for (n = 0; n <= 2; ++n) {
                    for (o = 0; o <= m; ++o) {
                        this.tryPlaceFloor(world, chunkBox, blockState, n, -1, o);
                    }
                }
                this.fillSupportBeam(world, chunkBox, 0, -1, 2);
                if (this.length > 1) {
                    o = m - 2;
                    this.fillSupportBeam(world, chunkBox, 0, -1, o);
                }
                if (this.hasRails) {
                    class_2680 blockState2 = (class_2680)class_2246.field_10167.method_9564().method_11657((class_2769)class_2443.field_11369, (Comparable)class_2768.field_12665);
                    for (int p = 0; p <= m; ++p) {
                        class_2680 blockState3 = this.method_14929((class_1922)world, 1, -1, p, chunkBox);
                        if (blockState3.method_26215() || !blockState3.method_26216((class_1922)world, (class_2338)this.method_33781(1, -1, p))) continue;
                        float f = this.method_14939((class_4538)world, 1, 0, p, chunkBox) ? 0.7f : 0.9f;
                        this.method_14945(world, chunkBox, random, f, 1, 0, p, blockState2);
                    }
                }
            }
        }

        private void fillSupportBeam(class_5281 world, class_3341 box, int x, int y, int z) {
            class_2680 blockState = this.mineshaftType.getLog();
            class_2680 blockState2 = this.mineshaftType.getPlanks();
            if (this.method_14929((class_1922)world, x, y, z, box).method_27852(blockState2.method_26204())) {
                this.fillSupportBeam(world, blockState, x, y, z, box);
            }
            if (this.method_14929((class_1922)world, x + 2, y, z, box).method_27852(blockState2.method_26204())) {
                this.fillSupportBeam(world, blockState, x + 2, y, z, box);
            }
        }

        protected void method_14936(class_5281 world, class_2680 state, int x, int y, int z, class_3341 box) {
            class_2338.class_2339 mutable = this.method_33781(x, y, z);
            if (box.method_14662((class_2382)mutable)) {
                int i = mutable.method_10264();
                while (this.method_33881(world.method_8320((class_2338)mutable)) && mutable.method_10264() > world.method_31607() + 1) {
                    mutable.method_10098(class_2350.field_11033);
                }
                if (this.isUpsideSolidFullSquare((class_4538)world, (class_2338)mutable, world.method_8320((class_2338)mutable))) {
                    while (mutable.method_10264() < i) {
                        mutable.method_10098(class_2350.field_11036);
                        world.method_8652((class_2338)mutable, state, 2);
                    }
                }
            }
        }

        protected void fillSupportBeam(class_5281 world, class_2680 state, int x, int y, int z, class_3341 box) {
            class_2338.class_2339 mutable = this.method_33781(x, y, z);
            if (box.method_14662((class_2382)mutable)) {
                int i = mutable.method_10264();
                int j = 1;
                boolean bl = true;
                boolean bl2 = true;
                while (bl || bl2) {
                    boolean bl3;
                    class_2680 blockState;
                    if (bl) {
                        mutable.method_33098(i - j);
                        blockState = world.method_8320((class_2338)mutable);
                        boolean bl4 = bl3 = this.method_33881(blockState) && !blockState.method_27852(class_2246.field_10164);
                        if (!bl3 && this.isUpsideSolidFullSquare((class_4538)world, (class_2338)mutable, blockState)) {
                            BygoneMineshaftCorridor.fillColumn(world, state, mutable, i - j + 1, i);
                            return;
                        }
                        boolean bl5 = bl = j <= 20 && bl3 && mutable.method_10264() > world.method_31607() + 1;
                    }
                    if (bl2) {
                        mutable.method_33098(i + j);
                        blockState = world.method_8320((class_2338)mutable);
                        bl3 = this.method_33881(blockState);
                        if (!bl3 && this.sideCoversSmallSquare((class_4538)world, (class_2338)mutable, blockState)) {
                            world.method_8652((class_2338)mutable.method_33098(i + 1), this.mineshaftType.getFence(), 2);
                            BygoneMineshaftCorridor.fillColumn(world, class_2246.field_23985.method_9564(), mutable, i + 2, i + j);
                            return;
                        }
                        bl2 = j <= 50 && bl3 && mutable.method_10264() < world.method_31600() - 1;
                    }
                    ++j;
                }
            }
        }

        private static void fillColumn(class_5281 world, class_2680 state, class_2338.class_2339 pos, int startY, int endY) {
            for (int i = startY; i < endY; ++i) {
                world.method_8652((class_2338)pos.method_33098(i), state, 2);
            }
        }

        private boolean isUpsideSolidFullSquare(class_4538 world, class_2338 pos, class_2680 state) {
            return state.method_26206((class_1922)world, pos, class_2350.field_11036);
        }

        private boolean sideCoversSmallSquare(class_4538 world, class_2338 pos, class_2680 state) {
            return class_2248.method_20044((class_4538)world, (class_2338)pos, (class_2350)class_2350.field_11033) && !(state.method_26204() instanceof class_2346);
        }

        private void generateSupports(class_5281 world, class_3341 boundingBox, int minX, int minY, int z, int maxY, int maxX, @NotNull class_5819 random) {
            if (this.isSolidCeiling((class_1922)world, boundingBox, minX, maxX, maxY, z)) {
                class_2680 blockState = this.mineshaftType.getPlanks();
                class_2680 blockState2 = this.mineshaftType.getFence();
                this.method_14940(world, boundingBox, minX, minY, z, minX, maxY - 1, z, (class_2680)blockState2.method_11657((class_2769)class_2354.field_10903, (Comparable)Boolean.valueOf(true)), field_15314, false);
                this.method_14940(world, boundingBox, maxX, minY, z, maxX, maxY - 1, z, (class_2680)blockState2.method_11657((class_2769)class_2354.field_10907, (Comparable)Boolean.valueOf(true)), field_15314, false);
                if (random.method_43048(4) == 0) {
                    this.method_14940(world, boundingBox, minX, maxY, z, minX, maxY, z, blockState, field_15314, false);
                    this.method_14940(world, boundingBox, maxX, maxY, z, maxX, maxY, z, blockState, field_15314, false);
                } else {
                    this.method_14940(world, boundingBox, minX, maxY, z, maxX, maxY, z, blockState, field_15314, false);
                    this.method_14945(world, boundingBox, random, 0.05f, minX + 1, maxY, z - 1, (class_2680)BGBlocks.GOURD_DANGO_WALL.get().method_9564().method_11657((class_2769)GourdDangoWallBlock.FACING, (Comparable)class_2350.field_11035));
                    this.method_14945(world, boundingBox, random, 0.05f, minX + 1, maxY, z + 1, (class_2680)BGBlocks.GOURD_DANGO_WALL.get().method_9564().method_11657((class_2769)GourdDangoWallBlock.FACING, (Comparable)class_2350.field_11043));
                }
            }
        }

        private void addCobwebsUnderground(class_5281 world, class_3341 box, @NotNull class_5819 random, float threshold, int x, int y, int z) {
            if (this.method_14939((class_4538)world, x, y, z, box) && random.method_43057() < threshold && this.hasSolidNeighborBlocks(world, box, x, y, z, 2)) {
                this.method_14917(world, class_2246.field_10343.method_9564(), x, y, z, box);
            }
        }

        private boolean hasSolidNeighborBlocks(class_5281 world, class_3341 box, int x, int y, int z, int count) {
            class_2338.class_2339 mutable = this.method_33781(x, y, z);
            int i = 0;
            for (class_2350 direction : class_2350.values()) {
                mutable.method_10098(direction);
                if (box.method_14662((class_2382)mutable) && world.method_8320((class_2338)mutable).method_26206((class_1922)world, (class_2338)mutable, direction.method_10153()) && ++i >= count) {
                    return true;
                }
                mutable.method_10098(direction.method_10153());
            }
            return false;
        }
    }

    private static abstract class BygoneMineshaftPart
    extends class_3443 {
        protected BygoneMineshaftStructure.Type mineshaftType;

        public BygoneMineshaftPart(class_3773 structurePieceType, int chainLength, BygoneMineshaftStructure.Type type, class_3341 box) {
            super(structurePieceType, chainLength, box);
            this.mineshaftType = type;
        }

        public BygoneMineshaftPart(class_3773 structurePieceType, class_2487 nbtCompound) {
            super(structurePieceType, nbtCompound);
            this.mineshaftType = BygoneMineshaftStructure.Type.byId(nbtCompound.method_10550("MST"));
        }

        protected boolean method_33780(class_4538 world, int x, int y, int z, class_3341 box) {
            class_2680 blockState = this.method_14929((class_1922)world, x, y, z, box);
            return !blockState.method_27852(this.mineshaftType.getPlanks().method_26204()) && !blockState.method_27852(this.mineshaftType.getLog().method_26204()) && !blockState.method_27852(this.mineshaftType.getFence().method_26204()) && !blockState.method_27852(class_2246.field_23985);
        }

        protected void method_14943(class_6625 context, class_2487 nbt) {
            nbt.method_10569("MST", this.mineshaftType.ordinal());
        }

        protected boolean isSolidCeiling(class_1922 world, class_3341 boundingBox, int minX, int maxX, int y, int z) {
            for (int i = minX; i <= maxX; ++i) {
                if (!this.method_14929(world, i, y + 1, z, boundingBox).method_26215()) continue;
                return false;
            }
            return true;
        }

        protected boolean cannotGenerate(class_1936 world, class_3341 box) {
            int p;
            int o;
            int n;
            int m;
            int i = Math.max(this.field_15315.method_35415() - 1, box.method_35415());
            int j = Math.max(this.field_15315.method_35416() - 1, box.method_35416());
            int k = Math.max(this.field_15315.method_35417() - 1, box.method_35417());
            int l = Math.min(this.field_15315.method_35418() + 1, box.method_35418());
            class_2338.class_2339 mutable = new class_2338.class_2339((i + l) / 2, (j + (m = Math.min(this.field_15315.method_35419() + 1, box.method_35419()))) / 2, (k + (n = Math.min(this.field_15315.method_35420() + 1, box.method_35420()))) / 2);
            if (world.method_23753((class_2338)mutable).method_40220(class_6908.field_39444)) {
                return true;
            }
            for (o = i; o <= l; ++o) {
                for (p = k; p <= n; ++p) {
                    if (world.method_8320((class_2338)mutable.method_10103(o, j, p)).method_51176()) {
                        return true;
                    }
                    if (!world.method_8320((class_2338)mutable.method_10103(o, m, p)).method_51176()) continue;
                    return true;
                }
            }
            for (o = i; o <= l; ++o) {
                for (p = j; p <= m; ++p) {
                    if (world.method_8320((class_2338)mutable.method_10103(o, p, k)).method_51176()) {
                        return true;
                    }
                    if (!world.method_8320((class_2338)mutable.method_10103(o, p, n)).method_51176()) continue;
                    return true;
                }
            }
            for (o = k; o <= n; ++o) {
                for (p = j; p <= m; ++p) {
                    if (world.method_8320((class_2338)mutable.method_10103(i, p, o)).method_51176()) {
                        return true;
                    }
                    if (!world.method_8320((class_2338)mutable.method_10103(l, p, o)).method_51176()) continue;
                    return true;
                }
            }
            return false;
        }

        protected void tryPlaceFloor(class_5281 world, class_3341 box, class_2680 state, int x, int y, int z) {
            class_2338.class_2339 blockPos;
            class_2680 blockState;
            if (this.method_14939((class_4538)world, x, y, z, box) && !(blockState = world.method_8320((class_2338)(blockPos = this.method_33781(x, y, z)))).method_26206((class_1922)world, (class_2338)blockPos, class_2350.field_11036)) {
                world.method_8652((class_2338)blockPos, state, 2);
            }
        }
    }

    public static class BygoneMineshaftRoom
    extends BygoneMineshaftPart {
        private final List<class_3341> entrances = Lists.newLinkedList();

        public BygoneMineshaftRoom(int chainLength, @NotNull class_5819 random, int x, int z, BygoneMineshaftStructure.Type type) {
            super(BGStructures.BYGONE_MINESHAFT_ROOM, chainLength, type, new class_3341(x, 100, z, x + 7 + random.method_43048(6), 200, z + 7 + random.method_43048(6)));
            this.mineshaftType = type;
        }

        public BygoneMineshaftRoom(class_6625 context, class_2487 nbt) {
            super(BGStructures.BYGONE_MINESHAFT_ROOM, nbt);
            DataResult var10000 = class_3341.field_29325.listOf().parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10554("Entrances", 11));
            Logger var10001 = LOGGER;
            Objects.requireNonNull(var10001);
            Optional var2 = var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0));
            List<class_3341> var3 = this.entrances;
            Objects.requireNonNull(var3);
            var2.ifPresent(var3::addAll);
        }

        public void method_14918(class_3443 start, class_6130 holder, @NotNull class_5819 random) {
            class_3341 blockBox;
            BygoneMineshaftPart structurePiece;
            int k;
            int i = this.method_14923();
            int j = this.field_15315.method_14660() - 3 - 1;
            if (j <= 0) {
                j = 1;
            }
            for (k = 0; k < this.field_15315.method_35414() && (k += random.method_43048(this.field_15315.method_35414())) + 3 <= this.field_15315.method_35414(); k += 4) {
                structurePiece = BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415() + k, this.field_15315.method_35416() + random.method_43048(j) + 1, this.field_15315.method_35417() - 1, class_2350.field_11043, i);
                if (structurePiece == null) continue;
                blockBox = structurePiece.method_14935();
                this.entrances.add(new class_3341(blockBox.method_35415(), blockBox.method_35416(), this.field_15315.method_35417(), blockBox.method_35418(), blockBox.method_35419(), this.field_15315.method_35417() + 1));
            }
            for (k = 0; k < this.field_15315.method_35414() && (k += random.method_43048(this.field_15315.method_35414())) + 3 <= this.field_15315.method_35414(); k += 4) {
                structurePiece = BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415() + k, this.field_15315.method_35416() + random.method_43048(j) + 1, this.field_15315.method_35420() + 1, class_2350.field_11035, i);
                if (structurePiece == null) continue;
                blockBox = structurePiece.method_14935();
                this.entrances.add(new class_3341(blockBox.method_35415(), blockBox.method_35416(), this.field_15315.method_35420() - 1, blockBox.method_35418(), blockBox.method_35419(), this.field_15315.method_35420()));
            }
            for (k = 0; k < this.field_15315.method_14663() && (k += random.method_43048(this.field_15315.method_14663())) + 3 <= this.field_15315.method_14663(); k += 4) {
                structurePiece = BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35415() - 1, this.field_15315.method_35416() + random.method_43048(j) + 1, this.field_15315.method_35417() + k, class_2350.field_11039, i);
                if (structurePiece == null) continue;
                blockBox = structurePiece.method_14935();
                this.entrances.add(new class_3341(this.field_15315.method_35415(), blockBox.method_35416(), blockBox.method_35417(), this.field_15315.method_35415() + 1, blockBox.method_35419(), blockBox.method_35420()));
            }
            for (k = 0; k < this.field_15315.method_14663() && (k += random.method_43048(this.field_15315.method_14663())) + 3 <= this.field_15315.method_14663(); k += 4) {
                structurePiece = BygoneMineshaftGenerator.pieceGenerator(start, holder, random, this.field_15315.method_35418() + 1, this.field_15315.method_35416() + random.method_43048(j) + 1, this.field_15315.method_35417() + k, class_2350.field_11034, i);
                if (structurePiece == null) continue;
                blockBox = structurePiece.method_14935();
                this.entrances.add(new class_3341(this.field_15315.method_35418() - 1, blockBox.method_35416(), blockBox.method_35417(), this.field_15315.method_35418(), blockBox.method_35419(), blockBox.method_35420()));
            }
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, @NotNull class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            if (!this.cannotGenerate((class_1936)world, chunkBox)) {
                this.method_14940(world, chunkBox, this.field_15315.method_35415(), this.field_15315.method_35416() + 1, this.field_15315.method_35417(), this.field_15315.method_35418(), Math.min(this.field_15315.method_35416() + 3, this.field_15315.method_35419()), this.field_15315.method_35420(), field_15314, field_15314, false);
                for (class_3341 blockBox : this.entrances) {
                    this.method_14940(world, chunkBox, blockBox.method_35415(), blockBox.method_35419() - 2, blockBox.method_35417(), blockBox.method_35418(), blockBox.method_35419(), blockBox.method_35420(), field_15314, field_15314, false);
                }
                this.method_14919(world, chunkBox, this.field_15315.method_35415(), this.field_15315.method_35416() + 4, this.field_15315.method_35417(), this.field_15315.method_35418(), this.field_15315.method_35419(), this.field_15315.method_35420(), field_15314, false);
            }
        }

        public void method_14922(int x, int y, int z) {
            super.method_14922(x, y, z);
            for (class_3341 blockBox : this.entrances) {
                blockBox.method_14661(x, y, z);
            }
        }

        @Override
        protected void method_14943(class_6625 context, class_2487 nbt) {
            super.method_14943(context, nbt);
            DataResult var10000 = class_3341.field_29325.listOf().encodeStart((DynamicOps)class_2509.field_11560, this.entrances);
            Logger var10001 = LOGGER;
            Objects.requireNonNull(var10001);
            var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).ifPresent(nbtElement -> nbt.method_10566("Entrances", nbtElement));
        }
    }
}

