/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block;

import com.jamiedev.bygone.common.block.entity.BlemishSpreadManager;
import com.jamiedev.bygone.common.block.entity.BlemishSpreadable;
import com.jamiedev.bygone.core.registry.BGBlocks;
import com.jamiedev.bygone.core.registry.BGParticleTypes;
import com.mojang.serialization.MapCodec;
import java.util.Iterator;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2266;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3483;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class BlemishBlock
extends class_2248
implements BlemishSpreadable {
    public static final MapCodec<BlemishBlock> CODEC = BlemishBlock.method_54094(BlemishBlock::new);
    class_2266 ref;

    public MapCodec<BlemishBlock> method_53969() {
        return CODEC;
    }

    public BlemishBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        class_243 vec3d = new class_243(0.25, (double)0.05f, 0.25);
        entity.method_5844(state, vec3d);
        entity.method_5643(world.method_48963().method_48832(), 2.0f);
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (!((double)fallDistance < 4.0) && entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            class_1309.class_6823 fallSounds = livingEntity.method_39760();
            class_3414 soundEvent = (double)fallDistance < 7.0 ? fallSounds.comp_301() : fallSounds.comp_302();
            entity.method_5783(soundEvent, 1.0f, 1.0f);
        }
    }

    public static boolean canWalkOnBlemish(class_1297 entity) {
        if (entity.method_5864().method_20210(class_3483.field_27855)) {
            return true;
        }
        return entity instanceof class_1309 && !((class_1309)entity).method_6118(class_1304.field_6166).method_7960();
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, @NotNull class_5819 random) {
        if (random.method_43048(100) == 0) {
            // empty if block
        }
        double d = (double)pos.method_10263() + 0.5 + (0.5 - random.method_43058());
        double e = (double)pos.method_10264() + 1.0;
        double f = (double)pos.method_10260() + 0.5 + (0.5 - random.method_43058());
        double g = (double)random.method_43057() * 0.04;
        world.method_8406((class_2394)BGParticleTypes.BLEMISH, d, e, f, 0.0, g, 0.0);
    }

    @Override
    public int spread(BlemishSpreadManager.Cursor cursor, class_1936 world, class_2338 catalystPos, @NotNull class_5819 random, BlemishSpreadManager spreadManager, boolean shouldConvertToBlock) {
        int i = cursor.getCharge();
        if (i != 0 && random.method_43048(spreadManager.getSpreadChance()) == 0) {
            class_2338 blockPos = cursor.getPos();
            boolean bl = blockPos.method_19771((class_2382)catalystPos, (double)spreadManager.getMaxDistance());
            if (!bl && BlemishBlock.shouldNotDecay(world, blockPos)) {
                int j = spreadManager.getExtraBlockChance();
                if (random.method_43048(j) < i) {
                    class_2338 blockPos2 = blockPos.method_10084();
                    class_2680 blockState = this.getExtraBlockState(world, blockPos2, random, spreadManager.isWorldGen());
                    world.method_8652(blockPos2, blockState, 3);
                    world.method_8396(null, blockPos, blockState.method_26231().method_10598(), class_3419.field_15245, 1.0f, 1.0f);
                }
                return Math.max(0, i - j);
            }
            return random.method_43048(spreadManager.getDecayChance()) != 0 ? i : i - (bl ? 1 : BlemishBlock.getDecay(spreadManager, blockPos, catalystPos, i));
        }
        return i;
    }

    private static int getDecay(BlemishSpreadManager spreadManager, class_2338 cursorPos, class_2338 catalystPos, int charge) {
        int i = spreadManager.getMaxDistance();
        float f = class_3532.method_27285((float)((float)Math.sqrt(cursorPos.method_10262((class_2382)catalystPos)) - (float)i));
        int j = class_3532.method_34954((int)(24 - i));
        float g = Math.min(1.0f, f / (float)j);
        return Math.max(1, (int)((float)charge * g * 0.5f));
    }

    private class_2680 getExtraBlockState(class_1936 world, class_2338 pos, @NotNull class_5819 random, boolean allowShrieker) {
        class_2680 blockState = BGBlocks.BLEMISH_VEIN.get().method_9564();
        return blockState.method_28498((class_2769)class_2741.field_12508) && !world.method_8316(pos).method_15769() ? (class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)) : blockState;
    }

    private static boolean shouldNotDecay(class_1936 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos.method_10084());
        if (blockState.method_26215() || blockState.method_27852(class_2246.field_10382) && blockState.method_26227().method_39360((class_3611)class_3612.field_15910)) {
            boolean i = false;
            Iterator var4 = class_2338.method_10097((class_2338)pos.method_10069(-4, 0, -4), (class_2338)pos.method_10069(4, 2, 4)).iterator();
            while (true) {
                if (!var4.hasNext()) {
                    return true;
                }
                class_2338 class_23382 = (class_2338)var4.next();
            }
        }
        return false;
    }

    @Override
    public boolean shouldConvertToSpreadable() {
        return false;
    }
}

