/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block.cogs;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2429;
import net.minecraft.class_2436;
import net.minecraft.class_2457;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5778;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.class_8235;

public class BaseVerdigrisCogBlock
extends class_2436 {
    public static final MapCodec<class_2436> CODEC = RecordCodecBuilder.mapCodec(p_309135_ -> p_309135_.group((App)VerdigrisStage.CODEC.fieldOf("verdigris_stage").forGetter(poweredBlock -> ((BaseVerdigrisCogBlock)poweredBlock).verdigrisStage), (App)BaseVerdigrisCogBlock.method_54096()).apply((Applicative)p_309135_, BaseVerdigrisCogBlock::new));
    public static final class_2746 UP;
    public static final class_2746 NORTH;
    public static final class_2746 EAST;
    public static final class_2746 SOUTH;
    public static final class_2746 WEST;
    public static final Map<class_2350, class_2746> PROPERTY_BY_DIRECTION;
    protected static final float AABB_OFFSET = 1.0f;
    private static final class_265 UP_AABB;
    private static final class_265 WEST_AABB;
    private static final class_265 EAST_AABB;
    private static final class_265 NORTH_AABB;
    private static final class_265 SOUTH_AABB;
    private final ImmutableMap shapesCache;
    public static final class_2753 FACING;
    public final VerdigrisStage verdigrisStage;
    public static final class_2758 DELAY;
    public static final class_2746 POWERED;

    public MapCodec<class_2436> method_53969() {
        return CODEC;
    }

    public BaseVerdigrisCogBlock(VerdigrisStage stage, class_4970.class_2251 properties) {
        super(properties);
        this.verdigrisStage = stage;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)DELAY, (Comparable)Integer.valueOf(1)));
        this.shapesCache = ImmutableMap.copyOf(this.field_10647.method_11662().stream().collect(Collectors.toMap(Function.identity(), BaseVerdigrisCogBlock::calculateShape)));
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        super.method_9496(state, level, pos, random);
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        level.method_39280(pos, (class_2248)this, this.verdigrisStage.degradationAmount, class_1953.field_9313);
    }

    protected void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        super.method_9588(state, level, pos, random);
        class_2680 newState = this.verdigrisStage.shouldPower ? (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf((Boolean)state.method_11654((class_2769)POWERED) == false)) : (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false));
        level.method_8501(pos, newState);
        if (random.method_43057() < 0.001f) {
            class_2680 replaceState = this.nextBLockState(state, (class_1937)level, pos);
            level.method_8501(pos, replaceState);
        }
        if (this.verdigrisStage.shouldPower) {
            level.method_39280(pos, (class_2248)this, this.verdigrisStage.degradationAmount, class_1953.field_9313);
        }
    }

    public class_2680 nextBLockState(class_2680 oldState, class_1937 level, class_2338 pos) {
        VerdigrisStage verdigrisStage = ((BaseVerdigrisCogBlock)oldState.method_26204()).verdigrisStage;
        if (verdigrisStage == verdigrisStage.last()) {
            return oldState;
        }
        class_2248 nextBlock = (class_2248)class_7923.field_41175.method_10223(class_2960.method_60655((String)"bygone", (String)(verdigrisStage.next().stage.toLowerCase() + "_verdigris_cog")));
        level.method_39280(pos, nextBlock, 1, class_1953.field_9313);
        return nextBlock.method_34725(oldState);
    }

    protected int method_9524(class_2680 blockState, class_1922 blockAccess, class_2338 pos, class_2350 side) {
        if (((Boolean)blockState.method_11654((class_2769)POWERED)).booleanValue() && (side == class_2350.field_11036 || side == class_2350.field_11033)) {
            return super.method_9524(blockState, blockAccess, pos, side);
        }
        return 0;
    }

    private static class_265 calculateShape(class_2680 state) {
        class_265 voxelshape = class_259.method_1073();
        if (((Boolean)state.method_11654((class_2769)UP)).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (((Boolean)state.method_11654((class_2769)NORTH)).booleanValue()) {
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)NORTH_AABB);
        }
        if (((Boolean)state.method_11654((class_2769)SOUTH)).booleanValue()) {
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)SOUTH_AABB);
        }
        if (((Boolean)state.method_11654((class_2769)EAST)).booleanValue()) {
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)EAST_AABB);
        }
        if (((Boolean)state.method_11654((class_2769)WEST)).booleanValue()) {
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)WEST_AABB);
        }
        return voxelshape.method_1110() ? class_259.method_1077() : voxelshape;
    }

    protected class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return (class_265)this.shapesCache.get((Object)state);
    }

    protected boolean method_9579(class_2680 state, class_1922 level, class_2338 pos) {
        return true;
    }

    protected boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        return this.hasFaces(this.getUpdatedState(state, (class_1922)level, pos));
    }

    private boolean canAttachTo(class_1922 blockReader, class_2338 pos, class_2350 direction) {
        class_2680 blockstate = blockReader.method_8320(pos);
        return blockstate.method_26206(blockReader, pos, direction);
    }

    private boolean hasFaces(class_2680 state) {
        return this.countFaces(state) > 0;
    }

    private int countFaces(class_2680 state) {
        int i = 0;
        for (class_2746 booleanproperty : PROPERTY_BY_DIRECTION.values()) {
            if (!((Boolean)state.method_11654((class_2769)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private boolean canSupportAtFace(class_1922 level, class_2338 pos, class_2350 direction) {
        if (direction == class_2350.field_11033) {
            return false;
        }
        class_2338 blockpos = pos.method_10093(direction);
        if (BaseVerdigrisCogBlock.isAcceptableNeighbour(level, blockpos, direction)) {
            return true;
        }
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            return false;
        }
        class_2746 booleanproperty = PROPERTY_BY_DIRECTION.get(direction);
        class_2680 blockstate = level.method_8320(pos.method_10084());
        return blockstate.method_27852((class_2248)this) && (Boolean)blockstate.method_11654((class_2769)booleanproperty) != false;
    }

    public static boolean isAcceptableNeighbour(class_1922 blockReader, class_2338 neighborPos, class_2350 attachedFace) {
        return class_5778.method_33358((class_1922)blockReader, (class_2350)attachedFace, (class_2338)neighborPos, (class_2680)blockReader.method_8320(neighborPos));
    }

    private class_2680 getUpdatedState(class_2680 state, class_1922 level, class_2338 pos) {
        class_2338 blockpos = pos.method_10084();
        if (((Boolean)state.method_11654((class_2769)UP)).booleanValue()) {
            state = (class_2680)state.method_11657((class_2769)UP, (Comparable)Boolean.valueOf(BaseVerdigrisCogBlock.isAcceptableNeighbour(level, blockpos, class_2350.field_11033)));
        }
        class_2680 blockstate = null;
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2746 booleanproperty = BaseVerdigrisCogBlock.getPropertyForFace(direction);
            if (!((Boolean)state.method_11654((class_2769)booleanproperty)).booleanValue()) continue;
            boolean flag = this.canSupportAtFace(level, pos, direction);
            if (!flag) {
                if (blockstate == null) {
                    blockstate = level.method_8320(blockpos);
                }
                flag = blockstate.method_27852((class_2248)this) && (Boolean)blockstate.method_11654((class_2769)booleanproperty) != false;
            }
            state = (class_2680)state.method_11657((class_2769)booleanproperty, (Comparable)Boolean.valueOf(flag));
        }
        return state;
    }

    protected class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 level, class_2338 currentPos, class_2338 facingPos) {
        if (facing == class_2350.field_11033) {
            return super.method_9559(state, facing, facingState, level, currentPos, facingPos);
        }
        class_2680 blockstate = this.getUpdatedState(state, (class_1922)level, currentPos);
        return !this.hasFaces(blockstate) ? class_2246.field_10124.method_9564() : blockstate;
    }

    protected void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 neighborBlock, class_2338 neighborPos, boolean movedByPiston) {
        super.method_9612(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (level.method_8608()) {
            return;
        }
        class_2680 blockstate = this.getUpdatedState(state, (class_1922)level, pos);
        if (!this.hasFaces(blockstate)) {
            class_2248.method_9497((class_2680)blockstate, (class_1937)level, (class_2338)pos);
            level.method_8650(pos, movedByPiston);
        }
    }

    protected int getInputSignal(class_1937 level, class_2338 pos, class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 blockPos = pos.method_10093(direction);
        int i = level.method_49808(blockPos, direction);
        if (i >= 15) {
            return i;
        }
        class_2680 blockState = level.method_8320(blockPos);
        return Math.max(i, blockState.method_27852(class_2246.field_10091) ? (Integer)blockState.method_11654((class_2769)class_2457.field_11432) : 0);
    }

    protected boolean sideInputDiodesOnly() {
        return false;
    }

    protected int getAlternateSignal(class_8235 level, class_2338 pos, class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        class_2350 direction2 = direction.method_10170();
        class_2350 direction3 = direction.method_10160();
        boolean bl = this.sideInputDiodesOnly();
        return Math.max(level.method_49806(pos.method_10093(direction2), direction2, bl), level.method_49806(pos.method_10093(direction3), direction3, bl));
    }

    protected boolean method_9506(class_2680 state) {
        return true;
    }

    protected boolean shouldTurnOn(class_1937 level, class_2338 pos, class_2680 state) {
        return this.getInputSignal(level, pos, state) > 0;
    }

    protected int getDelay(class_2680 state) {
        return (Integer)state.method_11654((class_2769)DELAY) * 2;
    }

    private class_2680 copyRandomFaces(class_2680 sourceState, class_2680 spreadState, class_5819 random) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2746 booleanproperty;
            if (!random.method_43056() || !((Boolean)sourceState.method_11654((class_2769)(booleanproperty = BaseVerdigrisCogBlock.getPropertyForFace(direction)))).booleanValue()) continue;
            spreadState = (class_2680)spreadState.method_11657((class_2769)booleanproperty, (Comparable)Boolean.valueOf(true));
        }
        return spreadState;
    }

    private boolean hasHorizontalConnection(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)NORTH) != false || (Boolean)state.method_11654((class_2769)EAST) != false || (Boolean)state.method_11654((class_2769)SOUTH) != false || (Boolean)state.method_11654((class_2769)WEST) != false;
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2680 blockstate = context.method_8045().method_8320(context.method_8037());
        boolean flag = blockstate.method_27852((class_2248)this);
        class_2680 blockstate1 = flag ? blockstate : this.method_9564();
        for (class_2350 direction : context.method_7718()) {
            boolean flag1;
            if (direction == class_2350.field_11033) continue;
            class_2746 booleanproperty = BaseVerdigrisCogBlock.getPropertyForFace(direction);
            boolean bl = flag1 = flag && (Boolean)blockstate.method_11654((class_2769)booleanproperty) != false;
            if (flag1 || !this.canSupportAtFace((class_1922)context.method_8045(), context.method_8037(), direction)) continue;
            return (class_2680)blockstate1.method_11657((class_2769)booleanproperty, (Comparable)Boolean.valueOf(true));
        }
        return flag ? blockstate1 : null;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{UP, NORTH, EAST, SOUTH, WEST, POWERED, DELAY, FACING});
    }

    @Deprecated
    protected class_2680 method_9598(class_2680 state, class_2470 rotate) {
        switch (rotate) {
            case field_11464: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
            }
            case field_11465: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
            }
            case field_11463: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)));
            }
        }
        return state;
    }

    @Deprecated
    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        switch (mirror) {
            case field_11300: {
                return (class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
            }
            case field_11301: {
                return (class_2680)((class_2680)state.method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
            }
        }
        return super.method_9569(state, mirror);
    }

    public static class_2746 getPropertyForFace(class_2350 face) {
        return PROPERTY_BY_DIRECTION.get(face);
    }

    static {
        FACING = class_2741.field_12525;
        POWERED = class_2741.field_12484;
        DELAY = class_2758.method_11867((String)"delay", (int)0, (int)2);
        UP = class_2429.field_11327;
        NORTH = class_2429.field_11332;
        EAST = class_2429.field_11335;
        SOUTH = class_2429.field_11331;
        WEST = class_2429.field_11328;
        PROPERTY_BY_DIRECTION = (Map)class_2429.field_11329.entrySet().stream().filter(p_57886_ -> p_57886_.getKey() != class_2350.field_11033).collect(class_156.method_664());
        UP_AABB = class_2248.method_9541((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        WEST_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
        EAST_AABB = class_2248.method_9541((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        NORTH_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
        SOUTH_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    }

    public static enum VerdigrisStage implements class_3542
    {
        PRISTINE("pristine", 10),
        TARNISHED("tarnished", 30),
        RAMSHACKLED("ramshackled", 60),
        BROKEN("broken", 0, false);

        public static final Codec<VerdigrisStage> CODEC;
        private String stage;
        private int degradationAmount;
        private boolean shouldPower;
        private static final VerdigrisStage[] vals;

        private VerdigrisStage(String stage, int degradationAmount) {
            this(stage, degradationAmount, true);
        }

        private VerdigrisStage(String stage, int degradationAmount, boolean shouldPower) {
            this.stage = stage;
            this.degradationAmount = degradationAmount;
            this.shouldPower = shouldPower;
        }

        public String method_15434() {
            return this.stage;
        }

        public VerdigrisStage next() {
            return vals[(this.ordinal() + 1) % vals.length];
        }

        public VerdigrisStage last() {
            return vals[vals.length - 1];
        }

        static {
            CODEC = class_3542.method_28140(VerdigrisStage::values);
            vals = VerdigrisStage.values();
        }
    }
}

