/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block.entity;

import com.google.common.collect.Lists;
import com.jamiedev.bygone.common.block.CopperbugNestBlock;
import com.jamiedev.bygone.common.entity.CopperbugEntity;
import com.jamiedev.bygone.core.init.JamiesModTag;
import com.jamiedev.bygone.core.registry.BGBlockEntities;
import com.jamiedev.bygone.core.registry.BGDataComponentTypes;
import com.jamiedev.bygone.core.registry.BGEntityTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2358;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3922;
import net.minecraft.class_5712;
import net.minecraft.class_5996;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9279;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class CopperbugNestBlockEntity
extends class_2586 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String FLOWER_POS_KEY = "flower_pos";
    private static final String COPPERBUGS_KEY = "copperbugs";
    static final List<String> IRRELEVANT_COPPERBUG_NBT_KEYS = Arrays.asList("Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "SleepingX", "SleepingY", "SleepingZ", "CannotEnterNestTicks", "TicksSincePollination", "CropsGrownSincePollination", "Nest_pos", "Passengers", "leash", "UUID");
    public static final int MAX_COPPERBUG_COUNT = 3;
    private static final int ANGERED_CANNOT_ENTER_NEST_TICKS = 400;
    private static final int MIN_OCCUPATION_TICKS_WITH_NECTAR = 2400;
    public static final int MIN_OCCUPATION_TICKS_WITHOUT_NECTAR = 600;
    private final List<Copperbug> copperbugs = Lists.newArrayList();
    @Nullable
    private class_2338 flowerPos;

    public CopperbugNestBlockEntity(class_2338 pos, class_2680 state) {
        super(BGBlockEntities.COPPERBUGNEST.get(), pos, state);
    }

    public void method_5431() {
        if (this.isNearFire()) {
            this.angerCopperbugs(null, this.field_11863.method_8320(this.method_11016()), CopperbugState.EMERGENCY);
        }
        super.method_5431();
    }

    public boolean isNearFire() {
        class_2338 blockPos;
        if (this.field_11863 == null) {
            return false;
        }
        Iterator var1 = class_2338.method_10097((class_2338)this.field_11867.method_10069(-1, -1, -1), (class_2338)this.field_11867.method_10069(1, 1, 1)).iterator();
        do {
            if (var1.hasNext()) continue;
            return false;
        } while (!(this.field_11863.method_8320(blockPos = (class_2338)var1.next()).method_26204() instanceof class_2358));
        return true;
    }

    public boolean hasNoCopperbugs() {
        return this.copperbugs.isEmpty();
    }

    public boolean isFullOfCopperbugs() {
        return this.copperbugs.size() == 3;
    }

    public void angerCopperbugs(@Nullable class_1657 player, class_2680 state, CopperbugState beeState) {
        List<class_1297> list = this.tryReleaseCopperbug(state, beeState);
        if (player != null) {
            for (class_1297 entity : list) {
                if (!(entity instanceof CopperbugEntity)) continue;
                CopperbugEntity beeEntity = (CopperbugEntity)entity;
                if (!(player.method_19538().method_1025(entity.method_19538()) <= 16.0)) continue;
                if (!this.isSmoked()) {
                    beeEntity.method_5980((class_1309)player);
                    continue;
                }
                beeEntity.setCannotEnterNestTicks(400);
            }
        }
    }

    private List<class_1297> tryReleaseCopperbug(class_2680 state, CopperbugState beeState) {
        ArrayList list = Lists.newArrayList();
        this.copperbugs.removeIf(bee -> CopperbugNestBlockEntity.releaseCopperbug(this.field_11863, this.field_11867, state, bee.createData(), list, beeState, this.flowerPos));
        if (!list.isEmpty()) {
            super.method_5431();
        }
        return list;
    }

    @class_5996
    public int getCopperbugCount() {
        return this.copperbugs.size();
    }

    public static int getOxidizationLevel(class_2680 state) {
        return (Integer)state.method_11654((class_2769)CopperbugNestBlock.OXIDIZATION_LEVEL);
    }

    @class_5996
    public boolean isSmoked() {
        return class_3922.method_23895((class_1937)this.field_11863, (class_2338)this.method_11016());
    }

    public void tryEnterNest(class_1297 entity) {
        if (this.copperbugs.size() < 15) {
            entity.method_5848();
            entity.method_5772();
            this.addCopperbug(CopperbugData.of(entity));
            if (this.field_11863 != null) {
                CopperbugEntity beeEntity;
                if (entity instanceof CopperbugEntity && (beeEntity = (CopperbugEntity)entity).hasCopperBlock() && (!this.hasCopperBlockPos() || this.field_11863.field_9229.method_43056())) {
                    this.flowerPos = beeEntity.getCopperBlockPos();
                }
                class_2338 blockPos = this.method_11016();
                this.field_11863.method_43128(null, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), class_3417.field_46931, class_3419.field_15245, 1.0f, 1.0f);
                this.field_11863.method_43276((class_6880)class_5712.field_28733, blockPos, class_5712.class_7397.method_43286((class_1297)entity, (class_2680)this.method_11010()));
            }
            entity.method_31472();
            super.method_5431();
        }
    }

    public void addCopperbug(CopperbugData bee) {
        this.copperbugs.add(new Copperbug(bee));
    }

    private static boolean releaseCopperbug(class_1937 world, class_2338 pos, class_2680 state, CopperbugData bee, @Nullable List<class_1297> entities, CopperbugState beeState, @Nullable class_2338 flowerPos) {
        boolean bl;
        if ((world.method_23886() || world.method_8419()) && beeState != CopperbugState.EMERGENCY) {
            return false;
        }
        class_2350 direction = (class_2350)state.method_11654((class_2769)CopperbugNestBlock.FACING);
        class_2338 blockPos = pos.method_10093(direction);
        boolean bl2 = bl = !world.method_8320(blockPos).method_26220((class_1922)world, blockPos).method_1110();
        if (bl && beeState != CopperbugState.EMERGENCY) {
            return false;
        }
        class_1297 entity = bee.loadEntity(world, pos);
        if (entity != null) {
            if (entity instanceof CopperbugEntity) {
                CopperbugEntity beeEntity = (CopperbugEntity)entity;
                if (flowerPos != null && !beeEntity.hasCopperBlock() && world.field_9229.method_43057() < 0.9f) {
                    beeEntity.setCopperBlockPos(flowerPos);
                }
                if (beeState == CopperbugState.HONEY_DELIVERED) {
                    int i;
                    beeEntity.onOxidizationDelivered();
                    if (state.method_27851(JamiesModTag.COPPERBUGNESTS, statex -> statex.method_28498((class_2769)CopperbugNestBlock.OXIDIZATION_LEVEL)) && (i = CopperbugNestBlockEntity.getOxidizationLevel(state)) < 5) {
                        int j;
                        int n = j = world.field_9229.method_43048(100) == 0 ? 2 : 1;
                        if (i + j > 5) {
                            --j;
                        }
                        world.method_8501(pos, (class_2680)state.method_11657((class_2769)CopperbugNestBlock.OXIDIZATION_LEVEL, (Comparable)Integer.valueOf(i + j)));
                    }
                }
                if (entities != null) {
                    entities.add((class_1297)beeEntity);
                }
                float f = entity.method_17681();
                double d = bl ? 0.0 : 0.55 + (double)(f / 2.0f);
                double e = (double)pos.method_10263() + 0.5 + d * (double)direction.method_10148();
                double g = (double)pos.method_10264() + 0.5 - (double)(entity.method_17682() / 2.0f);
                double h = (double)pos.method_10260() + 0.5 + d * (double)direction.method_10165();
                entity.method_5808(e, g, h, entity.method_36454(), entity.method_36455());
            }
            world.method_8396(null, pos, class_3417.field_29541, class_3419.field_15245, 1.0f, 1.0f);
            world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)entity, (class_2680)world.method_8320(pos)));
            return world.method_8649(entity);
        }
        return false;
    }

    private boolean hasCopperBlockPos() {
        return this.flowerPos != null;
    }

    private static void tickCopperbugs(class_1937 world, class_2338 pos, class_2680 state, List<Copperbug> copperbugs, @Nullable class_2338 flowerPos) {
        boolean bl = false;
        Iterator<Copperbug> iterator = copperbugs.iterator();
        while (iterator.hasNext()) {
            CopperbugState beeState;
            Copperbug bee = iterator.next();
            if (!bee.canExitNest()) continue;
            CopperbugState copperbugState = beeState = bee.hasNectar() ? CopperbugState.HONEY_DELIVERED : CopperbugState.COPPERBUG_RELEASED;
            if (!CopperbugNestBlockEntity.releaseCopperbug(world, pos, state, bee.createData(), null, beeState, flowerPos)) continue;
            bl = true;
            iterator.remove();
        }
        if (bl) {
            CopperbugNestBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, CopperbugNestBlockEntity blockEntity) {
        CopperbugNestBlockEntity.tickCopperbugs(world, pos, state, blockEntity.copperbugs, blockEntity.flowerPos);
        if (!blockEntity.copperbugs.isEmpty() && world.method_8409().method_43058() < 0.005) {
            double d = (double)pos.method_10263() + 0.5;
            double e = pos.method_10264();
            double f = (double)pos.method_10260() + 0.5;
            world.method_43128(null, d, e, f, class_3417.field_46938, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.copperbugs.clear();
        if (nbt.method_10545(COPPERBUGS_KEY)) {
            CopperbugData.LIST_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580(COPPERBUGS_KEY)).resultOrPartial(string -> LOGGER.error("Failed to parse copperbugs: '{}'", string)).ifPresent(list -> list.forEach(this::addCopperbug));
        }
        this.flowerPos = class_2512.method_10691((class_2487)nbt, (String)FLOWER_POS_KEY).orElse(null);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10566(COPPERBUGS_KEY, (class_2520)CopperbugData.LIST_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.createCopperbugsData()).getOrThrow());
        if (this.hasCopperBlockPos()) {
            nbt.method_10566(FLOWER_POS_KEY, class_2512.method_10692((class_2338)this.flowerPos));
        }
    }

    protected void method_57568(class_2586.class_9473 components) {
        super.method_57568(components);
        this.copperbugs.clear();
        List list = (List)components.method_58695(BGDataComponentTypes.COPPERBUGS, List.of());
        list.forEach(this::addCopperbug);
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        componentMapBuilder.method_57840(BGDataComponentTypes.COPPERBUGS, this.createCopperbugsData());
    }

    public void method_57569(class_2487 nbt) {
        super.method_57569(nbt);
        nbt.method_10551(COPPERBUGS_KEY);
    }

    private List<CopperbugData> createCopperbugsData() {
        return this.copperbugs.stream().map(Copperbug::createData).toList();
    }

    public static enum CopperbugState {
        HONEY_DELIVERED,
        COPPERBUG_RELEASED,
        EMERGENCY;

    }

    public record CopperbugData(class_9279 entityData, int ticksInNest, int minTicksInNest) {
        static class_9279 nbt;
        static int minTicksInNests;
        public static final Codec<CopperbugData> CODEC;
        public static final Codec<List<CopperbugData>> LIST_CODEC;
        public static final class_9139<ByteBuf, CopperbugData> PACKET_CODEC;

        public CopperbugData(class_9279 entityData, int ticksInNest, int minTicksInNest) {
            nbt = entityData;
            this.entityData = entityData;
            this.ticksInNest = ticksInNest;
            minTicksInNests = minTicksInNest;
            this.minTicksInNest = minTicksInNest;
        }

        public static CopperbugData of(class_1297 entity) {
            class_2487 nbtCompound = new class_2487();
            entity.method_5662(nbtCompound);
            List<String> var10000 = IRRELEVANT_COPPERBUG_NBT_KEYS;
            Objects.requireNonNull(nbtCompound);
            var10000.forEach(arg_0 -> ((class_2487)nbtCompound).method_10551(arg_0));
            boolean bl = nbtCompound.method_10577("HasNectar");
            return new CopperbugData(class_9279.method_57456((class_2487)nbtCompound), 0, bl ? 2400 : 600);
        }

        public static CopperbugData create(int ticksInNest) {
            class_2487 nbtCompound = new class_2487();
            nbtCompound.method_10582("id", class_7923.field_41177.method_10221(BGEntityTypes.COPPERBUG.get()).toString());
            return new CopperbugData(class_9279.method_57456((class_2487)nbtCompound), ticksInNest, 600);
        }

        @Nullable
        public class_1297 loadEntity(class_1937 world, class_2338 pos) {
            class_2487 nbtCompound = this.entityData.method_57461();
            Objects.requireNonNull(nbtCompound);
            List<String> var10000 = IRRELEVANT_COPPERBUG_NBT_KEYS;
            class_1297 entity = class_1299.method_17842((class_2487)nbtCompound, (class_1937)world, entityx -> entityx);
            var10000.forEach(arg_0 -> ((class_2487)nbtCompound).method_10551(arg_0));
            if (entity != null && entity.method_5864().method_20210(JamiesModTag.COPPERBUGNEST_INHABITORS)) {
                entity.method_5875(true);
                if (entity instanceof CopperbugEntity) {
                    CopperbugEntity beeEntity = (CopperbugEntity)entity;
                    beeEntity.setNestPos(pos);
                    CopperbugData.tickEntity(this.ticksInNest, beeEntity);
                }
                return entity;
            }
            return null;
        }

        private static void tickEntity(int ticksInNest, CopperbugEntity beeEntity) {
            int i = beeEntity.method_5618();
            if (i < 0) {
                beeEntity.method_5614(Math.min(0, i + ticksInNest));
            } else if (i > 0) {
                beeEntity.method_5614(Math.max(0, i - ticksInNest));
            }
            beeEntity.method_6476(Math.max(0, beeEntity.method_29270() - ticksInNest));
        }

        static {
            CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_9279.field_49303.optionalFieldOf("entity_data", (Object)class_9279.field_49302).forGetter(CopperbugData::entityData), (App)Codec.INT.fieldOf("ticks_in_Nest").forGetter(CopperbugData::ticksInNest), (App)Codec.INT.fieldOf("min_ticks_in_Nest").forGetter(CopperbugData::minTicksInNest)).apply((Applicative)instance, CopperbugData::new));
            LIST_CODEC = CODEC.listOf();
            PACKET_CODEC = class_9139.method_56436((class_9139)class_9279.field_49305, CopperbugData::entityData, (class_9139)class_9135.field_48550, CopperbugData::ticksInNest, (class_9139)class_9135.field_48550, CopperbugData::minTicksInNest, CopperbugData::new);
        }
    }

    static class Copperbug {
        private final CopperbugData data;
        private int ticksInNest;

        Copperbug(CopperbugData data) {
            this.data = data;
            this.ticksInNest = data.ticksInNest();
        }

        public boolean canExitNest() {
            return this.ticksInNest++ > this.data.minTicksInNest;
        }

        public CopperbugData createData() {
            return new CopperbugData(this.data.entityData, this.ticksInNest, this.data.minTicksInNest);
        }

        public boolean hasNectar() {
            return this.data.entityData.method_57463().method_10577("HasNectar");
        }
    }
}

