/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.item;

import com.jamiedev.bygone.core.registry.BGParticleTypes;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_3218;
import net.minecraft.class_3486;

public class BaitwormWaterEffect {
    private static final Map<class_3218, Map<class_2338, EffectData>> ACTIVE_EFFECTS = new HashMap<class_3218, Map<class_2338, EffectData>>();

    public static void addEffect(class_3218 level, class_2338 pos, int radius, int duration) {
        ACTIVE_EFFECTS.computeIfAbsent(level, k -> new HashMap()).put(pos, new EffectData(radius, duration, level.method_8510()));
    }

    public static boolean isInBaitwormWater(class_3218 level, class_2338 pos) {
        Map<class_2338, EffectData> levelEffects = ACTIVE_EFFECTS.get(level);
        if (levelEffects == null) {
            return false;
        }
        long currentTime = level.method_8510();
        for (Map.Entry<class_2338, EffectData> entry : levelEffects.entrySet()) {
            class_2338 centerPos = entry.getKey();
            EffectData data = entry.getValue();
            if (currentTime - data.startTime > (long)data.duration || !(pos.method_10262((class_2382)centerPos) <= (double)(data.radius * data.radius)) || !level.method_8316(pos).method_15767(class_3486.field_15517)) continue;
            return true;
        }
        return false;
    }

    public static void tick(class_3218 level) {
        Map<class_2338, EffectData> levelEffects = ACTIVE_EFFECTS.get(level);
        if (levelEffects == null) {
            return;
        }
        long currentTime = level.method_8510();
        Iterator<Map.Entry<class_2338, EffectData>> iterator = levelEffects.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<class_2338, EffectData> entry = iterator.next();
            class_2338 centerPos = entry.getKey();
            EffectData data = entry.getValue();
            if (currentTime - data.startTime > (long)data.duration) {
                iterator.remove();
                continue;
            }
            if (currentTime % 5L != 0L) continue;
            BaitwormWaterEffect.spawnParticles(level, centerPos, data.radius);
        }
        if (levelEffects.isEmpty()) {
            ACTIVE_EFFECTS.remove(level);
        }
    }

    private static void spawnParticles(class_3218 level, class_2338 centerPos, int radius) {
        for (int i = 0; i < 3; ++i) {
            int z;
            int x = level.field_9229.method_43048(radius * 2 + 1) - radius;
            class_2338 surfacePos = centerPos.method_10069(x, 0, z = level.field_9229.method_43048(radius * 2 + 1) - radius);
            if (!level.method_8316(surfacePos).method_15767(class_3486.field_15517) || level.method_8316(surfacePos.method_10084()).method_15767(class_3486.field_15517)) continue;
            level.method_14199((class_2394)((class_2400)BGParticleTypes.WORM), (double)surfacePos.method_10263() + 0.5, (double)surfacePos.method_10264() + 0.5, (double)surfacePos.method_10260() + 0.5, 2, level.field_9229.method_43058() * 0.3 - 0.15, 0.05, level.field_9229.method_43058() * 0.3 - 0.15, 0.05);
        }
    }

    private static class EffectData {
        final int radius;
        final int duration;
        final long startTime;

        EffectData(int radius, int duration, long startTime) {
            this.radius = radius;
            this.duration = duration;
            this.startTime = startTime;
        }
    }
}

