/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.item;

import com.jamiedev.bygone.common.util.ShockwaveHandler;
import com.jamiedev.bygone.core.registry.BGDataComponentTypes;
import com.jamiedev.bygone.core.registry.BGDataComponents;
import com.jamiedev.bygone.core.registry.BGSoundEvents;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9331;

public class EchoGongItem
extends class_1792 {
    private static final int MAX_CHARGE = 100;
    private static final int CHARGE_PER_TICK = 1;
    private static final int COOLDOWN_TICKS = 100;
    private static final float SHOCKWAVE_RADIUS = 8.0f;
    private static final int WEAKNESS_DURATION = 200;
    private static final class_2400 SHOCKWAVE_PARTICLE = class_2398.field_29644;

    public EchoGongItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
        if (!level.field_9236 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            BGDataComponentTypes.EchoGongData data = (BGDataComponentTypes.EchoGongData)stack.method_57825((class_9331)BGDataComponents.ECHO_GONG_DATA.comp_349(), (Object)BGDataComponentTypes.EchoGongData.EMPTY);
            int charge = data.charge();
            if (charge < 100 && !player.method_7357().method_7904((class_1792)this)) {
                charge = Math.min(charge + 1, 100);
                stack.method_57379((class_9331)BGDataComponents.ECHO_GONG_DATA.comp_349(), (Object)new BGDataComponentTypes.EchoGongData(charge));
                if (charge % 20 == 0) {
                    level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), BGSoundEvents.ECHO_GONG_CHARGE.get(), class_3419.field_15248, 0.3f, 1.0f + (float)charge / 100.0f * 0.5f);
                    if (level instanceof class_3218) {
                        class_3218 serverLevel = (class_3218)level;
                        double particleY = player.method_23318() + 0.5;
                        for (int i = 0; i < 3; ++i) {
                            double angle = level.field_9229.method_43058() * Math.PI * 2.0;
                            double distance = level.field_9229.method_43058() * 0.5;
                            double particleX = player.method_23317() + Math.cos(angle) * distance;
                            double particleZ = player.method_23321() + Math.sin(angle) * distance;
                            serverLevel.method_14199((class_2394)class_2398.field_38908, particleX, particleY, particleZ, 1, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
        }
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        BGDataComponentTypes.EchoGongData data = (BGDataComponentTypes.EchoGongData)itemStack.method_57825((class_9331)BGDataComponents.ECHO_GONG_DATA.comp_349(), (Object)BGDataComponentTypes.EchoGongData.EMPTY);
        int charge = data.charge();
        if (charge >= 100) {
            if (!level.field_9236) {
                player.method_6019(hand);
                return class_1271.method_22428((Object)itemStack);
            }
            return class_1271.method_22428((Object)itemStack);
        }
        if (!level.field_9236) {
            player.method_7353((class_2561)class_2561.method_43469((String)"item.bygone.echo_gong.not_charged", (Object[])new Object[]{charge, 100}).method_27692(class_124.field_1080), true);
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 level, class_1309 user) {
        if (!level.field_9236 && user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            this.releaseShockwave(level, player, stack);
            stack.method_57379((class_9331)BGDataComponents.ECHO_GONG_DATA.comp_349(), (Object)new BGDataComponentTypes.EchoGongData(0));
            player.method_7357().method_7906((class_1792)this, 100);
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
        }
        return stack;
    }

    private void releaseShockwave(class_1937 level, class_1657 player, class_1799 stack) {
        level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), BGSoundEvents.ECHO_GONG_USE.get(), class_3419.field_15247, 2.0f, 1.0f);
        level.method_32888((class_6880)class_5712.field_39415, player.method_19538(), class_5712.class_7397.method_43285((class_1297)player));
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            ShockwaveHandler.createShockwave(serverLevel, player, SHOCKWAVE_PARTICLE, 3.0f, 20, 24);
            ShockwaveHandler.createShockwave(serverLevel, player, SHOCKWAVE_PARTICLE, 5.0f, 30, 32);
            ShockwaveHandler.createShockwave(serverLevel, player, SHOCKWAVE_PARTICLE, 8.0f, 40, 40);
            this.applyAreaEffects(serverLevel, player);
            this.breakFragileBlocks(serverLevel, player);
            serverLevel.method_14199((class_2394)SHOCKWAVE_PARTICLE, player.method_23317(), player.method_23318() + 1.0, player.method_23321(), 8, 0.3, 0.3, 0.3, 0.2);
        }
    }

    private void applyAreaEffects(class_3218 level, class_1657 player) {
        class_238 area = new class_238(player.method_19538().method_1031(-8.0, -2.0, -8.0), player.method_19538().method_1031(8.0, 3.0, 8.0));
        List entities = level.method_18467(class_1309.class, area);
        for (class_1309 entity : entities) {
            if (entity == player || entity.method_5722((class_1297)player)) continue;
            entity.method_6092(new class_1293(class_1294.field_5911, 200, 1));
            entity.method_6092(new class_1293(class_1294.field_5909, 40, 0));
            class_243 direction = entity.method_19538().method_1020(player.method_19538());
            double distance = direction.method_1033();
            if (!(distance > 0.0)) continue;
            class_243 knockbackVec = direction.method_1029();
            double knockbackStrength = Math.max(0.5, (8.0 - distance) / 8.0 * 1.5);
            double horizontalKnockback = knockbackStrength * 0.8;
            double verticalKnockback = Math.min(0.8, knockbackStrength * 0.6);
            entity.method_5762(knockbackVec.field_1352 * horizontalKnockback, verticalKnockback, knockbackVec.field_1350 * horizontalKnockback);
        }
    }

    private void breakFragileBlocks(class_3218 level, class_1657 player) {
        class_2338 playerPos = player.method_24515();
        int radius = 8;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2338 pos;
                    class_2680 state;
                    if (x * x + z * z > radius * radius || !this.isFragileBlock(state = level.method_8320(pos = playerPos.method_10069(x, y, z)))) continue;
                    level.method_8651(pos, true, (class_1297)player);
                }
            }
        }
    }

    private boolean isFragileBlock(class_2680 state) {
        return state.method_45474();
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
        BGDataComponentTypes.EchoGongData data = (BGDataComponentTypes.EchoGongData)stack.method_57825((class_9331)BGDataComponents.ECHO_GONG_DATA.comp_349(), (Object)BGDataComponentTypes.EchoGongData.EMPTY);
        int charge = data.charge();
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.bygone.echo_gong.desc1").method_27692(class_124.field_1080));
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.bygone.echo_gong.desc2").method_27692(class_124.field_1080));
        if (charge >= 100) {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.bygone.echo_gong.ready").method_27692(class_124.field_1060));
        } else {
            int percent = charge * 100 / 100;
            tooltipComponents.add((class_2561)class_2561.method_43469((String)"item.bygone.echo_gong.charge", (Object[])new Object[]{percent}).method_27692(class_124.field_1054));
        }
    }

    public boolean method_7886(class_1799 stack) {
        BGDataComponentTypes.EchoGongData data = (BGDataComponentTypes.EchoGongData)stack.method_57825((class_9331)BGDataComponents.ECHO_GONG_DATA.comp_349(), (Object)BGDataComponentTypes.EchoGongData.EMPTY);
        return data.charge() >= 100;
    }

    public int method_7881(class_1799 stack, class_1309 entity) {
        return 20;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_39058;
    }
}

