/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;

public class ShockwaveHandler {
    private static final ConcurrentHashMap<UUID, List<ActiveShockwave>> ACTIVE_SHOCKWAVES = new ConcurrentHashMap();

    public static void createShockwave(class_3218 level, class_1657 player, class_2400 particleType, float maxRadius, int durationTicks, int particleCount) {
        UUID playerId = player.method_5667();
        ActiveShockwave shockwave = new ActiveShockwave(level, player.method_19538(), particleType, maxRadius, durationTicks, particleCount);
        ACTIVE_SHOCKWAVES.computeIfAbsent(playerId, k -> new ArrayList()).add(shockwave);
    }

    public static void tickAll() {
        ACTIVE_SHOCKWAVES.entrySet().removeIf(entry -> {
            List shockwaves = (List)entry.getValue();
            shockwaves.removeIf(shockwave -> !shockwave.tick());
            return shockwaves.isEmpty();
        });
    }

    public static void clearPlayer(UUID playerId) {
        ACTIVE_SHOCKWAVES.remove(playerId);
    }

    public static class ActiveShockwave {
        private final class_3218 level;
        private final class_243 center;
        private final class_2400 particleType;
        private final float maxRadius;
        private final int duration;
        private final int particleCount;
        private float currentRadius;
        private int ticksAlive;

        public ActiveShockwave(class_3218 level, class_243 center, class_2400 particleType, float maxRadius, int duration, int particleCount) {
            this.level = level;
            this.center = center;
            this.particleType = particleType;
            this.maxRadius = maxRadius;
            this.duration = duration;
            this.particleCount = particleCount;
            this.currentRadius = 0.5f;
            this.ticksAlive = 0;
        }

        public boolean tick() {
            ++this.ticksAlive;
            float progress = (float)this.ticksAlive / (float)this.duration;
            if (progress > 1.0f) {
                return false;
            }
            float easedProgress = 1.0f - (1.0f - progress) * (1.0f - progress);
            this.currentRadius = 0.5f + easedProgress * (this.maxRadius - 0.5f);
            for (int i = 0; i < this.particleCount; ++i) {
                float angle = (float)((double)(i * 2) * Math.PI / (double)this.particleCount);
                double x = this.center.field_1352 + (double)(class_3532.method_15362((float)angle) * this.currentRadius);
                double z = this.center.field_1350 + (double)(class_3532.method_15374((float)angle) * this.currentRadius);
                double y = this.center.field_1351 + 0.5;
                this.level.method_14199((class_2394)this.particleType, x += (this.level.field_9229.method_43058() - 0.5) * 0.1, y += (this.level.field_9229.method_43058() - 0.5) * 0.2, z += (this.level.field_9229.method_43058() - 0.5) * 0.1, 1, 0.0, 0.0, 0.0, 0.0);
            }
            return true;
        }
    }
}

