/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.worldgen.structure;

import com.jamiedev.bygone.common.worldgen.structure.AncientTreeFeatureConfig;
import com.mojang.serialization.Codec;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2944;
import net.minecraft.class_3031;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4648;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.jetbrains.annotations.NotNull;

public class AncientTreeFeature
extends class_3031<AncientTreeFeatureConfig> {
    public AncientTreeFeature(Codec<AncientTreeFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<AncientTreeFeatureConfig> context) {
        class_2338 blockPos;
        class_5281 structureWorldAccess = context.method_33652();
        if (AncientTreeFeature.isNotSuitable((class_1936)structureWorldAccess, blockPos = context.method_33655())) {
            return false;
        }
        class_5819 random = context.method_33654();
        AncientTreeFeatureConfig twistingVinesFeatureConfig = (AncientTreeFeatureConfig)context.method_33656();
        int i = twistingVinesFeatureConfig.spreadWidth();
        int j = twistingVinesFeatureConfig.spreadHeight();
        int k = twistingVinesFeatureConfig.maxHeight();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int l = 0; l < i * i; ++l) {
            mutable.method_10101((class_2382)blockPos).method_10100(class_3532.method_15395((class_5819)random, (int)(-i), (int)i), class_3532.method_15395((class_5819)random, (int)(-j), (int)j), class_3532.method_15395((class_5819)random, (int)(-i), (int)i));
            if (!AncientTreeFeature.canGenerate((class_1936)structureWorldAccess, mutable) || AncientTreeFeature.isNotSuitable((class_1936)structureWorldAccess, (class_2338)mutable)) continue;
            int m = class_3532.method_15395((class_5819)random, (int)1, (int)k);
            if (random.method_43048(6) == 0) {
                m *= 2;
            }
            if (random.method_43048(5) == 0) {
                m = 1;
            }
            AncientTreeFeature.generateVineColumn((class_1936)structureWorldAccess, random, mutable, m, 17, 25);
        }
        return true;
    }

    private static boolean canGenerate(class_1936 world, class_2338.class_2339 pos) {
        do {
            pos.method_10100(0, -1, 0);
            if (!world.method_31606((class_2338)pos)) continue;
            return false;
        } while (world.method_8320((class_2338)pos).method_26215());
        pos.method_10100(0, 1, 0);
        return true;
    }

    public static void generateVineColumn(class_1936 world, @NotNull class_5819 random, class_2338.class_2339 pos, int maxLength, int minAge, int maxAge) {
        for (int i = 1; i <= maxLength; ++i) {
            if (world.method_22347((class_2338)pos)) {
                if (i == maxLength || !world.method_22347(pos.method_10084())) {
                    world.method_8652((class_2338)pos, class_2246.field_10306.method_9564(), 2);
                    break;
                }
                world.method_8652((class_2338)pos, class_2246.field_10306.method_9564(), 2);
            }
            pos.method_10098(class_2350.field_11036);
        }
    }

    private static boolean isNotSuitable(class_1936 world, class_2338 pos) {
        if (!world.method_22347(pos)) {
            return true;
        }
        class_2680 blockState = world.method_8320(pos.method_10074());
        return !blockState.method_27852(class_2246.field_28681);
    }

    protected class_4648<?> getType() {
        return class_4648.field_21302;
    }

    protected boolean isPositionInvalid(class_5819 random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        int j;
        int i;
        if (giantTrunk) {
            i = Math.min(Math.abs(dx), Math.abs(dx - 1));
            j = Math.min(Math.abs(dz), Math.abs(dz - 1));
        } else {
            i = Math.abs(dx);
            j = Math.abs(dz);
        }
        return this.isInvalidForLeaves(random, i, y, j, radius, giantTrunk);
    }

    private static boolean placeFoliageBlock(class_3746 world, class_4647.class_8179 placer, @NotNull class_5819 random, class_4643 config, float chance, class_2338 origin, class_2338.class_2339 pos) {
        if (pos.method_19455((class_2382)origin) >= 7) {
            return false;
        }
        return !(random.method_43057() > chance) && AncientTreeFeature.placeFoliageBlock(world, placer, random, config, (class_2338)pos);
    }

    protected static boolean placeFoliageBlock(class_3746 world, class_4647.class_8179 placer, @NotNull class_5819 random, class_4643 config, class_2338 pos) {
        if (!class_2944.method_27371((class_3746)world, (class_2338)pos)) {
            return false;
        }
        class_2680 blockState = config.field_29280.method_23455(random, pos);
        if (blockState.method_28498((class_2769)class_2741.field_12508)) {
            blockState = (class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(world.method_35237(pos, fluidState -> fluidState.method_33659((class_3611)class_3612.field_15910))));
        }
        placer.method_49240(pos, blockState);
        return true;
    }

    protected void generateSquare(class_3746 world, class_4647.class_8179 placer, @NotNull class_5819 random, class_4643 config, class_2338 centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.isPositionInvalid(random, j, y, k, radius, giantTrunk)) continue;
                mutable.method_25504((class_2382)centerPos, j, y, k);
                AncientTreeFeature.placeFoliageBlock(world, placer, random, config, (class_2338)mutable);
            }
        }
    }

    protected void generate(class_3746 world, class_4647.class_8179 placer, @NotNull class_5819 random, class_4643 config, int trunkHeight, class_4647.class_5208 treeNode, int foliageHeight, int radius, int offset) {
        boolean bl = treeNode.method_27390();
        class_2338 blockPos = treeNode.method_27388().method_10086(offset);
        this.generateSquare(world, placer, random, config, blockPos, radius + treeNode.method_27389(), -1 - foliageHeight, bl);
        this.generateSquare(world, placer, random, config, blockPos, radius - 1, -foliageHeight, bl);
        this.generateSquare(world, placer, random, config, blockPos, radius + treeNode.method_27389() - 1, 0, bl);
    }

    public int getRandomHeight(class_5819 random, int trunkHeight, class_4643 config) {
        return 0;
    }

    protected boolean isInvalidForLeaves(class_5819 random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        if (y == 0) {
            return (dx > 1 || dz > 1) && dx != 0 && dz != 0;
        }
        return dx == radius && dz == radius && radius > 0;
    }
}

