/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.particles.advanced;

import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.tenshilib.client.particles.advanced.AdvancedParticleHandler;
import io.github.flemmli97.tenshilib.mixin.ParticleAccessor;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.world.phys.AABB;

public class AdvancedParticle
extends Particle {
    private final Particle wrapped;
    private final List<AdvancedParticleHandler> handlers;

    public AdvancedParticle(Particle wrapped, List<AdvancedParticleHandler> handlers, ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.wrapped = wrapped;
        ParticleAccessor acc = (ParticleAccessor)wrapped;
        acc.setXo(acc.getX());
        acc.setYo(acc.getY());
        acc.setZo(acc.getZ());
        this.handlers = handlers;
    }

    public void render(VertexConsumer buffer, Camera camera, float partialTicks) {
        this.wrapped.render(buffer, camera, partialTicks);
    }

    public void tick() {
        this.handlers.forEach(d -> d.tick(this.wrapped));
        this.wrapped.tick();
    }

    public ParticleRenderType getRenderType() {
        return this.wrapped.getRenderType();
    }

    public boolean isAlive() {
        return this.wrapped.isAlive();
    }

    public AABB getBoundingBox() {
        if (this.wrapped == null) {
            return super.getBoundingBox();
        }
        return this.wrapped.getBoundingBox();
    }

    public Particle getWrapped() {
        return this.wrapped;
    }
}

