/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import io.github.flemmli97.tenshilib.client.render.TextureRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;

public abstract class CrossedTextureRenderer<T extends Entity>
extends TextureRenderer<T> {
    public CrossedTextureRenderer(EntityRendererProvider.Context ctx, float xSize, float ySize, int rows, int columns) {
        super(ctx, xSize, ySize, rows, columns);
    }

    @Override
    public void doRender(T entity, float partialTicks, PoseStack stack, MultiBufferSource buffer) {
        stack.pushPose();
        stack.mulPose(Axis.XP.rotationDegrees(45.0f));
        for (int j = 0; j < 2; ++j) {
            stack.mulPose(Axis.XP.rotationDegrees(90.0f));
            RenderUtils.renderTexture(stack, buffer.getBuffer(this.getRenderType(entity, this.getTextureLocation((Entity)entity))), this.xSize, this.ySize, this.textureBuilder);
        }
        stack.popPose();
    }

    @Override
    public boolean facePlayer() {
        return false;
    }

    @Override
    public float yawOffset() {
        return -90.0f;
    }
}

