/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity;

import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import io.github.flemmli97.tenshilib.loader.TenshiLibCrossPlat;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class DamageCloudEntity
extends Entity
implements TraceableEntity {
    protected static final EntityDataAccessor<Optional<UUID>> SHOOTER_UUID = SynchedEntityData.defineId(DamageCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.defineId(DamageCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private Entity shooter;
    protected int livingTicks;
    private int attackedEntities = 0;

    public DamageCloudEntity(EntityType<? extends DamageCloudEntity> type, Level level) {
        super(type, level);
    }

    public DamageCloudEntity(EntityType<? extends DamageCloudEntity> type, Level level, double x, double y, double z) {
        this(type, level);
        this.setPos(x, y, z);
    }

    public DamageCloudEntity(EntityType<? extends DamageCloudEntity> type, Level level, LivingEntity shooter) {
        this(type, level, shooter.getX(), shooter.getY(), shooter.getZ());
        this.shooter = shooter;
        this.entityData.set(SHOOTER_UUID, Optional.of(shooter.getUUID()));
        this.setRot(shooter.getYRot(), shooter.getXRot());
    }

    public int maxHitCount() {
        return -1;
    }

    public float radiusIncrease() {
        return 0.0f;
    }

    public double maxRadius() {
        return -1.0;
    }

    public int livingTicks() {
        return this.livingTicks;
    }

    public int livingTickMax() {
        return 200;
    }

    public boolean canHitShooter() {
        return false;
    }

    public boolean canStartDamage() {
        return (this.livingTicks - 1) % 5 == 0;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SHOOTER_UUID, Optional.empty());
        builder.define(RADIUS, (Object)Float.valueOf(0.0f));
    }

    public float getRadius() {
        return ((Float)this.entityData.get(RADIUS)).floatValue();
    }

    public void setRadius(float val) {
        this.entityData.set(RADIUS, (Object)Float.valueOf(val));
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void tick() {
        super.tick();
        ++this.livingTicks;
        if (!this.level().isClientSide) {
            if (this.livingTicks > this.livingTickMax()) {
                this.remove(Entity.RemovalReason.KILLED);
                return;
            }
            float radius = this.getRadius();
            if ((double)radius < this.maxRadius()) {
                this.setRadius(radius + this.radiusIncrease());
            }
            if (this.canStartDamage() && this.isAlive()) {
                List targets = this.level().getEntitiesOfClass(LivingEntity.class, this.damageBoundingBox(), this::canHit);
                for (LivingEntity living : targets) {
                    if ((this.maxHitCount() == -1 || this.attackedEntities < this.maxHitCount()) && this.damageEntity(living)) {
                        ++this.attackedEntities;
                    }
                    if (this.maxHitCount() == -1 || this.attackedEntities < this.maxHitCount()) continue;
                    this.onMaxEntities();
                    break;
                }
            }
        }
    }

    protected boolean canHit(LivingEntity target) {
        if (target.isSpectator() || !target.isAlive() || !target.isPickable()) {
            return false;
        }
        Entity entity = this.getOwner();
        if (entity == null) {
            return true;
        }
        if (TenshiLibCrossPlat.INSTANCE.isSameMultipart((Entity)target, this.getOwner())) {
            return false;
        }
        return !target.equals((Object)this.getOwner()) || !entity.isPassengerOfSameVehicle((Entity)target) || this.canHitShooter() && this.tickCount >= 3;
    }

    protected abstract boolean damageEntity(LivingEntity var1);

    protected void onMaxEntities() {
        this.remove(Entity.RemovalReason.KILLED);
    }

    protected AABB damageBoundingBox() {
        float radius = this.getRadius();
        return this.getBoundingBox().inflate((double)radius, 0.3, (double)radius);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.hasUUID("Shooter")) {
            this.entityData.set(SHOOTER_UUID, Optional.of(compound.getUUID("Shooter")));
        }
        this.shooter = this.getOwner();
        this.livingTicks = compound.getInt("LivingTicks");
        this.attackedEntities = compound.getInt("AttackedEntities");
        this.entityData.set(RADIUS, (Object)Float.valueOf(compound.getFloat("Radius")));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        ((Optional)this.entityData.get(SHOOTER_UUID)).ifPresent(uuid -> compound.putUUID("Shooter", uuid));
        compound.putInt("LivingTicks", this.livingTicks);
        compound.putInt("AttackedEntities", this.attackedEntities);
        compound.putFloat("Radius", this.getRadius());
    }

    @Nullable
    public Entity getOwner() {
        if (this.shooter != null && !this.shooter.isRemoved()) {
            return this.shooter;
        }
        ((Optional)this.entityData.get(SHOOTER_UUID)).ifPresent(uuid -> {
            this.shooter = EntityUtils.findFromUUID(Entity.class, this.level(), uuid);
        });
        return this.shooter;
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(SHOOTER_UUID)).orElse(null);
    }
}

