/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.brain;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.RepeatingBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.SequentialBehaviour;

public class SelectableBehaviourBuilder<E extends LivingEntity> {
    private final List<Pair<ExtendedBehaviour<E>, Integer>> behaviors = new ArrayList<Pair<ExtendedBehaviour<E>, Integer>>();

    public static <E extends LivingEntity> SelectableBehaviourBuilder<E> builder() {
        return new SelectableBehaviourBuilder<E>();
    }

    @SafeVarargs
    public final SelectableBehaviourBuilder<E> add(int weight, ExtendedBehaviour<E> ... behaviours) {
        return this.add(weight, (Consumer)null, behaviours);
    }

    @SafeVarargs
    public final SelectableBehaviourBuilder<E> add(int weight, Predicate<E> condition, ExtendedBehaviour<E> ... behaviours) {
        return this.add(weight, (ExtendedBehaviour<E> behavior) -> behavior.startCondition(condition), behaviours);
    }

    @SafeVarargs
    public final SelectableBehaviourBuilder<E> add(int weight, Consumer<ExtendedBehaviour<E>> setup, ExtendedBehaviour<E> ... behaviours) {
        if (behaviours.length == 0) {
            return this;
        }
        RepeatingBehaviour behaviour = behaviours.length == 1 ? new RepeatingBehaviour(behaviours[0]) : new RepeatingBehaviour((ExtendedBehaviour)new SequentialBehaviour(behaviours));
        if (setup != null) {
            setup.accept((ExtendedBehaviour<E>)behaviour);
        }
        this.behaviors.add(Pair.of((Object)behaviour, (Object)weight));
        return this;
    }

    public ExtendedBehaviour<E> build() {
        return new OneRandomBehaviour((Pair[])this.behaviors.toArray(Pair[]::new));
    }
}

