/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour;

import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.WalkOrRunToWalkTarget;

public class MoveToWalkTargetWithSight<E extends PathfinderMob>
extends WalkOrRunToWalkTarget<E> {
    protected boolean requireSight = true;
    protected boolean stopIfTouching = true;
    protected boolean accountForBB = true;

    public MoveToWalkTargetWithSight<E> ignoreSight() {
        this.requireSight = false;
        return this;
    }

    public MoveToWalkTargetWithSight<E> ignoreBoundingBox() {
        this.accountForBB = false;
        return this;
    }

    public MoveToWalkTargetWithSight<E> ignoreTouch() {
        this.stopIfTouching = false;
        return this;
    }

    protected boolean hasReachedTarget(E entity, WalkTarget target) {
        PositionTracker positionTracker = target.getTarget();
        if (positionTracker instanceof EntityTracker) {
            EntityTracker tracker = (EntityTracker)positionTracker;
            if (this.requireSight && !entity.getSensing().hasLineOfSight(tracker.getEntity())) {
                return false;
            }
            if (this.stopIfTouching && entity.getBoundingBox().inflate(0.5).intersects(tracker.getEntity().getBoundingBox())) {
                return true;
            }
            if (this.accountForBB) {
                double min = (double)target.getCloseEnoughDist() + (double)entity.getBbWidth() * 0.5 + (double)tracker.getEntity().getBbWidth() * 0.5;
                return entity.distanceToSqr(tracker.getEntity()) <= min * min;
            }
        }
        return super.hasReachedTarget(entity, target);
    }
}

