/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.ToIntBiFunction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetWalkTargetAwayFromTarget<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final MemoryTest MEMORIES = MemoryTest.builder((int)3).hasMemory(MemoryModuleType.ATTACK_TARGET).usesMemories(new MemoryModuleType[]{MemoryModuleType.WALK_TARGET, MemoryModuleType.LOOK_TARGET});
    protected BiFunction<E, LivingEntity, Float> speedMod = (entity, target) -> Float.valueOf(1.0f);
    protected BiFunction<E, LivingEntity, Float> minDist = (entity, target) -> Float.valueOf(1.0f);
    protected SquareRadius radius = new SquareRadius(10.0, 7.0);
    protected ToIntBiFunction<E, LivingEntity> closeEnoughWhen = (entity, target) -> 0;

    public SetWalkTargetAwayFromTarget<E> speedMod(float speedModifier) {
        return this.speedMod((entity, target) -> Float.valueOf(speedModifier));
    }

    public SetWalkTargetAwayFromTarget<E> speedMod(BiFunction<E, LivingEntity, Float> speedModifier) {
        this.speedMod = speedModifier;
        return this;
    }

    public SetWalkTargetAwayFromTarget<E> minDist(float minDist) {
        return this.minDist((entity, target) -> Float.valueOf(minDist));
    }

    public SetWalkTargetAwayFromTarget<E> minDist(BiFunction<E, LivingEntity, Float> minDist) {
        this.minDist = minDist;
        return this;
    }

    public SetWalkTargetAwayFromTarget<E> radius(double radius) {
        return this.radius(radius, radius);
    }

    public SetWalkTargetAwayFromTarget<E> radius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected void start(E entity) {
        Brain brain = entity.getBrain();
        LivingEntity target = BrainUtils.getTargetOfEntity(entity);
        if (!entity.getSensing().hasLineOfSight((Entity)target)) {
            BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)target, true));
            BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)target, false), this.speedMod.apply(entity, target).floatValue(), this.closeEnoughWhen.applyAsInt(entity, target)));
        } else {
            double minDist = this.minDist.apply(entity, target).floatValue();
            if (entity.distanceToSqr((Entity)target) < minDist * minDist) {
                for (int i = 0; i < 10; ++i) {
                    Vec3 posAway = DefaultRandomPos.getPosAway(entity, (int)((int)this.radius.xzRadius()), (int)((int)this.radius.yRadius()), (Vec3)target.position());
                    if (posAway == null) continue;
                    BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)target, true));
                    BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(posAway, this.speedMod.apply(entity, target).floatValue(), this.closeEnoughWhen.applyAsInt(entity, target)));
                    break;
                }
            }
        }
    }
}

