/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.item;

import io.github.flemmli97.tenshilib.common.network.C2SAttackPacket;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import io.github.flemmli97.tenshilib.mixinhelper.PlayerAttackAccess;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public interface ExtendedWeapon {
    default public void executeAttack(Player player, ItemStack stack) {
        Entity target;
        double range = this.getRange((LivingEntity)player, stack);
        EntityHitResult hit = HitResultUtils.calculateEntityFromLook((LivingEntity)player, range);
        Entity entity = target = hit != null ? hit.getEntity() : null;
        if (target != null) {
            ((PlayerAttackAccess)player).tenshilib$SetNoSweeping(!this.doSweepingAttack());
            player.attack(target);
            ((PlayerAttackAccess)player).tenshilib$SetNoSweeping(false);
        }
        if (this.shouldSwingWeapon((LivingEntity)player, stack)) {
            player.swing(InteractionHand.MAIN_HAND, true);
        }
    }

    default public boolean onClientStartAttack(LivingEntity entity, ItemStack stack, HitResult hitResult) {
        switch (hitResult.getType()) {
            case ENTITY: 
            case MISS: {
                LoaderNetwork.INSTANCE.sendToServer(C2SAttackPacket.INSTANCE);
                return true;
            }
            case BLOCK: {
                if (!this.attackOnBlock(entity, stack)) break;
                LoaderNetwork.INSTANCE.sendToServer(C2SAttackPacket.INSTANCE);
                return true;
            }
        }
        return false;
    }

    default public boolean attackOnBlock(LivingEntity entity, ItemStack stack) {
        return false;
    }

    default public boolean shouldSwingWeapon(LivingEntity entity, ItemStack stack) {
        return true;
    }

    default public boolean doSweepingAttack() {
        return true;
    }

    default public double getRange(LivingEntity entity, ItemStack stack) {
        AttributeInstance inst = entity.getAttribute(Attributes.ENTITY_INTERACTION_RANGE);
        return inst != null ? inst.getValue() : ((Attribute)Attributes.ENTITY_INTERACTION_RANGE.value()).getDefaultValue();
    }
}

