/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils;

import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemUtils {
    public static boolean isItemBetter(LivingEntity holder, @Nullable Entity target, ItemStack stack, ItemStack currentEquipped) {
        double damageCurrent;
        Item item;
        if (target == null) {
            Mob mob;
            LivingEntity livingEntity = target = holder instanceof Mob && (mob = (Mob)holder).getTarget() != null ? mob.getTarget() : holder;
        }
        if ((item = stack.getItem()) instanceof ArmorItem) {
            ArmorItem itemarmor = (ArmorItem)item;
            if (!(currentEquipped.getItem() instanceof ArmorItem) || EnchantmentHelper.has((ItemStack)currentEquipped, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) {
                return true;
            }
            Item item2 = currentEquipped.getItem();
            if (item2 instanceof ArmorItem) {
                ArmorItem itemarmor1 = (ArmorItem)item2;
                if (itemarmor.getDefense() == itemarmor1.getDefense()) {
                    long enchants = ((ItemEnchantments)currentEquipped.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).keySet().stream().filter(ench -> !ench.is(EnchantmentTags.CURSE)).count();
                    long enchants2 = ((ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).keySet().stream().filter(ench -> !ench.is(EnchantmentTags.CURSE)).count();
                    if (enchants2 == enchants) {
                        return stack.getDamageValue() > currentEquipped.getDamageValue() || stack.getComponentsPatch().isEmpty() && !currentEquipped.getComponentsPatch().isEmpty();
                    }
                    return enchants2 > enchants;
                }
                return itemarmor.getDefense() > itemarmor1.getDefense();
            }
        }
        if (currentEquipped.isEmpty()) {
            return true;
        }
        double damage = ItemUtils.damage(holder, target, stack);
        if (damage == (damageCurrent = ItemUtils.damage(holder, target, currentEquipped))) {
            long enchants = ((ItemEnchantments)currentEquipped.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).keySet().stream().filter(ench -> !ench.is(EnchantmentTags.CURSE)).count();
            long enchants2 = ((ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).keySet().stream().filter(ench -> !ench.is(EnchantmentTags.CURSE)).count();
            if (enchants2 == enchants) {
                return stack.getDamageValue() > currentEquipped.getDamageValue() || stack.getComponentsPatch().isEmpty() && !currentEquipped.getComponentsPatch().isEmpty();
            }
            return enchants2 > enchants;
        }
        return damage > damageCurrent;
    }

    public static double attribute(ItemAttributeModifiers modifiers, Holder<Attribute> attribute, double base, EquipmentSlotGroup ... groups) {
        AttributeInstance instance = new AttributeInstance(attribute, i -> {});
        instance.setBaseValue(base);
        if (modifiers != null) {
            for (EquipmentSlotGroup group : groups) {
                modifiers.forEach(group, (attr, mod) -> {
                    if (attr.is(attribute)) {
                        instance.addTransientModifier(mod);
                    }
                });
            }
        }
        return ((Attribute)attribute.value()).sanitizeValue(instance.getValue());
    }

    public static double attribute(ItemStack stack, Holder<Attribute> attribute, double base, EquipmentSlotGroup ... groups) {
        AttributeInstance instance = new AttributeInstance(attribute, i -> {});
        instance.setBaseValue(base);
        if (stack != null) {
            for (EquipmentSlotGroup group : groups) {
                stack.forEachModifier(group, (attr, mod) -> {
                    if (attr.is(attribute)) {
                        instance.addTransientModifier(mod);
                    }
                });
            }
        }
        return ((Attribute)attribute.value()).sanitizeValue(instance.getValue());
    }

    public static double damage(LivingEntity holder, @Nullable Entity target, ItemStack stack) {
        return ItemUtils.damage(holder.level(), (Entity)holder, target, holder.damageSources().mobAttack(holder), stack);
    }

    public static double damage(Level level, @Nullable Entity holder, @Nullable Entity target, DamageSource defaultSource, ItemStack stack) {
        double d;
        Entity enchantTarget;
        AttributeInstance attributeInstance;
        if (holder instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)holder;
            attributeInstance = living.getAttribute(Attributes.ATTACK_DAMAGE);
        } else {
            attributeInstance = null;
        }
        AttributeInstance attribute = attributeInstance;
        double dmg = ItemUtils.attribute(stack, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, attribute != null ? attribute.getValue() : 1.0, EquipmentSlotGroup.MAINHAND);
        DamageSource damageSource = defaultSource;
        if (stack.getItem() instanceof BowItem) {
            damageSource = level.damageSources().arrow((AbstractArrow)EntityType.ARROW.create(level), holder);
        }
        Entity entity = enchantTarget = target == null ? holder : target;
        if (enchantTarget != null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            d = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)stack, (Entity)enchantTarget, (DamageSource)damageSource, (float)((float)dmg));
        } else {
            d = dmg;
        }
        dmg = d;
        return dmg;
    }
}

